// Compiled by ClojureScript 1.7.228 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27541__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27541__auto__){
return or__27541__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27541__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__32841_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__32841_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__32846 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__32847 = null;
var count__32848 = (0);
var i__32849 = (0);
while(true){
if((i__32849 < count__32848)){
var n = cljs.core._nth.call(null,chunk__32847,i__32849);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__32850 = seq__32846;
var G__32851 = chunk__32847;
var G__32852 = count__32848;
var G__32853 = (i__32849 + (1));
seq__32846 = G__32850;
chunk__32847 = G__32851;
count__32848 = G__32852;
i__32849 = G__32853;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__32846);
if(temp__4425__auto__){
var seq__32846__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32846__$1)){
var c__28344__auto__ = cljs.core.chunk_first.call(null,seq__32846__$1);
var G__32854 = cljs.core.chunk_rest.call(null,seq__32846__$1);
var G__32855 = c__28344__auto__;
var G__32856 = cljs.core.count.call(null,c__28344__auto__);
var G__32857 = (0);
seq__32846 = G__32854;
chunk__32847 = G__32855;
count__32848 = G__32856;
i__32849 = G__32857;
continue;
} else {
var n = cljs.core.first.call(null,seq__32846__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__32858 = cljs.core.next.call(null,seq__32846__$1);
var G__32859 = null;
var G__32860 = (0);
var G__32861 = (0);
seq__32846 = G__32858;
chunk__32847 = G__32859;
count__32848 = G__32860;
i__32849 = G__32861;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__32900_32907 = cljs.core.seq.call(null,deps);
var chunk__32901_32908 = null;
var count__32902_32909 = (0);
var i__32903_32910 = (0);
while(true){
if((i__32903_32910 < count__32902_32909)){
var dep_32911 = cljs.core._nth.call(null,chunk__32901_32908,i__32903_32910);
topo_sort_helper_STAR_.call(null,dep_32911,(depth + (1)),state);

var G__32912 = seq__32900_32907;
var G__32913 = chunk__32901_32908;
var G__32914 = count__32902_32909;
var G__32915 = (i__32903_32910 + (1));
seq__32900_32907 = G__32912;
chunk__32901_32908 = G__32913;
count__32902_32909 = G__32914;
i__32903_32910 = G__32915;
continue;
} else {
var temp__4425__auto___32916 = cljs.core.seq.call(null,seq__32900_32907);
if(temp__4425__auto___32916){
var seq__32900_32917__$1 = temp__4425__auto___32916;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32900_32917__$1)){
var c__28344__auto___32918 = cljs.core.chunk_first.call(null,seq__32900_32917__$1);
var G__32919 = cljs.core.chunk_rest.call(null,seq__32900_32917__$1);
var G__32920 = c__28344__auto___32918;
var G__32921 = cljs.core.count.call(null,c__28344__auto___32918);
var G__32922 = (0);
seq__32900_32907 = G__32919;
chunk__32901_32908 = G__32920;
count__32902_32909 = G__32921;
i__32903_32910 = G__32922;
continue;
} else {
var dep_32923 = cljs.core.first.call(null,seq__32900_32917__$1);
topo_sort_helper_STAR_.call(null,dep_32923,(depth + (1)),state);

var G__32924 = cljs.core.next.call(null,seq__32900_32917__$1);
var G__32925 = null;
var G__32926 = (0);
var G__32927 = (0);
seq__32900_32907 = G__32924;
chunk__32901_32908 = G__32925;
count__32902_32909 = G__32926;
i__32903_32910 = G__32927;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__32904){
var vec__32906 = p__32904;
var x = cljs.core.nth.call(null,vec__32906,(0),null);
var xs = cljs.core.nthnext.call(null,vec__32906,(1));
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__32906,x,xs,get_deps__$1){
return (function (p1__32862_SHARP_){
return clojure.set.difference.call(null,p1__32862_SHARP_,x);
});})(vec__32906,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__32940 = cljs.core.seq.call(null,provides);
var chunk__32941 = null;
var count__32942 = (0);
var i__32943 = (0);
while(true){
if((i__32943 < count__32942)){
var prov = cljs.core._nth.call(null,chunk__32941,i__32943);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__32944_32952 = cljs.core.seq.call(null,requires);
var chunk__32945_32953 = null;
var count__32946_32954 = (0);
var i__32947_32955 = (0);
while(true){
if((i__32947_32955 < count__32946_32954)){
var req_32956 = cljs.core._nth.call(null,chunk__32945_32953,i__32947_32955);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32956,prov);

var G__32957 = seq__32944_32952;
var G__32958 = chunk__32945_32953;
var G__32959 = count__32946_32954;
var G__32960 = (i__32947_32955 + (1));
seq__32944_32952 = G__32957;
chunk__32945_32953 = G__32958;
count__32946_32954 = G__32959;
i__32947_32955 = G__32960;
continue;
} else {
var temp__4425__auto___32961 = cljs.core.seq.call(null,seq__32944_32952);
if(temp__4425__auto___32961){
var seq__32944_32962__$1 = temp__4425__auto___32961;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32944_32962__$1)){
var c__28344__auto___32963 = cljs.core.chunk_first.call(null,seq__32944_32962__$1);
var G__32964 = cljs.core.chunk_rest.call(null,seq__32944_32962__$1);
var G__32965 = c__28344__auto___32963;
var G__32966 = cljs.core.count.call(null,c__28344__auto___32963);
var G__32967 = (0);
seq__32944_32952 = G__32964;
chunk__32945_32953 = G__32965;
count__32946_32954 = G__32966;
i__32947_32955 = G__32967;
continue;
} else {
var req_32968 = cljs.core.first.call(null,seq__32944_32962__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32968,prov);

var G__32969 = cljs.core.next.call(null,seq__32944_32962__$1);
var G__32970 = null;
var G__32971 = (0);
var G__32972 = (0);
seq__32944_32952 = G__32969;
chunk__32945_32953 = G__32970;
count__32946_32954 = G__32971;
i__32947_32955 = G__32972;
continue;
}
} else {
}
}
break;
}

var G__32973 = seq__32940;
var G__32974 = chunk__32941;
var G__32975 = count__32942;
var G__32976 = (i__32943 + (1));
seq__32940 = G__32973;
chunk__32941 = G__32974;
count__32942 = G__32975;
i__32943 = G__32976;
continue;
} else {
var temp__4425__auto__ = cljs.core.seq.call(null,seq__32940);
if(temp__4425__auto__){
var seq__32940__$1 = temp__4425__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32940__$1)){
var c__28344__auto__ = cljs.core.chunk_first.call(null,seq__32940__$1);
var G__32977 = cljs.core.chunk_rest.call(null,seq__32940__$1);
var G__32978 = c__28344__auto__;
var G__32979 = cljs.core.count.call(null,c__28344__auto__);
var G__32980 = (0);
seq__32940 = G__32977;
chunk__32941 = G__32978;
count__32942 = G__32979;
i__32943 = G__32980;
continue;
} else {
var prov = cljs.core.first.call(null,seq__32940__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__32948_32981 = cljs.core.seq.call(null,requires);
var chunk__32949_32982 = null;
var count__32950_32983 = (0);
var i__32951_32984 = (0);
while(true){
if((i__32951_32984 < count__32950_32983)){
var req_32985 = cljs.core._nth.call(null,chunk__32949_32982,i__32951_32984);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32985,prov);

var G__32986 = seq__32948_32981;
var G__32987 = chunk__32949_32982;
var G__32988 = count__32950_32983;
var G__32989 = (i__32951_32984 + (1));
seq__32948_32981 = G__32986;
chunk__32949_32982 = G__32987;
count__32950_32983 = G__32988;
i__32951_32984 = G__32989;
continue;
} else {
var temp__4425__auto___32990__$1 = cljs.core.seq.call(null,seq__32948_32981);
if(temp__4425__auto___32990__$1){
var seq__32948_32991__$1 = temp__4425__auto___32990__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32948_32991__$1)){
var c__28344__auto___32992 = cljs.core.chunk_first.call(null,seq__32948_32991__$1);
var G__32993 = cljs.core.chunk_rest.call(null,seq__32948_32991__$1);
var G__32994 = c__28344__auto___32992;
var G__32995 = cljs.core.count.call(null,c__28344__auto___32992);
var G__32996 = (0);
seq__32948_32981 = G__32993;
chunk__32949_32982 = G__32994;
count__32950_32983 = G__32995;
i__32951_32984 = G__32996;
continue;
} else {
var req_32997 = cljs.core.first.call(null,seq__32948_32991__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_32997,prov);

var G__32998 = cljs.core.next.call(null,seq__32948_32991__$1);
var G__32999 = null;
var G__33000 = (0);
var G__33001 = (0);
seq__32948_32981 = G__32998;
chunk__32949_32982 = G__32999;
count__32950_32983 = G__33000;
i__32951_32984 = G__33001;
continue;
}
} else {
}
}
break;
}

var G__33002 = cljs.core.next.call(null,seq__32940__$1);
var G__33003 = null;
var G__33004 = (0);
var G__33005 = (0);
seq__32940 = G__33002;
chunk__32941 = G__33003;
count__32942 = G__33004;
i__32943 = G__33005;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__33010_33014 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__33011_33015 = null;
var count__33012_33016 = (0);
var i__33013_33017 = (0);
while(true){
if((i__33013_33017 < count__33012_33016)){
var ns_33018 = cljs.core._nth.call(null,chunk__33011_33015,i__33013_33017);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33018);

var G__33019 = seq__33010_33014;
var G__33020 = chunk__33011_33015;
var G__33021 = count__33012_33016;
var G__33022 = (i__33013_33017 + (1));
seq__33010_33014 = G__33019;
chunk__33011_33015 = G__33020;
count__33012_33016 = G__33021;
i__33013_33017 = G__33022;
continue;
} else {
var temp__4425__auto___33023 = cljs.core.seq.call(null,seq__33010_33014);
if(temp__4425__auto___33023){
var seq__33010_33024__$1 = temp__4425__auto___33023;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33010_33024__$1)){
var c__28344__auto___33025 = cljs.core.chunk_first.call(null,seq__33010_33024__$1);
var G__33026 = cljs.core.chunk_rest.call(null,seq__33010_33024__$1);
var G__33027 = c__28344__auto___33025;
var G__33028 = cljs.core.count.call(null,c__28344__auto___33025);
var G__33029 = (0);
seq__33010_33014 = G__33026;
chunk__33011_33015 = G__33027;
count__33012_33016 = G__33028;
i__33013_33017 = G__33029;
continue;
} else {
var ns_33030 = cljs.core.first.call(null,seq__33010_33024__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_33030);

var G__33031 = cljs.core.next.call(null,seq__33010_33024__$1);
var G__33032 = null;
var G__33033 = (0);
var G__33034 = (0);
seq__33010_33014 = G__33031;
chunk__33011_33015 = G__33032;
count__33012_33016 = G__33033;
i__33013_33017 = G__33034;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27541__auto__ = goog.require__;
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__33035__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__33035 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33036__i = 0, G__33036__a = new Array(arguments.length -  0);
while (G__33036__i < G__33036__a.length) {G__33036__a[G__33036__i] = arguments[G__33036__i + 0]; ++G__33036__i;}
  args = new cljs.core.IndexedSeq(G__33036__a,0);
} 
return G__33035__delegate.call(this,args);};
G__33035.cljs$lang$maxFixedArity = 0;
G__33035.cljs$lang$applyTo = (function (arglist__33037){
var args = cljs.core.seq(arglist__33037);
return G__33035__delegate(args);
});
G__33035.cljs$core$IFn$_invoke$arity$variadic = G__33035__delegate;
return G__33035;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__33039 = cljs.core._EQ_;
var expr__33040 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__33039.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__33040))){
var path_parts = ((function (pred__33039,expr__33040){
return (function (p1__33038_SHARP_){
return clojure.string.split.call(null,p1__33038_SHARP_,/[\/\\]/);
});})(pred__33039,expr__33040))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__33039,expr__33040){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e33042){if((e33042 instanceof Error)){
var e = e33042;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e33042;

}
}})());
});
;})(path_parts,sep,root,pred__33039,expr__33040))
} else {
if(cljs.core.truth_(pred__33039.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__33040))){
return ((function (pred__33039,expr__33040){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__33039,expr__33040){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__33039,expr__33040))
);

return deferred.addErrback(((function (deferred,pred__33039,expr__33040){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__33039,expr__33040))
);
});
;})(pred__33039,expr__33040))
} else {
return ((function (pred__33039,expr__33040){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__33039,expr__33040))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__33043,callback){
var map__33046 = p__33043;
var map__33046__$1 = ((((!((map__33046 == null)))?((((map__33046.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33046.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33046):map__33046);
var file_msg = map__33046__$1;
var request_url = cljs.core.get.call(null,map__33046__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__33046,map__33046__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__33046,map__33046__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__){
return (function (state_33070){
var state_val_33071 = (state_33070[(1)]);
if((state_val_33071 === (7))){
var inst_33066 = (state_33070[(2)]);
var state_33070__$1 = state_33070;
var statearr_33072_33092 = state_33070__$1;
(statearr_33072_33092[(2)] = inst_33066);

(statearr_33072_33092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (1))){
var state_33070__$1 = state_33070;
var statearr_33073_33093 = state_33070__$1;
(statearr_33073_33093[(2)] = null);

(statearr_33073_33093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (4))){
var inst_33050 = (state_33070[(7)]);
var inst_33050__$1 = (state_33070[(2)]);
var state_33070__$1 = (function (){var statearr_33074 = state_33070;
(statearr_33074[(7)] = inst_33050__$1);

return statearr_33074;
})();
if(cljs.core.truth_(inst_33050__$1)){
var statearr_33075_33094 = state_33070__$1;
(statearr_33075_33094[(1)] = (5));

} else {
var statearr_33076_33095 = state_33070__$1;
(statearr_33076_33095[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (6))){
var state_33070__$1 = state_33070;
var statearr_33077_33096 = state_33070__$1;
(statearr_33077_33096[(2)] = null);

(statearr_33077_33096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (3))){
var inst_33068 = (state_33070[(2)]);
var state_33070__$1 = state_33070;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33070__$1,inst_33068);
} else {
if((state_val_33071 === (2))){
var state_33070__$1 = state_33070;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33070__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_33071 === (11))){
var inst_33062 = (state_33070[(2)]);
var state_33070__$1 = (function (){var statearr_33078 = state_33070;
(statearr_33078[(8)] = inst_33062);

return statearr_33078;
})();
var statearr_33079_33097 = state_33070__$1;
(statearr_33079_33097[(2)] = null);

(statearr_33079_33097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (9))){
var inst_33054 = (state_33070[(9)]);
var inst_33056 = (state_33070[(10)]);
var inst_33058 = inst_33056.call(null,inst_33054);
var state_33070__$1 = state_33070;
var statearr_33080_33098 = state_33070__$1;
(statearr_33080_33098[(2)] = inst_33058);

(statearr_33080_33098[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (5))){
var inst_33050 = (state_33070[(7)]);
var inst_33052 = figwheel.client.file_reloading.blocking_load.call(null,inst_33050);
var state_33070__$1 = state_33070;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33070__$1,(8),inst_33052);
} else {
if((state_val_33071 === (10))){
var inst_33054 = (state_33070[(9)]);
var inst_33060 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_33054);
var state_33070__$1 = state_33070;
var statearr_33081_33099 = state_33070__$1;
(statearr_33081_33099[(2)] = inst_33060);

(statearr_33081_33099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33071 === (8))){
var inst_33050 = (state_33070[(7)]);
var inst_33056 = (state_33070[(10)]);
var inst_33054 = (state_33070[(2)]);
var inst_33055 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_33056__$1 = cljs.core.get.call(null,inst_33055,inst_33050);
var state_33070__$1 = (function (){var statearr_33082 = state_33070;
(statearr_33082[(9)] = inst_33054);

(statearr_33082[(10)] = inst_33056__$1);

return statearr_33082;
})();
if(cljs.core.truth_(inst_33056__$1)){
var statearr_33083_33100 = state_33070__$1;
(statearr_33083_33100[(1)] = (9));

} else {
var statearr_33084_33101 = state_33070__$1;
(statearr_33084_33101[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__))
;
return ((function (switch__29786__auto__,c__29898__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__29787__auto__ = null;
var figwheel$client$file_reloading$state_machine__29787__auto____0 = (function (){
var statearr_33088 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33088[(0)] = figwheel$client$file_reloading$state_machine__29787__auto__);

(statearr_33088[(1)] = (1));

return statearr_33088;
});
var figwheel$client$file_reloading$state_machine__29787__auto____1 = (function (state_33070){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_33070);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e33089){if((e33089 instanceof Object)){
var ex__29790__auto__ = e33089;
var statearr_33090_33102 = state_33070;
(statearr_33090_33102[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33070);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33089;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33103 = state_33070;
state_33070 = G__33103;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__29787__auto__ = function(state_33070){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__29787__auto____1.call(this,state_33070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__29787__auto____0;
figwheel$client$file_reloading$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__29787__auto____1;
return figwheel$client$file_reloading$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__))
})();
var state__29900__auto__ = (function (){var statearr_33091 = f__29899__auto__.call(null);
(statearr_33091[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_33091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__))
);

return c__29898__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__33104,callback){
var map__33107 = p__33104;
var map__33107__$1 = ((((!((map__33107 == null)))?((((map__33107.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33107.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33107):map__33107);
var file_msg = map__33107__$1;
var namespace = cljs.core.get.call(null,map__33107__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__33107,map__33107__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__33107,map__33107__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__33109){
var map__33112 = p__33109;
var map__33112__$1 = ((((!((map__33112 == null)))?((((map__33112.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33112.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33112):map__33112);
var file_msg = map__33112__$1;
var namespace = cljs.core.get.call(null,map__33112__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27529__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__27529__auto__){
var or__27541__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
var or__27541__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27541__auto____$1)){
return or__27541__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27529__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__33114,callback){
var map__33117 = p__33114;
var map__33117__$1 = ((((!((map__33117 == null)))?((((map__33117.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33117.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33117):map__33117);
var file_msg = map__33117__$1;
var request_url = cljs.core.get.call(null,map__33117__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__33117__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__29898__auto___33205 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___33205,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___33205,out){
return (function (state_33187){
var state_val_33188 = (state_33187[(1)]);
if((state_val_33188 === (1))){
var inst_33165 = cljs.core.nth.call(null,files,(0),null);
var inst_33166 = cljs.core.nthnext.call(null,files,(1));
var inst_33167 = files;
var state_33187__$1 = (function (){var statearr_33189 = state_33187;
(statearr_33189[(7)] = inst_33165);

(statearr_33189[(8)] = inst_33167);

(statearr_33189[(9)] = inst_33166);

return statearr_33189;
})();
var statearr_33190_33206 = state_33187__$1;
(statearr_33190_33206[(2)] = null);

(statearr_33190_33206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33188 === (2))){
var inst_33167 = (state_33187[(8)]);
var inst_33170 = (state_33187[(10)]);
var inst_33170__$1 = cljs.core.nth.call(null,inst_33167,(0),null);
var inst_33171 = cljs.core.nthnext.call(null,inst_33167,(1));
var inst_33172 = (inst_33170__$1 == null);
var inst_33173 = cljs.core.not.call(null,inst_33172);
var state_33187__$1 = (function (){var statearr_33191 = state_33187;
(statearr_33191[(11)] = inst_33171);

(statearr_33191[(10)] = inst_33170__$1);

return statearr_33191;
})();
if(inst_33173){
var statearr_33192_33207 = state_33187__$1;
(statearr_33192_33207[(1)] = (4));

} else {
var statearr_33193_33208 = state_33187__$1;
(statearr_33193_33208[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33188 === (3))){
var inst_33185 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33187__$1,inst_33185);
} else {
if((state_val_33188 === (4))){
var inst_33170 = (state_33187[(10)]);
var inst_33175 = figwheel.client.file_reloading.reload_js_file.call(null,inst_33170);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33187__$1,(7),inst_33175);
} else {
if((state_val_33188 === (5))){
var inst_33181 = cljs.core.async.close_BANG_.call(null,out);
var state_33187__$1 = state_33187;
var statearr_33194_33209 = state_33187__$1;
(statearr_33194_33209[(2)] = inst_33181);

(statearr_33194_33209[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33188 === (6))){
var inst_33183 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33195_33210 = state_33187__$1;
(statearr_33195_33210[(2)] = inst_33183);

(statearr_33195_33210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33188 === (7))){
var inst_33171 = (state_33187[(11)]);
var inst_33177 = (state_33187[(2)]);
var inst_33178 = cljs.core.async.put_BANG_.call(null,out,inst_33177);
var inst_33167 = inst_33171;
var state_33187__$1 = (function (){var statearr_33196 = state_33187;
(statearr_33196[(12)] = inst_33178);

(statearr_33196[(8)] = inst_33167);

return statearr_33196;
})();
var statearr_33197_33211 = state_33187__$1;
(statearr_33197_33211[(2)] = null);

(statearr_33197_33211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__29898__auto___33205,out))
;
return ((function (switch__29786__auto__,c__29898__auto___33205,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto____0 = (function (){
var statearr_33201 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33201[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto__);

(statearr_33201[(1)] = (1));

return statearr_33201;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto____1 = (function (state_33187){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_33187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e33202){if((e33202 instanceof Object)){
var ex__29790__auto__ = e33202;
var statearr_33203_33212 = state_33187;
(statearr_33203_33212[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33187);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33202;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33213 = state_33187;
state_33187 = G__33213;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto__ = function(state_33187){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto____1.call(this,state_33187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___33205,out))
})();
var state__29900__auto__ = (function (){var statearr_33204 = f__29899__auto__.call(null);
(statearr_33204[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___33205);

return statearr_33204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___33205,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__33214,opts){
var map__33218 = p__33214;
var map__33218__$1 = ((((!((map__33218 == null)))?((((map__33218.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33218.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33218):map__33218);
var eval_body__$1 = cljs.core.get.call(null,map__33218__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__33218__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27529__auto__ = eval_body__$1;
if(cljs.core.truth_(and__27529__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__27529__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e33220){var e = e33220;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4423__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__33221_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33221_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4423__auto__)){
var file_msg = temp__4423__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__33226){
var vec__33227 = p__33226;
var k = cljs.core.nth.call(null,vec__33227,(0),null);
var v = cljs.core.nth.call(null,vec__33227,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__33228){
var vec__33229 = p__33228;
var k = cljs.core.nth.call(null,vec__33229,(0),null);
var v = cljs.core.nth.call(null,vec__33229,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__33233,p__33234){
var map__33481 = p__33233;
var map__33481__$1 = ((((!((map__33481 == null)))?((((map__33481.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33481.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33481):map__33481);
var opts = map__33481__$1;
var before_jsload = cljs.core.get.call(null,map__33481__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__33481__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__33481__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__33482 = p__33234;
var map__33482__$1 = ((((!((map__33482 == null)))?((((map__33482.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33482.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33482):map__33482);
var msg = map__33482__$1;
var files = cljs.core.get.call(null,map__33482__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__33482__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__33482__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_33635){
var state_val_33636 = (state_33635[(1)]);
if((state_val_33636 === (7))){
var inst_33496 = (state_33635[(7)]);
var inst_33497 = (state_33635[(8)]);
var inst_33499 = (state_33635[(9)]);
var inst_33498 = (state_33635[(10)]);
var inst_33504 = cljs.core._nth.call(null,inst_33497,inst_33499);
var inst_33505 = figwheel.client.file_reloading.eval_body.call(null,inst_33504,opts);
var inst_33506 = (inst_33499 + (1));
var tmp33637 = inst_33496;
var tmp33638 = inst_33497;
var tmp33639 = inst_33498;
var inst_33496__$1 = tmp33637;
var inst_33497__$1 = tmp33638;
var inst_33498__$1 = tmp33639;
var inst_33499__$1 = inst_33506;
var state_33635__$1 = (function (){var statearr_33640 = state_33635;
(statearr_33640[(11)] = inst_33505);

(statearr_33640[(7)] = inst_33496__$1);

(statearr_33640[(8)] = inst_33497__$1);

(statearr_33640[(9)] = inst_33499__$1);

(statearr_33640[(10)] = inst_33498__$1);

return statearr_33640;
})();
var statearr_33641_33727 = state_33635__$1;
(statearr_33641_33727[(2)] = null);

(statearr_33641_33727[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (20))){
var inst_33539 = (state_33635[(12)]);
var inst_33547 = figwheel.client.file_reloading.sort_files.call(null,inst_33539);
var state_33635__$1 = state_33635;
var statearr_33642_33728 = state_33635__$1;
(statearr_33642_33728[(2)] = inst_33547);

(statearr_33642_33728[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (27))){
var state_33635__$1 = state_33635;
var statearr_33643_33729 = state_33635__$1;
(statearr_33643_33729[(2)] = null);

(statearr_33643_33729[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (1))){
var inst_33488 = (state_33635[(13)]);
var inst_33485 = before_jsload.call(null,files);
var inst_33486 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_33487 = (function (){return ((function (inst_33488,inst_33485,inst_33486,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33230_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33230_SHARP_);
});
;})(inst_33488,inst_33485,inst_33486,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33488__$1 = cljs.core.filter.call(null,inst_33487,files);
var inst_33489 = cljs.core.not_empty.call(null,inst_33488__$1);
var state_33635__$1 = (function (){var statearr_33644 = state_33635;
(statearr_33644[(14)] = inst_33485);

(statearr_33644[(13)] = inst_33488__$1);

(statearr_33644[(15)] = inst_33486);

return statearr_33644;
})();
if(cljs.core.truth_(inst_33489)){
var statearr_33645_33730 = state_33635__$1;
(statearr_33645_33730[(1)] = (2));

} else {
var statearr_33646_33731 = state_33635__$1;
(statearr_33646_33731[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (24))){
var state_33635__$1 = state_33635;
var statearr_33647_33732 = state_33635__$1;
(statearr_33647_33732[(2)] = null);

(statearr_33647_33732[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (39))){
var inst_33589 = (state_33635[(16)]);
var state_33635__$1 = state_33635;
var statearr_33648_33733 = state_33635__$1;
(statearr_33648_33733[(2)] = inst_33589);

(statearr_33648_33733[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (46))){
var inst_33630 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
var statearr_33649_33734 = state_33635__$1;
(statearr_33649_33734[(2)] = inst_33630);

(statearr_33649_33734[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (4))){
var inst_33533 = (state_33635[(2)]);
var inst_33534 = cljs.core.List.EMPTY;
var inst_33535 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_33534);
var inst_33536 = (function (){return ((function (inst_33533,inst_33534,inst_33535,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33231_SHARP_){
var and__27529__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__33231_SHARP_);
if(cljs.core.truth_(and__27529__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__33231_SHARP_));
} else {
return and__27529__auto__;
}
});
;})(inst_33533,inst_33534,inst_33535,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33537 = cljs.core.filter.call(null,inst_33536,files);
var inst_33538 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_33539 = cljs.core.concat.call(null,inst_33537,inst_33538);
var state_33635__$1 = (function (){var statearr_33650 = state_33635;
(statearr_33650[(12)] = inst_33539);

(statearr_33650[(17)] = inst_33535);

(statearr_33650[(18)] = inst_33533);

return statearr_33650;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_33651_33735 = state_33635__$1;
(statearr_33651_33735[(1)] = (16));

} else {
var statearr_33652_33736 = state_33635__$1;
(statearr_33652_33736[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (15))){
var inst_33523 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
var statearr_33653_33737 = state_33635__$1;
(statearr_33653_33737[(2)] = inst_33523);

(statearr_33653_33737[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (21))){
var inst_33549 = (state_33635[(19)]);
var inst_33549__$1 = (state_33635[(2)]);
var inst_33550 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_33549__$1);
var state_33635__$1 = (function (){var statearr_33654 = state_33635;
(statearr_33654[(19)] = inst_33549__$1);

return statearr_33654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33635__$1,(22),inst_33550);
} else {
if((state_val_33636 === (31))){
var inst_33633 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33635__$1,inst_33633);
} else {
if((state_val_33636 === (32))){
var inst_33589 = (state_33635[(16)]);
var inst_33594 = inst_33589.cljs$lang$protocol_mask$partition0$;
var inst_33595 = (inst_33594 & (64));
var inst_33596 = inst_33589.cljs$core$ISeq$;
var inst_33597 = (inst_33595) || (inst_33596);
var state_33635__$1 = state_33635;
if(cljs.core.truth_(inst_33597)){
var statearr_33655_33738 = state_33635__$1;
(statearr_33655_33738[(1)] = (35));

} else {
var statearr_33656_33739 = state_33635__$1;
(statearr_33656_33739[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (40))){
var inst_33610 = (state_33635[(20)]);
var inst_33609 = (state_33635[(2)]);
var inst_33610__$1 = cljs.core.get.call(null,inst_33609,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_33611 = cljs.core.get.call(null,inst_33609,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_33612 = cljs.core.not_empty.call(null,inst_33610__$1);
var state_33635__$1 = (function (){var statearr_33657 = state_33635;
(statearr_33657[(20)] = inst_33610__$1);

(statearr_33657[(21)] = inst_33611);

return statearr_33657;
})();
if(cljs.core.truth_(inst_33612)){
var statearr_33658_33740 = state_33635__$1;
(statearr_33658_33740[(1)] = (41));

} else {
var statearr_33659_33741 = state_33635__$1;
(statearr_33659_33741[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (33))){
var state_33635__$1 = state_33635;
var statearr_33660_33742 = state_33635__$1;
(statearr_33660_33742[(2)] = false);

(statearr_33660_33742[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (13))){
var inst_33509 = (state_33635[(22)]);
var inst_33513 = cljs.core.chunk_first.call(null,inst_33509);
var inst_33514 = cljs.core.chunk_rest.call(null,inst_33509);
var inst_33515 = cljs.core.count.call(null,inst_33513);
var inst_33496 = inst_33514;
var inst_33497 = inst_33513;
var inst_33498 = inst_33515;
var inst_33499 = (0);
var state_33635__$1 = (function (){var statearr_33661 = state_33635;
(statearr_33661[(7)] = inst_33496);

(statearr_33661[(8)] = inst_33497);

(statearr_33661[(9)] = inst_33499);

(statearr_33661[(10)] = inst_33498);

return statearr_33661;
})();
var statearr_33662_33743 = state_33635__$1;
(statearr_33662_33743[(2)] = null);

(statearr_33662_33743[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (22))){
var inst_33552 = (state_33635[(23)]);
var inst_33549 = (state_33635[(19)]);
var inst_33553 = (state_33635[(24)]);
var inst_33557 = (state_33635[(25)]);
var inst_33552__$1 = (state_33635[(2)]);
var inst_33553__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_33552__$1);
var inst_33554 = (function (){var all_files = inst_33549;
var res_SINGLEQUOTE_ = inst_33552__$1;
var res = inst_33553__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_33552,inst_33549,inst_33553,inst_33557,inst_33552__$1,inst_33553__$1,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__33232_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__33232_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_33552,inst_33549,inst_33553,inst_33557,inst_33552__$1,inst_33553__$1,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33555 = cljs.core.filter.call(null,inst_33554,inst_33552__$1);
var inst_33556 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_33557__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_33556);
var inst_33558 = cljs.core.not_empty.call(null,inst_33557__$1);
var state_33635__$1 = (function (){var statearr_33663 = state_33635;
(statearr_33663[(23)] = inst_33552__$1);

(statearr_33663[(24)] = inst_33553__$1);

(statearr_33663[(25)] = inst_33557__$1);

(statearr_33663[(26)] = inst_33555);

return statearr_33663;
})();
if(cljs.core.truth_(inst_33558)){
var statearr_33664_33744 = state_33635__$1;
(statearr_33664_33744[(1)] = (23));

} else {
var statearr_33665_33745 = state_33635__$1;
(statearr_33665_33745[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (36))){
var state_33635__$1 = state_33635;
var statearr_33666_33746 = state_33635__$1;
(statearr_33666_33746[(2)] = false);

(statearr_33666_33746[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (41))){
var inst_33610 = (state_33635[(20)]);
var inst_33614 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_33615 = cljs.core.map.call(null,inst_33614,inst_33610);
var inst_33616 = cljs.core.pr_str.call(null,inst_33615);
var inst_33617 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_33616)].join('');
var inst_33618 = figwheel.client.utils.log.call(null,inst_33617);
var state_33635__$1 = state_33635;
var statearr_33667_33747 = state_33635__$1;
(statearr_33667_33747[(2)] = inst_33618);

(statearr_33667_33747[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (43))){
var inst_33611 = (state_33635[(21)]);
var inst_33621 = (state_33635[(2)]);
var inst_33622 = cljs.core.not_empty.call(null,inst_33611);
var state_33635__$1 = (function (){var statearr_33668 = state_33635;
(statearr_33668[(27)] = inst_33621);

return statearr_33668;
})();
if(cljs.core.truth_(inst_33622)){
var statearr_33669_33748 = state_33635__$1;
(statearr_33669_33748[(1)] = (44));

} else {
var statearr_33670_33749 = state_33635__$1;
(statearr_33670_33749[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (29))){
var inst_33552 = (state_33635[(23)]);
var inst_33589 = (state_33635[(16)]);
var inst_33549 = (state_33635[(19)]);
var inst_33553 = (state_33635[(24)]);
var inst_33557 = (state_33635[(25)]);
var inst_33555 = (state_33635[(26)]);
var inst_33585 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_33588 = (function (){var all_files = inst_33549;
var res_SINGLEQUOTE_ = inst_33552;
var res = inst_33553;
var files_not_loaded = inst_33555;
var dependencies_that_loaded = inst_33557;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33589,inst_33549,inst_33553,inst_33557,inst_33555,inst_33585,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33587){
var map__33671 = p__33587;
var map__33671__$1 = ((((!((map__33671 == null)))?((((map__33671.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33671.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33671):map__33671);
var namespace = cljs.core.get.call(null,map__33671__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33589,inst_33549,inst_33553,inst_33557,inst_33555,inst_33585,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33589__$1 = cljs.core.group_by.call(null,inst_33588,inst_33555);
var inst_33591 = (inst_33589__$1 == null);
var inst_33592 = cljs.core.not.call(null,inst_33591);
var state_33635__$1 = (function (){var statearr_33673 = state_33635;
(statearr_33673[(16)] = inst_33589__$1);

(statearr_33673[(28)] = inst_33585);

return statearr_33673;
})();
if(inst_33592){
var statearr_33674_33750 = state_33635__$1;
(statearr_33674_33750[(1)] = (32));

} else {
var statearr_33675_33751 = state_33635__$1;
(statearr_33675_33751[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (44))){
var inst_33611 = (state_33635[(21)]);
var inst_33624 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_33611);
var inst_33625 = cljs.core.pr_str.call(null,inst_33624);
var inst_33626 = [cljs.core.str("not required: "),cljs.core.str(inst_33625)].join('');
var inst_33627 = figwheel.client.utils.log.call(null,inst_33626);
var state_33635__$1 = state_33635;
var statearr_33676_33752 = state_33635__$1;
(statearr_33676_33752[(2)] = inst_33627);

(statearr_33676_33752[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (6))){
var inst_33530 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
var statearr_33677_33753 = state_33635__$1;
(statearr_33677_33753[(2)] = inst_33530);

(statearr_33677_33753[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (28))){
var inst_33555 = (state_33635[(26)]);
var inst_33582 = (state_33635[(2)]);
var inst_33583 = cljs.core.not_empty.call(null,inst_33555);
var state_33635__$1 = (function (){var statearr_33678 = state_33635;
(statearr_33678[(29)] = inst_33582);

return statearr_33678;
})();
if(cljs.core.truth_(inst_33583)){
var statearr_33679_33754 = state_33635__$1;
(statearr_33679_33754[(1)] = (29));

} else {
var statearr_33680_33755 = state_33635__$1;
(statearr_33680_33755[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (25))){
var inst_33553 = (state_33635[(24)]);
var inst_33569 = (state_33635[(2)]);
var inst_33570 = cljs.core.not_empty.call(null,inst_33553);
var state_33635__$1 = (function (){var statearr_33681 = state_33635;
(statearr_33681[(30)] = inst_33569);

return statearr_33681;
})();
if(cljs.core.truth_(inst_33570)){
var statearr_33682_33756 = state_33635__$1;
(statearr_33682_33756[(1)] = (26));

} else {
var statearr_33683_33757 = state_33635__$1;
(statearr_33683_33757[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (34))){
var inst_33604 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
if(cljs.core.truth_(inst_33604)){
var statearr_33684_33758 = state_33635__$1;
(statearr_33684_33758[(1)] = (38));

} else {
var statearr_33685_33759 = state_33635__$1;
(statearr_33685_33759[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (17))){
var state_33635__$1 = state_33635;
var statearr_33686_33760 = state_33635__$1;
(statearr_33686_33760[(2)] = recompile_dependents);

(statearr_33686_33760[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (3))){
var state_33635__$1 = state_33635;
var statearr_33687_33761 = state_33635__$1;
(statearr_33687_33761[(2)] = null);

(statearr_33687_33761[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (12))){
var inst_33526 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
var statearr_33688_33762 = state_33635__$1;
(statearr_33688_33762[(2)] = inst_33526);

(statearr_33688_33762[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (2))){
var inst_33488 = (state_33635[(13)]);
var inst_33495 = cljs.core.seq.call(null,inst_33488);
var inst_33496 = inst_33495;
var inst_33497 = null;
var inst_33498 = (0);
var inst_33499 = (0);
var state_33635__$1 = (function (){var statearr_33689 = state_33635;
(statearr_33689[(7)] = inst_33496);

(statearr_33689[(8)] = inst_33497);

(statearr_33689[(9)] = inst_33499);

(statearr_33689[(10)] = inst_33498);

return statearr_33689;
})();
var statearr_33690_33763 = state_33635__$1;
(statearr_33690_33763[(2)] = null);

(statearr_33690_33763[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (23))){
var inst_33552 = (state_33635[(23)]);
var inst_33549 = (state_33635[(19)]);
var inst_33553 = (state_33635[(24)]);
var inst_33557 = (state_33635[(25)]);
var inst_33555 = (state_33635[(26)]);
var inst_33560 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_33562 = (function (){var all_files = inst_33549;
var res_SINGLEQUOTE_ = inst_33552;
var res = inst_33553;
var files_not_loaded = inst_33555;
var dependencies_that_loaded = inst_33557;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33549,inst_33553,inst_33557,inst_33555,inst_33560,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33561){
var map__33691 = p__33561;
var map__33691__$1 = ((((!((map__33691 == null)))?((((map__33691.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33691.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33691):map__33691);
var request_url = cljs.core.get.call(null,map__33691__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33549,inst_33553,inst_33557,inst_33555,inst_33560,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33563 = cljs.core.reverse.call(null,inst_33557);
var inst_33564 = cljs.core.map.call(null,inst_33562,inst_33563);
var inst_33565 = cljs.core.pr_str.call(null,inst_33564);
var inst_33566 = figwheel.client.utils.log.call(null,inst_33565);
var state_33635__$1 = (function (){var statearr_33693 = state_33635;
(statearr_33693[(31)] = inst_33560);

return statearr_33693;
})();
var statearr_33694_33764 = state_33635__$1;
(statearr_33694_33764[(2)] = inst_33566);

(statearr_33694_33764[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (35))){
var state_33635__$1 = state_33635;
var statearr_33695_33765 = state_33635__$1;
(statearr_33695_33765[(2)] = true);

(statearr_33695_33765[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (19))){
var inst_33539 = (state_33635[(12)]);
var inst_33545 = figwheel.client.file_reloading.expand_files.call(null,inst_33539);
var state_33635__$1 = state_33635;
var statearr_33696_33766 = state_33635__$1;
(statearr_33696_33766[(2)] = inst_33545);

(statearr_33696_33766[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (11))){
var state_33635__$1 = state_33635;
var statearr_33697_33767 = state_33635__$1;
(statearr_33697_33767[(2)] = null);

(statearr_33697_33767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (9))){
var inst_33528 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
var statearr_33698_33768 = state_33635__$1;
(statearr_33698_33768[(2)] = inst_33528);

(statearr_33698_33768[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (5))){
var inst_33499 = (state_33635[(9)]);
var inst_33498 = (state_33635[(10)]);
var inst_33501 = (inst_33499 < inst_33498);
var inst_33502 = inst_33501;
var state_33635__$1 = state_33635;
if(cljs.core.truth_(inst_33502)){
var statearr_33699_33769 = state_33635__$1;
(statearr_33699_33769[(1)] = (7));

} else {
var statearr_33700_33770 = state_33635__$1;
(statearr_33700_33770[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (14))){
var inst_33509 = (state_33635[(22)]);
var inst_33518 = cljs.core.first.call(null,inst_33509);
var inst_33519 = figwheel.client.file_reloading.eval_body.call(null,inst_33518,opts);
var inst_33520 = cljs.core.next.call(null,inst_33509);
var inst_33496 = inst_33520;
var inst_33497 = null;
var inst_33498 = (0);
var inst_33499 = (0);
var state_33635__$1 = (function (){var statearr_33701 = state_33635;
(statearr_33701[(32)] = inst_33519);

(statearr_33701[(7)] = inst_33496);

(statearr_33701[(8)] = inst_33497);

(statearr_33701[(9)] = inst_33499);

(statearr_33701[(10)] = inst_33498);

return statearr_33701;
})();
var statearr_33702_33771 = state_33635__$1;
(statearr_33702_33771[(2)] = null);

(statearr_33702_33771[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (45))){
var state_33635__$1 = state_33635;
var statearr_33703_33772 = state_33635__$1;
(statearr_33703_33772[(2)] = null);

(statearr_33703_33772[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (26))){
var inst_33552 = (state_33635[(23)]);
var inst_33549 = (state_33635[(19)]);
var inst_33553 = (state_33635[(24)]);
var inst_33557 = (state_33635[(25)]);
var inst_33555 = (state_33635[(26)]);
var inst_33572 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_33574 = (function (){var all_files = inst_33549;
var res_SINGLEQUOTE_ = inst_33552;
var res = inst_33553;
var files_not_loaded = inst_33555;
var dependencies_that_loaded = inst_33557;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33549,inst_33553,inst_33557,inst_33555,inst_33572,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__33573){
var map__33704 = p__33573;
var map__33704__$1 = ((((!((map__33704 == null)))?((((map__33704.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33704.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33704):map__33704);
var namespace = cljs.core.get.call(null,map__33704__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__33704__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33549,inst_33553,inst_33557,inst_33555,inst_33572,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33575 = cljs.core.map.call(null,inst_33574,inst_33553);
var inst_33576 = cljs.core.pr_str.call(null,inst_33575);
var inst_33577 = figwheel.client.utils.log.call(null,inst_33576);
var inst_33578 = (function (){var all_files = inst_33549;
var res_SINGLEQUOTE_ = inst_33552;
var res = inst_33553;
var files_not_loaded = inst_33555;
var dependencies_that_loaded = inst_33557;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33549,inst_33553,inst_33557,inst_33555,inst_33572,inst_33574,inst_33575,inst_33576,inst_33577,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_33552,inst_33549,inst_33553,inst_33557,inst_33555,inst_33572,inst_33574,inst_33575,inst_33576,inst_33577,state_val_33636,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_33579 = setTimeout(inst_33578,(10));
var state_33635__$1 = (function (){var statearr_33706 = state_33635;
(statearr_33706[(33)] = inst_33572);

(statearr_33706[(34)] = inst_33577);

return statearr_33706;
})();
var statearr_33707_33773 = state_33635__$1;
(statearr_33707_33773[(2)] = inst_33579);

(statearr_33707_33773[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (16))){
var state_33635__$1 = state_33635;
var statearr_33708_33774 = state_33635__$1;
(statearr_33708_33774[(2)] = reload_dependents);

(statearr_33708_33774[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (38))){
var inst_33589 = (state_33635[(16)]);
var inst_33606 = cljs.core.apply.call(null,cljs.core.hash_map,inst_33589);
var state_33635__$1 = state_33635;
var statearr_33709_33775 = state_33635__$1;
(statearr_33709_33775[(2)] = inst_33606);

(statearr_33709_33775[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (30))){
var state_33635__$1 = state_33635;
var statearr_33710_33776 = state_33635__$1;
(statearr_33710_33776[(2)] = null);

(statearr_33710_33776[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (10))){
var inst_33509 = (state_33635[(22)]);
var inst_33511 = cljs.core.chunked_seq_QMARK_.call(null,inst_33509);
var state_33635__$1 = state_33635;
if(inst_33511){
var statearr_33711_33777 = state_33635__$1;
(statearr_33711_33777[(1)] = (13));

} else {
var statearr_33712_33778 = state_33635__$1;
(statearr_33712_33778[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (18))){
var inst_33543 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
if(cljs.core.truth_(inst_33543)){
var statearr_33713_33779 = state_33635__$1;
(statearr_33713_33779[(1)] = (19));

} else {
var statearr_33714_33780 = state_33635__$1;
(statearr_33714_33780[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (42))){
var state_33635__$1 = state_33635;
var statearr_33715_33781 = state_33635__$1;
(statearr_33715_33781[(2)] = null);

(statearr_33715_33781[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (37))){
var inst_33601 = (state_33635[(2)]);
var state_33635__$1 = state_33635;
var statearr_33716_33782 = state_33635__$1;
(statearr_33716_33782[(2)] = inst_33601);

(statearr_33716_33782[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33636 === (8))){
var inst_33509 = (state_33635[(22)]);
var inst_33496 = (state_33635[(7)]);
var inst_33509__$1 = cljs.core.seq.call(null,inst_33496);
var state_33635__$1 = (function (){var statearr_33717 = state_33635;
(statearr_33717[(22)] = inst_33509__$1);

return statearr_33717;
})();
if(inst_33509__$1){
var statearr_33718_33783 = state_33635__$1;
(statearr_33718_33783[(1)] = (10));

} else {
var statearr_33719_33784 = state_33635__$1;
(statearr_33719_33784[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__29786__auto__,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto____0 = (function (){
var statearr_33723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33723[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto__);

(statearr_33723[(1)] = (1));

return statearr_33723;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto____1 = (function (state_33635){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_33635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e33724){if((e33724 instanceof Object)){
var ex__29790__auto__ = e33724;
var statearr_33725_33785 = state_33635;
(statearr_33725_33785[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33635);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33724;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33786 = state_33635;
state_33635 = G__33786;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto__ = function(state_33635){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto____1.call(this,state_33635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__29900__auto__ = (function (){var statearr_33726 = f__29899__auto__.call(null);
(statearr_33726[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_33726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__,map__33481,map__33481__$1,opts,before_jsload,on_jsload,reload_dependents,map__33482,map__33482__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__29898__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__33789,link){
var map__33792 = p__33789;
var map__33792__$1 = ((((!((map__33792 == null)))?((((map__33792.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33792.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33792):map__33792);
var file = cljs.core.get.call(null,map__33792__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = link.href;
if(cljs.core.truth_(temp__4425__auto__)){
var link_href = temp__4425__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4425__auto__,map__33792,map__33792__$1,file){
return (function (p1__33787_SHARP_,p2__33788_SHARP_){
if(cljs.core._EQ_.call(null,p1__33787_SHARP_,p2__33788_SHARP_)){
return p1__33787_SHARP_;
} else {
return false;
}
});})(link_href,temp__4425__auto__,map__33792,map__33792__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4425__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__33798){
var map__33799 = p__33798;
var map__33799__$1 = ((((!((map__33799 == null)))?((((map__33799.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33799.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33799):map__33799);
var match_length = cljs.core.get.call(null,map__33799__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__33799__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__33794_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__33794_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4425__auto__)){
var res = temp__4425__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args33801 = [];
var len__28599__auto___33804 = arguments.length;
var i__28600__auto___33805 = (0);
while(true){
if((i__28600__auto___33805 < len__28599__auto___33804)){
args33801.push((arguments[i__28600__auto___33805]));

var G__33806 = (i__28600__auto___33805 + (1));
i__28600__auto___33805 = G__33806;
continue;
} else {
}
break;
}

var G__33803 = args33801.length;
switch (G__33803) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33801.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;
figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__33808_SHARP_,p2__33809_SHARP_){
return cljs.core.assoc.call(null,p1__33808_SHARP_,cljs.core.get.call(null,p2__33809_SHARP_,key),p2__33809_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__33810){
var map__33813 = p__33810;
var map__33813__$1 = ((((!((map__33813 == null)))?((((map__33813.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33813.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33813):map__33813);
var f_data = map__33813__$1;
var file = cljs.core.get.call(null,map__33813__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4425__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4425__auto__)){
var link = temp__4425__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__33815,files_msg){
var map__33822 = p__33815;
var map__33822__$1 = ((((!((map__33822 == null)))?((((map__33822.cljs$lang$protocol_mask$partition0$ & (64))) || (map__33822.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33822):map__33822);
var opts = map__33822__$1;
var on_cssload = cljs.core.get.call(null,map__33822__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__33824_33828 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__33825_33829 = null;
var count__33826_33830 = (0);
var i__33827_33831 = (0);
while(true){
if((i__33827_33831 < count__33826_33830)){
var f_33832 = cljs.core._nth.call(null,chunk__33825_33829,i__33827_33831);
figwheel.client.file_reloading.reload_css_file.call(null,f_33832);

var G__33833 = seq__33824_33828;
var G__33834 = chunk__33825_33829;
var G__33835 = count__33826_33830;
var G__33836 = (i__33827_33831 + (1));
seq__33824_33828 = G__33833;
chunk__33825_33829 = G__33834;
count__33826_33830 = G__33835;
i__33827_33831 = G__33836;
continue;
} else {
var temp__4425__auto___33837 = cljs.core.seq.call(null,seq__33824_33828);
if(temp__4425__auto___33837){
var seq__33824_33838__$1 = temp__4425__auto___33837;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33824_33838__$1)){
var c__28344__auto___33839 = cljs.core.chunk_first.call(null,seq__33824_33838__$1);
var G__33840 = cljs.core.chunk_rest.call(null,seq__33824_33838__$1);
var G__33841 = c__28344__auto___33839;
var G__33842 = cljs.core.count.call(null,c__28344__auto___33839);
var G__33843 = (0);
seq__33824_33828 = G__33840;
chunk__33825_33829 = G__33841;
count__33826_33830 = G__33842;
i__33827_33831 = G__33843;
continue;
} else {
var f_33844 = cljs.core.first.call(null,seq__33824_33838__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_33844);

var G__33845 = cljs.core.next.call(null,seq__33824_33838__$1);
var G__33846 = null;
var G__33847 = (0);
var G__33848 = (0);
seq__33824_33828 = G__33845;
chunk__33825_33829 = G__33846;
count__33826_33830 = G__33847;
i__33827_33831 = G__33848;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__33822,map__33822__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__33822,map__33822__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map