// Compiled by ClojureScript 1.7.228 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args29943 = [];
var len__28599__auto___29949 = arguments.length;
var i__28600__auto___29950 = (0);
while(true){
if((i__28600__auto___29950 < len__28599__auto___29949)){
args29943.push((arguments[i__28600__auto___29950]));

var G__29951 = (i__28600__auto___29950 + (1));
i__28600__auto___29950 = G__29951;
continue;
} else {
}
break;
}

var G__29945 = args29943.length;
switch (G__29945) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29943.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async29946 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29946 = (function (f,blockable,meta29947){
this.f = f;
this.blockable = blockable;
this.meta29947 = meta29947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29948,meta29947__$1){
var self__ = this;
var _29948__$1 = this;
return (new cljs.core.async.t_cljs$core$async29946(self__.f,self__.blockable,meta29947__$1));
});

cljs.core.async.t_cljs$core$async29946.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29948){
var self__ = this;
var _29948__$1 = this;
return self__.meta29947;
});

cljs.core.async.t_cljs$core$async29946.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29946.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29946.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async29946.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async29946.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta29947","meta29947",-413665085,null)], null);
});

cljs.core.async.t_cljs$core$async29946.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29946.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29946";

cljs.core.async.t_cljs$core$async29946.cljs$lang$ctorPrWriter = (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async29946");
});

cljs.core.async.__GT_t_cljs$core$async29946 = (function cljs$core$async$__GT_t_cljs$core$async29946(f__$1,blockable__$1,meta29947){
return (new cljs.core.async.t_cljs$core$async29946(f__$1,blockable__$1,meta29947));
});

}

return (new cljs.core.async.t_cljs$core$async29946(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args29955 = [];
var len__28599__auto___29958 = arguments.length;
var i__28600__auto___29959 = (0);
while(true){
if((i__28600__auto___29959 < len__28599__auto___29958)){
args29955.push((arguments[i__28600__auto___29959]));

var G__29960 = (i__28600__auto___29959 + (1));
i__28600__auto___29959 = G__29960;
continue;
} else {
}
break;
}

var G__29957 = args29955.length;
switch (G__29957) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29955.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,new cljs.core.Symbol(null,"buf-or-n","buf-or-n",-1646815050,null)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args29962 = [];
var len__28599__auto___29965 = arguments.length;
var i__28600__auto___29966 = (0);
while(true){
if((i__28600__auto___29966 < len__28599__auto___29965)){
args29962.push((arguments[i__28600__auto___29966]));

var G__29967 = (i__28600__auto___29966 + (1));
i__28600__auto___29966 = G__29967;
continue;
} else {
}
break;
}

var G__29964 = args29962.length;
switch (G__29964) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29962.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args29969 = [];
var len__28599__auto___29972 = arguments.length;
var i__28600__auto___29973 = (0);
while(true){
if((i__28600__auto___29973 < len__28599__auto___29972)){
args29969.push((arguments[i__28600__auto___29973]));

var G__29974 = (i__28600__auto___29973 + (1));
i__28600__auto___29973 = G__29974;
continue;
} else {
}
break;
}

var G__29971 = args29969.length;
switch (G__29971) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29969.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_29976 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_29976);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_29976,ret){
return (function (){
return fn1.call(null,val_29976);
});})(val_29976,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args29977 = [];
var len__28599__auto___29980 = arguments.length;
var i__28600__auto___29981 = (0);
while(true){
if((i__28600__auto___29981 < len__28599__auto___29980)){
args29977.push((arguments[i__28600__auto___29981]));

var G__29982 = (i__28600__auto___29981 + (1));
i__28600__auto___29981 = G__29982;
continue;
} else {
}
break;
}

var G__29979 = args29977.length;
switch (G__29979) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29977.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4423__auto__)){
var ret = temp__4423__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4423__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4423__auto__)){
var retb = temp__4423__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4423__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4423__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28444__auto___29984 = n;
var x_29985 = (0);
while(true){
if((x_29985 < n__28444__auto___29984)){
(a[x_29985] = (0));

var G__29986 = (x_29985 + (1));
x_29985 = G__29986;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__29987 = (i + (1));
i = G__29987;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async29991 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29991 = (function (alt_flag,flag,meta29992){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta29992 = meta29992;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_29993,meta29992__$1){
var self__ = this;
var _29993__$1 = this;
return (new cljs.core.async.t_cljs$core$async29991(self__.alt_flag,self__.flag,meta29992__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_29993){
var self__ = this;
var _29993__$1 = this;
return self__.meta29992;
});})(flag))
;

cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29991.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async29991.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta29992","meta29992",436769723,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async29991.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29991.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29991";

cljs.core.async.t_cljs$core$async29991.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async29991");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async29991 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async29991(alt_flag__$1,flag__$1,meta29992){
return (new cljs.core.async.t_cljs$core$async29991(alt_flag__$1,flag__$1,meta29992));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async29991(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async29997 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29997 = (function (alt_handler,flag,cb,meta29998){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta29998 = meta29998;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async29997.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29999,meta29998__$1){
var self__ = this;
var _29999__$1 = this;
return (new cljs.core.async.t_cljs$core$async29997(self__.alt_handler,self__.flag,self__.cb,meta29998__$1));
});

cljs.core.async.t_cljs$core$async29997.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29999){
var self__ = this;
var _29999__$1 = this;
return self__.meta29998;
});

cljs.core.async.t_cljs$core$async29997.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async29997.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async29997.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async29997.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async29997.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta29998","meta29998",1340468328,null)], null);
});

cljs.core.async.t_cljs$core$async29997.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29997.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29997";

cljs.core.async.t_cljs$core$async29997.cljs$lang$ctorPrWriter = (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async29997");
});

cljs.core.async.__GT_t_cljs$core$async29997 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async29997(alt_handler__$1,flag__$1,cb__$1,meta29998){
return (new cljs.core.async.t_cljs$core$async29997(alt_handler__$1,flag__$1,cb__$1,meta29998));
});

}

return (new cljs.core.async.t_cljs$core$async29997(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30000_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30000_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30001_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30001_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27541__auto__ = wport;
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30002 = (i + (1));
i = G__30002;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27541__auto__ = ret;
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4425__auto__ = (function (){var and__27529__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27529__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27529__auto__;
}
})();
if(cljs.core.truth_(temp__4425__auto__)){
var got = temp__4425__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28606__auto__ = [];
var len__28599__auto___30008 = arguments.length;
var i__28600__auto___30009 = (0);
while(true){
if((i__28600__auto___30009 < len__28599__auto___30008)){
args__28606__auto__.push((arguments[i__28600__auto___30009]));

var G__30010 = (i__28600__auto___30009 + (1));
i__28600__auto___30009 = G__30010;
continue;
} else {
}
break;
}

var argseq__28607__auto__ = ((((1) < args__28606__auto__.length))?(new cljs.core.IndexedSeq(args__28606__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28607__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30005){
var map__30006 = p__30005;
var map__30006__$1 = ((((!((map__30006 == null)))?((((map__30006.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30006.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30006):map__30006);
var opts = map__30006__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30003){
var G__30004 = cljs.core.first.call(null,seq30003);
var seq30003__$1 = cljs.core.next.call(null,seq30003);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__30004,seq30003__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args30011 = [];
var len__28599__auto___30061 = arguments.length;
var i__28600__auto___30062 = (0);
while(true){
if((i__28600__auto___30062 < len__28599__auto___30061)){
args30011.push((arguments[i__28600__auto___30062]));

var G__30063 = (i__28600__auto___30062 + (1));
i__28600__auto___30062 = G__30063;
continue;
} else {
}
break;
}

var G__30013 = args30011.length;
switch (G__30013) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30011.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__29898__auto___30065 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___30065){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___30065){
return (function (state_30037){
var state_val_30038 = (state_30037[(1)]);
if((state_val_30038 === (7))){
var inst_30033 = (state_30037[(2)]);
var state_30037__$1 = state_30037;
var statearr_30039_30066 = state_30037__$1;
(statearr_30039_30066[(2)] = inst_30033);

(statearr_30039_30066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (1))){
var state_30037__$1 = state_30037;
var statearr_30040_30067 = state_30037__$1;
(statearr_30040_30067[(2)] = null);

(statearr_30040_30067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (4))){
var inst_30016 = (state_30037[(7)]);
var inst_30016__$1 = (state_30037[(2)]);
var inst_30017 = (inst_30016__$1 == null);
var state_30037__$1 = (function (){var statearr_30041 = state_30037;
(statearr_30041[(7)] = inst_30016__$1);

return statearr_30041;
})();
if(cljs.core.truth_(inst_30017)){
var statearr_30042_30068 = state_30037__$1;
(statearr_30042_30068[(1)] = (5));

} else {
var statearr_30043_30069 = state_30037__$1;
(statearr_30043_30069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (13))){
var state_30037__$1 = state_30037;
var statearr_30044_30070 = state_30037__$1;
(statearr_30044_30070[(2)] = null);

(statearr_30044_30070[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (6))){
var inst_30016 = (state_30037[(7)]);
var state_30037__$1 = state_30037;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30037__$1,(11),to,inst_30016);
} else {
if((state_val_30038 === (3))){
var inst_30035 = (state_30037[(2)]);
var state_30037__$1 = state_30037;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30037__$1,inst_30035);
} else {
if((state_val_30038 === (12))){
var state_30037__$1 = state_30037;
var statearr_30045_30071 = state_30037__$1;
(statearr_30045_30071[(2)] = null);

(statearr_30045_30071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (2))){
var state_30037__$1 = state_30037;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30037__$1,(4),from);
} else {
if((state_val_30038 === (11))){
var inst_30026 = (state_30037[(2)]);
var state_30037__$1 = state_30037;
if(cljs.core.truth_(inst_30026)){
var statearr_30046_30072 = state_30037__$1;
(statearr_30046_30072[(1)] = (12));

} else {
var statearr_30047_30073 = state_30037__$1;
(statearr_30047_30073[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (9))){
var state_30037__$1 = state_30037;
var statearr_30048_30074 = state_30037__$1;
(statearr_30048_30074[(2)] = null);

(statearr_30048_30074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (5))){
var state_30037__$1 = state_30037;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30049_30075 = state_30037__$1;
(statearr_30049_30075[(1)] = (8));

} else {
var statearr_30050_30076 = state_30037__$1;
(statearr_30050_30076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (14))){
var inst_30031 = (state_30037[(2)]);
var state_30037__$1 = state_30037;
var statearr_30051_30077 = state_30037__$1;
(statearr_30051_30077[(2)] = inst_30031);

(statearr_30051_30077[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (10))){
var inst_30023 = (state_30037[(2)]);
var state_30037__$1 = state_30037;
var statearr_30052_30078 = state_30037__$1;
(statearr_30052_30078[(2)] = inst_30023);

(statearr_30052_30078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30038 === (8))){
var inst_30020 = cljs.core.async.close_BANG_.call(null,to);
var state_30037__$1 = state_30037;
var statearr_30053_30079 = state_30037__$1;
(statearr_30053_30079[(2)] = inst_30020);

(statearr_30053_30079[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___30065))
;
return ((function (switch__29786__auto__,c__29898__auto___30065){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_30057 = [null,null,null,null,null,null,null,null];
(statearr_30057[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_30057[(1)] = (1));

return statearr_30057;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_30037){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30037);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30058){if((e30058 instanceof Object)){
var ex__29790__auto__ = e30058;
var statearr_30059_30080 = state_30037;
(statearr_30059_30080[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30037);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30058;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30081 = state_30037;
state_30037 = G__30081;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_30037){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_30037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___30065))
})();
var state__29900__auto__ = (function (){var statearr_30060 = f__29899__auto__.call(null);
(statearr_30060[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___30065);

return statearr_30060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___30065))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"n","n",-2092305744,null))))].join('')));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__30265){
var vec__30266 = p__30265;
var v = cljs.core.nth.call(null,vec__30266,(0),null);
var p = cljs.core.nth.call(null,vec__30266,(1),null);
var job = vec__30266;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__29898__auto___30448 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___30448,res,vec__30266,v,p,job,jobs,results){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___30448,res,vec__30266,v,p,job,jobs,results){
return (function (state_30271){
var state_val_30272 = (state_30271[(1)]);
if((state_val_30272 === (1))){
var state_30271__$1 = state_30271;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30271__$1,(2),res,v);
} else {
if((state_val_30272 === (2))){
var inst_30268 = (state_30271[(2)]);
var inst_30269 = cljs.core.async.close_BANG_.call(null,res);
var state_30271__$1 = (function (){var statearr_30273 = state_30271;
(statearr_30273[(7)] = inst_30268);

return statearr_30273;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30271__$1,inst_30269);
} else {
return null;
}
}
});})(c__29898__auto___30448,res,vec__30266,v,p,job,jobs,results))
;
return ((function (switch__29786__auto__,c__29898__auto___30448,res,vec__30266,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0 = (function (){
var statearr_30277 = [null,null,null,null,null,null,null,null];
(statearr_30277[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__);

(statearr_30277[(1)] = (1));

return statearr_30277;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1 = (function (state_30271){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30278){if((e30278 instanceof Object)){
var ex__29790__auto__ = e30278;
var statearr_30279_30449 = state_30271;
(statearr_30279_30449[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30271);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30278;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30450 = state_30271;
state_30271 = G__30450;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = function(state_30271){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1.call(this,state_30271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___30448,res,vec__30266,v,p,job,jobs,results))
})();
var state__29900__auto__ = (function (){var statearr_30280 = f__29899__auto__.call(null);
(statearr_30280[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___30448);

return statearr_30280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___30448,res,vec__30266,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__30281){
var vec__30282 = p__30281;
var v = cljs.core.nth.call(null,vec__30282,(0),null);
var p = cljs.core.nth.call(null,vec__30282,(1),null);
var job = vec__30282;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28444__auto___30451 = n;
var __30452 = (0);
while(true){
if((__30452 < n__28444__auto___30451)){
var G__30283_30453 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__30283_30453) {
case "compute":
var c__29898__auto___30455 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30452,c__29898__auto___30455,G__30283_30453,n__28444__auto___30451,jobs,results,process,async){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (__30452,c__29898__auto___30455,G__30283_30453,n__28444__auto___30451,jobs,results,process,async){
return (function (state_30296){
var state_val_30297 = (state_30296[(1)]);
if((state_val_30297 === (1))){
var state_30296__$1 = state_30296;
var statearr_30298_30456 = state_30296__$1;
(statearr_30298_30456[(2)] = null);

(statearr_30298_30456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (2))){
var state_30296__$1 = state_30296;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30296__$1,(4),jobs);
} else {
if((state_val_30297 === (3))){
var inst_30294 = (state_30296[(2)]);
var state_30296__$1 = state_30296;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30296__$1,inst_30294);
} else {
if((state_val_30297 === (4))){
var inst_30286 = (state_30296[(2)]);
var inst_30287 = process.call(null,inst_30286);
var state_30296__$1 = state_30296;
if(cljs.core.truth_(inst_30287)){
var statearr_30299_30457 = state_30296__$1;
(statearr_30299_30457[(1)] = (5));

} else {
var statearr_30300_30458 = state_30296__$1;
(statearr_30300_30458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (5))){
var state_30296__$1 = state_30296;
var statearr_30301_30459 = state_30296__$1;
(statearr_30301_30459[(2)] = null);

(statearr_30301_30459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (6))){
var state_30296__$1 = state_30296;
var statearr_30302_30460 = state_30296__$1;
(statearr_30302_30460[(2)] = null);

(statearr_30302_30460[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30297 === (7))){
var inst_30292 = (state_30296[(2)]);
var state_30296__$1 = state_30296;
var statearr_30303_30461 = state_30296__$1;
(statearr_30303_30461[(2)] = inst_30292);

(statearr_30303_30461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30452,c__29898__auto___30455,G__30283_30453,n__28444__auto___30451,jobs,results,process,async))
;
return ((function (__30452,switch__29786__auto__,c__29898__auto___30455,G__30283_30453,n__28444__auto___30451,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0 = (function (){
var statearr_30307 = [null,null,null,null,null,null,null];
(statearr_30307[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__);

(statearr_30307[(1)] = (1));

return statearr_30307;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1 = (function (state_30296){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30296);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30308){if((e30308 instanceof Object)){
var ex__29790__auto__ = e30308;
var statearr_30309_30462 = state_30296;
(statearr_30309_30462[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30296);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30308;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30463 = state_30296;
state_30296 = G__30463;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = function(state_30296){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1.call(this,state_30296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__;
})()
;})(__30452,switch__29786__auto__,c__29898__auto___30455,G__30283_30453,n__28444__auto___30451,jobs,results,process,async))
})();
var state__29900__auto__ = (function (){var statearr_30310 = f__29899__auto__.call(null);
(statearr_30310[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___30455);

return statearr_30310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(__30452,c__29898__auto___30455,G__30283_30453,n__28444__auto___30451,jobs,results,process,async))
);


break;
case "async":
var c__29898__auto___30464 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__30452,c__29898__auto___30464,G__30283_30453,n__28444__auto___30451,jobs,results,process,async){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (__30452,c__29898__auto___30464,G__30283_30453,n__28444__auto___30451,jobs,results,process,async){
return (function (state_30323){
var state_val_30324 = (state_30323[(1)]);
if((state_val_30324 === (1))){
var state_30323__$1 = state_30323;
var statearr_30325_30465 = state_30323__$1;
(statearr_30325_30465[(2)] = null);

(statearr_30325_30465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30324 === (2))){
var state_30323__$1 = state_30323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30323__$1,(4),jobs);
} else {
if((state_val_30324 === (3))){
var inst_30321 = (state_30323[(2)]);
var state_30323__$1 = state_30323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30323__$1,inst_30321);
} else {
if((state_val_30324 === (4))){
var inst_30313 = (state_30323[(2)]);
var inst_30314 = async.call(null,inst_30313);
var state_30323__$1 = state_30323;
if(cljs.core.truth_(inst_30314)){
var statearr_30326_30466 = state_30323__$1;
(statearr_30326_30466[(1)] = (5));

} else {
var statearr_30327_30467 = state_30323__$1;
(statearr_30327_30467[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30324 === (5))){
var state_30323__$1 = state_30323;
var statearr_30328_30468 = state_30323__$1;
(statearr_30328_30468[(2)] = null);

(statearr_30328_30468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30324 === (6))){
var state_30323__$1 = state_30323;
var statearr_30329_30469 = state_30323__$1;
(statearr_30329_30469[(2)] = null);

(statearr_30329_30469[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30324 === (7))){
var inst_30319 = (state_30323[(2)]);
var state_30323__$1 = state_30323;
var statearr_30330_30470 = state_30323__$1;
(statearr_30330_30470[(2)] = inst_30319);

(statearr_30330_30470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30452,c__29898__auto___30464,G__30283_30453,n__28444__auto___30451,jobs,results,process,async))
;
return ((function (__30452,switch__29786__auto__,c__29898__auto___30464,G__30283_30453,n__28444__auto___30451,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0 = (function (){
var statearr_30334 = [null,null,null,null,null,null,null];
(statearr_30334[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__);

(statearr_30334[(1)] = (1));

return statearr_30334;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1 = (function (state_30323){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30335){if((e30335 instanceof Object)){
var ex__29790__auto__ = e30335;
var statearr_30336_30471 = state_30323;
(statearr_30336_30471[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30323);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30472 = state_30323;
state_30323 = G__30472;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = function(state_30323){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1.call(this,state_30323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__;
})()
;})(__30452,switch__29786__auto__,c__29898__auto___30464,G__30283_30453,n__28444__auto___30451,jobs,results,process,async))
})();
var state__29900__auto__ = (function (){var statearr_30337 = f__29899__auto__.call(null);
(statearr_30337[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___30464);

return statearr_30337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(__30452,c__29898__auto___30464,G__30283_30453,n__28444__auto___30451,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__30473 = (__30452 + (1));
__30452 = G__30473;
continue;
} else {
}
break;
}

var c__29898__auto___30474 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___30474,jobs,results,process,async){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___30474,jobs,results,process,async){
return (function (state_30359){
var state_val_30360 = (state_30359[(1)]);
if((state_val_30360 === (1))){
var state_30359__$1 = state_30359;
var statearr_30361_30475 = state_30359__$1;
(statearr_30361_30475[(2)] = null);

(statearr_30361_30475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (2))){
var state_30359__$1 = state_30359;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30359__$1,(4),from);
} else {
if((state_val_30360 === (3))){
var inst_30357 = (state_30359[(2)]);
var state_30359__$1 = state_30359;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30359__$1,inst_30357);
} else {
if((state_val_30360 === (4))){
var inst_30340 = (state_30359[(7)]);
var inst_30340__$1 = (state_30359[(2)]);
var inst_30341 = (inst_30340__$1 == null);
var state_30359__$1 = (function (){var statearr_30362 = state_30359;
(statearr_30362[(7)] = inst_30340__$1);

return statearr_30362;
})();
if(cljs.core.truth_(inst_30341)){
var statearr_30363_30476 = state_30359__$1;
(statearr_30363_30476[(1)] = (5));

} else {
var statearr_30364_30477 = state_30359__$1;
(statearr_30364_30477[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (5))){
var inst_30343 = cljs.core.async.close_BANG_.call(null,jobs);
var state_30359__$1 = state_30359;
var statearr_30365_30478 = state_30359__$1;
(statearr_30365_30478[(2)] = inst_30343);

(statearr_30365_30478[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (6))){
var inst_30345 = (state_30359[(8)]);
var inst_30340 = (state_30359[(7)]);
var inst_30345__$1 = cljs.core.async.chan.call(null,(1));
var inst_30346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30347 = [inst_30340,inst_30345__$1];
var inst_30348 = (new cljs.core.PersistentVector(null,2,(5),inst_30346,inst_30347,null));
var state_30359__$1 = (function (){var statearr_30366 = state_30359;
(statearr_30366[(8)] = inst_30345__$1);

return statearr_30366;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30359__$1,(8),jobs,inst_30348);
} else {
if((state_val_30360 === (7))){
var inst_30355 = (state_30359[(2)]);
var state_30359__$1 = state_30359;
var statearr_30367_30479 = state_30359__$1;
(statearr_30367_30479[(2)] = inst_30355);

(statearr_30367_30479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30360 === (8))){
var inst_30345 = (state_30359[(8)]);
var inst_30350 = (state_30359[(2)]);
var state_30359__$1 = (function (){var statearr_30368 = state_30359;
(statearr_30368[(9)] = inst_30350);

return statearr_30368;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30359__$1,(9),results,inst_30345);
} else {
if((state_val_30360 === (9))){
var inst_30352 = (state_30359[(2)]);
var state_30359__$1 = (function (){var statearr_30369 = state_30359;
(statearr_30369[(10)] = inst_30352);

return statearr_30369;
})();
var statearr_30370_30480 = state_30359__$1;
(statearr_30370_30480[(2)] = null);

(statearr_30370_30480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___30474,jobs,results,process,async))
;
return ((function (switch__29786__auto__,c__29898__auto___30474,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0 = (function (){
var statearr_30374 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30374[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__);

(statearr_30374[(1)] = (1));

return statearr_30374;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1 = (function (state_30359){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30359);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30375){if((e30375 instanceof Object)){
var ex__29790__auto__ = e30375;
var statearr_30376_30481 = state_30359;
(statearr_30376_30481[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30359);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30375;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30482 = state_30359;
state_30359 = G__30482;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = function(state_30359){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1.call(this,state_30359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___30474,jobs,results,process,async))
})();
var state__29900__auto__ = (function (){var statearr_30377 = f__29899__auto__.call(null);
(statearr_30377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___30474);

return statearr_30377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___30474,jobs,results,process,async))
);


var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__,jobs,results,process,async){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__,jobs,results,process,async){
return (function (state_30415){
var state_val_30416 = (state_30415[(1)]);
if((state_val_30416 === (7))){
var inst_30411 = (state_30415[(2)]);
var state_30415__$1 = state_30415;
var statearr_30417_30483 = state_30415__$1;
(statearr_30417_30483[(2)] = inst_30411);

(statearr_30417_30483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (20))){
var state_30415__$1 = state_30415;
var statearr_30418_30484 = state_30415__$1;
(statearr_30418_30484[(2)] = null);

(statearr_30418_30484[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (1))){
var state_30415__$1 = state_30415;
var statearr_30419_30485 = state_30415__$1;
(statearr_30419_30485[(2)] = null);

(statearr_30419_30485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (4))){
var inst_30380 = (state_30415[(7)]);
var inst_30380__$1 = (state_30415[(2)]);
var inst_30381 = (inst_30380__$1 == null);
var state_30415__$1 = (function (){var statearr_30420 = state_30415;
(statearr_30420[(7)] = inst_30380__$1);

return statearr_30420;
})();
if(cljs.core.truth_(inst_30381)){
var statearr_30421_30486 = state_30415__$1;
(statearr_30421_30486[(1)] = (5));

} else {
var statearr_30422_30487 = state_30415__$1;
(statearr_30422_30487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (15))){
var inst_30393 = (state_30415[(8)]);
var state_30415__$1 = state_30415;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30415__$1,(18),to,inst_30393);
} else {
if((state_val_30416 === (21))){
var inst_30406 = (state_30415[(2)]);
var state_30415__$1 = state_30415;
var statearr_30423_30488 = state_30415__$1;
(statearr_30423_30488[(2)] = inst_30406);

(statearr_30423_30488[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (13))){
var inst_30408 = (state_30415[(2)]);
var state_30415__$1 = (function (){var statearr_30424 = state_30415;
(statearr_30424[(9)] = inst_30408);

return statearr_30424;
})();
var statearr_30425_30489 = state_30415__$1;
(statearr_30425_30489[(2)] = null);

(statearr_30425_30489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (6))){
var inst_30380 = (state_30415[(7)]);
var state_30415__$1 = state_30415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30415__$1,(11),inst_30380);
} else {
if((state_val_30416 === (17))){
var inst_30401 = (state_30415[(2)]);
var state_30415__$1 = state_30415;
if(cljs.core.truth_(inst_30401)){
var statearr_30426_30490 = state_30415__$1;
(statearr_30426_30490[(1)] = (19));

} else {
var statearr_30427_30491 = state_30415__$1;
(statearr_30427_30491[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (3))){
var inst_30413 = (state_30415[(2)]);
var state_30415__$1 = state_30415;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30415__$1,inst_30413);
} else {
if((state_val_30416 === (12))){
var inst_30390 = (state_30415[(10)]);
var state_30415__$1 = state_30415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30415__$1,(14),inst_30390);
} else {
if((state_val_30416 === (2))){
var state_30415__$1 = state_30415;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30415__$1,(4),results);
} else {
if((state_val_30416 === (19))){
var state_30415__$1 = state_30415;
var statearr_30428_30492 = state_30415__$1;
(statearr_30428_30492[(2)] = null);

(statearr_30428_30492[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (11))){
var inst_30390 = (state_30415[(2)]);
var state_30415__$1 = (function (){var statearr_30429 = state_30415;
(statearr_30429[(10)] = inst_30390);

return statearr_30429;
})();
var statearr_30430_30493 = state_30415__$1;
(statearr_30430_30493[(2)] = null);

(statearr_30430_30493[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (9))){
var state_30415__$1 = state_30415;
var statearr_30431_30494 = state_30415__$1;
(statearr_30431_30494[(2)] = null);

(statearr_30431_30494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (5))){
var state_30415__$1 = state_30415;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30432_30495 = state_30415__$1;
(statearr_30432_30495[(1)] = (8));

} else {
var statearr_30433_30496 = state_30415__$1;
(statearr_30433_30496[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (14))){
var inst_30393 = (state_30415[(8)]);
var inst_30395 = (state_30415[(11)]);
var inst_30393__$1 = (state_30415[(2)]);
var inst_30394 = (inst_30393__$1 == null);
var inst_30395__$1 = cljs.core.not.call(null,inst_30394);
var state_30415__$1 = (function (){var statearr_30434 = state_30415;
(statearr_30434[(8)] = inst_30393__$1);

(statearr_30434[(11)] = inst_30395__$1);

return statearr_30434;
})();
if(inst_30395__$1){
var statearr_30435_30497 = state_30415__$1;
(statearr_30435_30497[(1)] = (15));

} else {
var statearr_30436_30498 = state_30415__$1;
(statearr_30436_30498[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (16))){
var inst_30395 = (state_30415[(11)]);
var state_30415__$1 = state_30415;
var statearr_30437_30499 = state_30415__$1;
(statearr_30437_30499[(2)] = inst_30395);

(statearr_30437_30499[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (10))){
var inst_30387 = (state_30415[(2)]);
var state_30415__$1 = state_30415;
var statearr_30438_30500 = state_30415__$1;
(statearr_30438_30500[(2)] = inst_30387);

(statearr_30438_30500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (18))){
var inst_30398 = (state_30415[(2)]);
var state_30415__$1 = state_30415;
var statearr_30439_30501 = state_30415__$1;
(statearr_30439_30501[(2)] = inst_30398);

(statearr_30439_30501[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30416 === (8))){
var inst_30384 = cljs.core.async.close_BANG_.call(null,to);
var state_30415__$1 = state_30415;
var statearr_30440_30502 = state_30415__$1;
(statearr_30440_30502[(2)] = inst_30384);

(statearr_30440_30502[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__,jobs,results,process,async))
;
return ((function (switch__29786__auto__,c__29898__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0 = (function (){
var statearr_30444 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30444[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__);

(statearr_30444[(1)] = (1));

return statearr_30444;
});
var cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1 = (function (state_30415){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30415);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30445){if((e30445 instanceof Object)){
var ex__29790__auto__ = e30445;
var statearr_30446_30503 = state_30415;
(statearr_30446_30503[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30415);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30504 = state_30415;
state_30415 = G__30504;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__ = function(state_30415){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1.call(this,state_30415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__29787__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__,jobs,results,process,async))
})();
var state__29900__auto__ = (function (){var statearr_30447 = f__29899__auto__.call(null);
(statearr_30447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_30447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__,jobs,results,process,async))
);

return c__29898__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args30505 = [];
var len__28599__auto___30508 = arguments.length;
var i__28600__auto___30509 = (0);
while(true){
if((i__28600__auto___30509 < len__28599__auto___30508)){
args30505.push((arguments[i__28600__auto___30509]));

var G__30510 = (i__28600__auto___30509 + (1));
i__28600__auto___30509 = G__30510;
continue;
} else {
}
break;
}

var G__30507 = args30505.length;
switch (G__30507) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30505.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args30512 = [];
var len__28599__auto___30515 = arguments.length;
var i__28600__auto___30516 = (0);
while(true){
if((i__28600__auto___30516 < len__28599__auto___30515)){
args30512.push((arguments[i__28600__auto___30516]));

var G__30517 = (i__28600__auto___30516 + (1));
i__28600__auto___30516 = G__30517;
continue;
} else {
}
break;
}

var G__30514 = args30512.length;
switch (G__30514) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30512.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args30519 = [];
var len__28599__auto___30572 = arguments.length;
var i__28600__auto___30573 = (0);
while(true){
if((i__28600__auto___30573 < len__28599__auto___30572)){
args30519.push((arguments[i__28600__auto___30573]));

var G__30574 = (i__28600__auto___30573 + (1));
i__28600__auto___30573 = G__30574;
continue;
} else {
}
break;
}

var G__30521 = args30519.length;
switch (G__30521) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30519.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__29898__auto___30576 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___30576,tc,fc){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___30576,tc,fc){
return (function (state_30547){
var state_val_30548 = (state_30547[(1)]);
if((state_val_30548 === (7))){
var inst_30543 = (state_30547[(2)]);
var state_30547__$1 = state_30547;
var statearr_30549_30577 = state_30547__$1;
(statearr_30549_30577[(2)] = inst_30543);

(statearr_30549_30577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (1))){
var state_30547__$1 = state_30547;
var statearr_30550_30578 = state_30547__$1;
(statearr_30550_30578[(2)] = null);

(statearr_30550_30578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (4))){
var inst_30524 = (state_30547[(7)]);
var inst_30524__$1 = (state_30547[(2)]);
var inst_30525 = (inst_30524__$1 == null);
var state_30547__$1 = (function (){var statearr_30551 = state_30547;
(statearr_30551[(7)] = inst_30524__$1);

return statearr_30551;
})();
if(cljs.core.truth_(inst_30525)){
var statearr_30552_30579 = state_30547__$1;
(statearr_30552_30579[(1)] = (5));

} else {
var statearr_30553_30580 = state_30547__$1;
(statearr_30553_30580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (13))){
var state_30547__$1 = state_30547;
var statearr_30554_30581 = state_30547__$1;
(statearr_30554_30581[(2)] = null);

(statearr_30554_30581[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (6))){
var inst_30524 = (state_30547[(7)]);
var inst_30530 = p.call(null,inst_30524);
var state_30547__$1 = state_30547;
if(cljs.core.truth_(inst_30530)){
var statearr_30555_30582 = state_30547__$1;
(statearr_30555_30582[(1)] = (9));

} else {
var statearr_30556_30583 = state_30547__$1;
(statearr_30556_30583[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (3))){
var inst_30545 = (state_30547[(2)]);
var state_30547__$1 = state_30547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30547__$1,inst_30545);
} else {
if((state_val_30548 === (12))){
var state_30547__$1 = state_30547;
var statearr_30557_30584 = state_30547__$1;
(statearr_30557_30584[(2)] = null);

(statearr_30557_30584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (2))){
var state_30547__$1 = state_30547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30547__$1,(4),ch);
} else {
if((state_val_30548 === (11))){
var inst_30524 = (state_30547[(7)]);
var inst_30534 = (state_30547[(2)]);
var state_30547__$1 = state_30547;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30547__$1,(8),inst_30534,inst_30524);
} else {
if((state_val_30548 === (9))){
var state_30547__$1 = state_30547;
var statearr_30558_30585 = state_30547__$1;
(statearr_30558_30585[(2)] = tc);

(statearr_30558_30585[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (5))){
var inst_30527 = cljs.core.async.close_BANG_.call(null,tc);
var inst_30528 = cljs.core.async.close_BANG_.call(null,fc);
var state_30547__$1 = (function (){var statearr_30559 = state_30547;
(statearr_30559[(8)] = inst_30527);

return statearr_30559;
})();
var statearr_30560_30586 = state_30547__$1;
(statearr_30560_30586[(2)] = inst_30528);

(statearr_30560_30586[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (14))){
var inst_30541 = (state_30547[(2)]);
var state_30547__$1 = state_30547;
var statearr_30561_30587 = state_30547__$1;
(statearr_30561_30587[(2)] = inst_30541);

(statearr_30561_30587[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (10))){
var state_30547__$1 = state_30547;
var statearr_30562_30588 = state_30547__$1;
(statearr_30562_30588[(2)] = fc);

(statearr_30562_30588[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30548 === (8))){
var inst_30536 = (state_30547[(2)]);
var state_30547__$1 = state_30547;
if(cljs.core.truth_(inst_30536)){
var statearr_30563_30589 = state_30547__$1;
(statearr_30563_30589[(1)] = (12));

} else {
var statearr_30564_30590 = state_30547__$1;
(statearr_30564_30590[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___30576,tc,fc))
;
return ((function (switch__29786__auto__,c__29898__auto___30576,tc,fc){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_30568 = [null,null,null,null,null,null,null,null,null];
(statearr_30568[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_30568[(1)] = (1));

return statearr_30568;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_30547){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30569){if((e30569 instanceof Object)){
var ex__29790__auto__ = e30569;
var statearr_30570_30591 = state_30547;
(statearr_30570_30591[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30547);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30592 = state_30547;
state_30547 = G__30592;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_30547){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_30547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___30576,tc,fc))
})();
var state__29900__auto__ = (function (){var statearr_30571 = f__29899__auto__.call(null);
(statearr_30571[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___30576);

return statearr_30571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___30576,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__){
return (function (state_30656){
var state_val_30657 = (state_30656[(1)]);
if((state_val_30657 === (7))){
var inst_30652 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30658_30679 = state_30656__$1;
(statearr_30658_30679[(2)] = inst_30652);

(statearr_30658_30679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (1))){
var inst_30636 = init;
var state_30656__$1 = (function (){var statearr_30659 = state_30656;
(statearr_30659[(7)] = inst_30636);

return statearr_30659;
})();
var statearr_30660_30680 = state_30656__$1;
(statearr_30660_30680[(2)] = null);

(statearr_30660_30680[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (4))){
var inst_30639 = (state_30656[(8)]);
var inst_30639__$1 = (state_30656[(2)]);
var inst_30640 = (inst_30639__$1 == null);
var state_30656__$1 = (function (){var statearr_30661 = state_30656;
(statearr_30661[(8)] = inst_30639__$1);

return statearr_30661;
})();
if(cljs.core.truth_(inst_30640)){
var statearr_30662_30681 = state_30656__$1;
(statearr_30662_30681[(1)] = (5));

} else {
var statearr_30663_30682 = state_30656__$1;
(statearr_30663_30682[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (6))){
var inst_30643 = (state_30656[(9)]);
var inst_30639 = (state_30656[(8)]);
var inst_30636 = (state_30656[(7)]);
var inst_30643__$1 = f.call(null,inst_30636,inst_30639);
var inst_30644 = cljs.core.reduced_QMARK_.call(null,inst_30643__$1);
var state_30656__$1 = (function (){var statearr_30664 = state_30656;
(statearr_30664[(9)] = inst_30643__$1);

return statearr_30664;
})();
if(inst_30644){
var statearr_30665_30683 = state_30656__$1;
(statearr_30665_30683[(1)] = (8));

} else {
var statearr_30666_30684 = state_30656__$1;
(statearr_30666_30684[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (3))){
var inst_30654 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30656__$1,inst_30654);
} else {
if((state_val_30657 === (2))){
var state_30656__$1 = state_30656;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30656__$1,(4),ch);
} else {
if((state_val_30657 === (9))){
var inst_30643 = (state_30656[(9)]);
var inst_30636 = inst_30643;
var state_30656__$1 = (function (){var statearr_30667 = state_30656;
(statearr_30667[(7)] = inst_30636);

return statearr_30667;
})();
var statearr_30668_30685 = state_30656__$1;
(statearr_30668_30685[(2)] = null);

(statearr_30668_30685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (5))){
var inst_30636 = (state_30656[(7)]);
var state_30656__$1 = state_30656;
var statearr_30669_30686 = state_30656__$1;
(statearr_30669_30686[(2)] = inst_30636);

(statearr_30669_30686[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (10))){
var inst_30650 = (state_30656[(2)]);
var state_30656__$1 = state_30656;
var statearr_30670_30687 = state_30656__$1;
(statearr_30670_30687[(2)] = inst_30650);

(statearr_30670_30687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30657 === (8))){
var inst_30643 = (state_30656[(9)]);
var inst_30646 = cljs.core.deref.call(null,inst_30643);
var state_30656__$1 = state_30656;
var statearr_30671_30688 = state_30656__$1;
(statearr_30671_30688[(2)] = inst_30646);

(statearr_30671_30688[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__))
;
return ((function (switch__29786__auto__,c__29898__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__29787__auto__ = null;
var cljs$core$async$reduce_$_state_machine__29787__auto____0 = (function (){
var statearr_30675 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30675[(0)] = cljs$core$async$reduce_$_state_machine__29787__auto__);

(statearr_30675[(1)] = (1));

return statearr_30675;
});
var cljs$core$async$reduce_$_state_machine__29787__auto____1 = (function (state_30656){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30656);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30676){if((e30676 instanceof Object)){
var ex__29790__auto__ = e30676;
var statearr_30677_30689 = state_30656;
(statearr_30677_30689[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30656);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30676;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30690 = state_30656;
state_30656 = G__30690;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__29787__auto__ = function(state_30656){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__29787__auto____1.call(this,state_30656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__29787__auto____0;
cljs$core$async$reduce_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__29787__auto____1;
return cljs$core$async$reduce_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__))
})();
var state__29900__auto__ = (function (){var statearr_30678 = f__29899__auto__.call(null);
(statearr_30678[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_30678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__))
);

return c__29898__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args30691 = [];
var len__28599__auto___30743 = arguments.length;
var i__28600__auto___30744 = (0);
while(true){
if((i__28600__auto___30744 < len__28599__auto___30743)){
args30691.push((arguments[i__28600__auto___30744]));

var G__30745 = (i__28600__auto___30744 + (1));
i__28600__auto___30744 = G__30745;
continue;
} else {
}
break;
}

var G__30693 = args30691.length;
switch (G__30693) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args30691.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__){
return (function (state_30718){
var state_val_30719 = (state_30718[(1)]);
if((state_val_30719 === (7))){
var inst_30700 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
var statearr_30720_30747 = state_30718__$1;
(statearr_30720_30747[(2)] = inst_30700);

(statearr_30720_30747[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (1))){
var inst_30694 = cljs.core.seq.call(null,coll);
var inst_30695 = inst_30694;
var state_30718__$1 = (function (){var statearr_30721 = state_30718;
(statearr_30721[(7)] = inst_30695);

return statearr_30721;
})();
var statearr_30722_30748 = state_30718__$1;
(statearr_30722_30748[(2)] = null);

(statearr_30722_30748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (4))){
var inst_30695 = (state_30718[(7)]);
var inst_30698 = cljs.core.first.call(null,inst_30695);
var state_30718__$1 = state_30718;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30718__$1,(7),ch,inst_30698);
} else {
if((state_val_30719 === (13))){
var inst_30712 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
var statearr_30723_30749 = state_30718__$1;
(statearr_30723_30749[(2)] = inst_30712);

(statearr_30723_30749[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (6))){
var inst_30703 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
if(cljs.core.truth_(inst_30703)){
var statearr_30724_30750 = state_30718__$1;
(statearr_30724_30750[(1)] = (8));

} else {
var statearr_30725_30751 = state_30718__$1;
(statearr_30725_30751[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (3))){
var inst_30716 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30718__$1,inst_30716);
} else {
if((state_val_30719 === (12))){
var state_30718__$1 = state_30718;
var statearr_30726_30752 = state_30718__$1;
(statearr_30726_30752[(2)] = null);

(statearr_30726_30752[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (2))){
var inst_30695 = (state_30718[(7)]);
var state_30718__$1 = state_30718;
if(cljs.core.truth_(inst_30695)){
var statearr_30727_30753 = state_30718__$1;
(statearr_30727_30753[(1)] = (4));

} else {
var statearr_30728_30754 = state_30718__$1;
(statearr_30728_30754[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (11))){
var inst_30709 = cljs.core.async.close_BANG_.call(null,ch);
var state_30718__$1 = state_30718;
var statearr_30729_30755 = state_30718__$1;
(statearr_30729_30755[(2)] = inst_30709);

(statearr_30729_30755[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (9))){
var state_30718__$1 = state_30718;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30730_30756 = state_30718__$1;
(statearr_30730_30756[(1)] = (11));

} else {
var statearr_30731_30757 = state_30718__$1;
(statearr_30731_30757[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (5))){
var inst_30695 = (state_30718[(7)]);
var state_30718__$1 = state_30718;
var statearr_30732_30758 = state_30718__$1;
(statearr_30732_30758[(2)] = inst_30695);

(statearr_30732_30758[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (10))){
var inst_30714 = (state_30718[(2)]);
var state_30718__$1 = state_30718;
var statearr_30733_30759 = state_30718__$1;
(statearr_30733_30759[(2)] = inst_30714);

(statearr_30733_30759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30719 === (8))){
var inst_30695 = (state_30718[(7)]);
var inst_30705 = cljs.core.next.call(null,inst_30695);
var inst_30695__$1 = inst_30705;
var state_30718__$1 = (function (){var statearr_30734 = state_30718;
(statearr_30734[(7)] = inst_30695__$1);

return statearr_30734;
})();
var statearr_30735_30760 = state_30718__$1;
(statearr_30735_30760[(2)] = null);

(statearr_30735_30760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__))
;
return ((function (switch__29786__auto__,c__29898__auto__){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_30739 = [null,null,null,null,null,null,null,null];
(statearr_30739[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_30739[(1)] = (1));

return statearr_30739;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_30718){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_30718);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e30740){if((e30740 instanceof Object)){
var ex__29790__auto__ = e30740;
var statearr_30741_30761 = state_30718;
(statearr_30741_30761[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30718);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30762 = state_30718;
state_30718 = G__30762;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_30718){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_30718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__))
})();
var state__29900__auto__ = (function (){var statearr_30742 = f__29899__auto__.call(null);
(statearr_30742[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_30742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__))
);

return c__29898__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__28196__auto__ = (((_ == null))?null:_);
var m__28197__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,_);
} else {
var m__28197__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__28197__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m,ch);
} else {
var m__28197__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m);
} else {
var m__28197__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async30984 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30984 = (function (mult,ch,cs,meta30985){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta30985 = meta30985;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_30986,meta30985__$1){
var self__ = this;
var _30986__$1 = this;
return (new cljs.core.async.t_cljs$core$async30984(self__.mult,self__.ch,self__.cs,meta30985__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_30986){
var self__ = this;
var _30986__$1 = this;
return self__.meta30985;
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30985","meta30985",1642256446,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async30984.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async30984.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30984";

cljs.core.async.t_cljs$core$async30984.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async30984");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async30984 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async30984(mult__$1,ch__$1,cs__$1,meta30985){
return (new cljs.core.async.t_cljs$core$async30984(mult__$1,ch__$1,cs__$1,meta30985));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async30984(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__29898__auto___31205 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___31205,cs,m,dchan,dctr,done){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___31205,cs,m,dchan,dctr,done){
return (function (state_31117){
var state_val_31118 = (state_31117[(1)]);
if((state_val_31118 === (7))){
var inst_31113 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31119_31206 = state_31117__$1;
(statearr_31119_31206[(2)] = inst_31113);

(statearr_31119_31206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (20))){
var inst_31018 = (state_31117[(7)]);
var inst_31028 = cljs.core.first.call(null,inst_31018);
var inst_31029 = cljs.core.nth.call(null,inst_31028,(0),null);
var inst_31030 = cljs.core.nth.call(null,inst_31028,(1),null);
var state_31117__$1 = (function (){var statearr_31120 = state_31117;
(statearr_31120[(8)] = inst_31029);

return statearr_31120;
})();
if(cljs.core.truth_(inst_31030)){
var statearr_31121_31207 = state_31117__$1;
(statearr_31121_31207[(1)] = (22));

} else {
var statearr_31122_31208 = state_31117__$1;
(statearr_31122_31208[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (27))){
var inst_31058 = (state_31117[(9)]);
var inst_30989 = (state_31117[(10)]);
var inst_31060 = (state_31117[(11)]);
var inst_31065 = (state_31117[(12)]);
var inst_31065__$1 = cljs.core._nth.call(null,inst_31058,inst_31060);
var inst_31066 = cljs.core.async.put_BANG_.call(null,inst_31065__$1,inst_30989,done);
var state_31117__$1 = (function (){var statearr_31123 = state_31117;
(statearr_31123[(12)] = inst_31065__$1);

return statearr_31123;
})();
if(cljs.core.truth_(inst_31066)){
var statearr_31124_31209 = state_31117__$1;
(statearr_31124_31209[(1)] = (30));

} else {
var statearr_31125_31210 = state_31117__$1;
(statearr_31125_31210[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (1))){
var state_31117__$1 = state_31117;
var statearr_31126_31211 = state_31117__$1;
(statearr_31126_31211[(2)] = null);

(statearr_31126_31211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (24))){
var inst_31018 = (state_31117[(7)]);
var inst_31035 = (state_31117[(2)]);
var inst_31036 = cljs.core.next.call(null,inst_31018);
var inst_30998 = inst_31036;
var inst_30999 = null;
var inst_31000 = (0);
var inst_31001 = (0);
var state_31117__$1 = (function (){var statearr_31127 = state_31117;
(statearr_31127[(13)] = inst_31000);

(statearr_31127[(14)] = inst_31035);

(statearr_31127[(15)] = inst_30998);

(statearr_31127[(16)] = inst_31001);

(statearr_31127[(17)] = inst_30999);

return statearr_31127;
})();
var statearr_31128_31212 = state_31117__$1;
(statearr_31128_31212[(2)] = null);

(statearr_31128_31212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (39))){
var state_31117__$1 = state_31117;
var statearr_31132_31213 = state_31117__$1;
(statearr_31132_31213[(2)] = null);

(statearr_31132_31213[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (4))){
var inst_30989 = (state_31117[(10)]);
var inst_30989__$1 = (state_31117[(2)]);
var inst_30990 = (inst_30989__$1 == null);
var state_31117__$1 = (function (){var statearr_31133 = state_31117;
(statearr_31133[(10)] = inst_30989__$1);

return statearr_31133;
})();
if(cljs.core.truth_(inst_30990)){
var statearr_31134_31214 = state_31117__$1;
(statearr_31134_31214[(1)] = (5));

} else {
var statearr_31135_31215 = state_31117__$1;
(statearr_31135_31215[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (15))){
var inst_31000 = (state_31117[(13)]);
var inst_30998 = (state_31117[(15)]);
var inst_31001 = (state_31117[(16)]);
var inst_30999 = (state_31117[(17)]);
var inst_31014 = (state_31117[(2)]);
var inst_31015 = (inst_31001 + (1));
var tmp31129 = inst_31000;
var tmp31130 = inst_30998;
var tmp31131 = inst_30999;
var inst_30998__$1 = tmp31130;
var inst_30999__$1 = tmp31131;
var inst_31000__$1 = tmp31129;
var inst_31001__$1 = inst_31015;
var state_31117__$1 = (function (){var statearr_31136 = state_31117;
(statearr_31136[(18)] = inst_31014);

(statearr_31136[(13)] = inst_31000__$1);

(statearr_31136[(15)] = inst_30998__$1);

(statearr_31136[(16)] = inst_31001__$1);

(statearr_31136[(17)] = inst_30999__$1);

return statearr_31136;
})();
var statearr_31137_31216 = state_31117__$1;
(statearr_31137_31216[(2)] = null);

(statearr_31137_31216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (21))){
var inst_31039 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31141_31217 = state_31117__$1;
(statearr_31141_31217[(2)] = inst_31039);

(statearr_31141_31217[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (31))){
var inst_31065 = (state_31117[(12)]);
var inst_31069 = done.call(null,null);
var inst_31070 = cljs.core.async.untap_STAR_.call(null,m,inst_31065);
var state_31117__$1 = (function (){var statearr_31142 = state_31117;
(statearr_31142[(19)] = inst_31069);

return statearr_31142;
})();
var statearr_31143_31218 = state_31117__$1;
(statearr_31143_31218[(2)] = inst_31070);

(statearr_31143_31218[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (32))){
var inst_31058 = (state_31117[(9)]);
var inst_31060 = (state_31117[(11)]);
var inst_31059 = (state_31117[(20)]);
var inst_31057 = (state_31117[(21)]);
var inst_31072 = (state_31117[(2)]);
var inst_31073 = (inst_31060 + (1));
var tmp31138 = inst_31058;
var tmp31139 = inst_31059;
var tmp31140 = inst_31057;
var inst_31057__$1 = tmp31140;
var inst_31058__$1 = tmp31138;
var inst_31059__$1 = tmp31139;
var inst_31060__$1 = inst_31073;
var state_31117__$1 = (function (){var statearr_31144 = state_31117;
(statearr_31144[(9)] = inst_31058__$1);

(statearr_31144[(22)] = inst_31072);

(statearr_31144[(11)] = inst_31060__$1);

(statearr_31144[(20)] = inst_31059__$1);

(statearr_31144[(21)] = inst_31057__$1);

return statearr_31144;
})();
var statearr_31145_31219 = state_31117__$1;
(statearr_31145_31219[(2)] = null);

(statearr_31145_31219[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (40))){
var inst_31085 = (state_31117[(23)]);
var inst_31089 = done.call(null,null);
var inst_31090 = cljs.core.async.untap_STAR_.call(null,m,inst_31085);
var state_31117__$1 = (function (){var statearr_31146 = state_31117;
(statearr_31146[(24)] = inst_31089);

return statearr_31146;
})();
var statearr_31147_31220 = state_31117__$1;
(statearr_31147_31220[(2)] = inst_31090);

(statearr_31147_31220[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (33))){
var inst_31076 = (state_31117[(25)]);
var inst_31078 = cljs.core.chunked_seq_QMARK_.call(null,inst_31076);
var state_31117__$1 = state_31117;
if(inst_31078){
var statearr_31148_31221 = state_31117__$1;
(statearr_31148_31221[(1)] = (36));

} else {
var statearr_31149_31222 = state_31117__$1;
(statearr_31149_31222[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (13))){
var inst_31008 = (state_31117[(26)]);
var inst_31011 = cljs.core.async.close_BANG_.call(null,inst_31008);
var state_31117__$1 = state_31117;
var statearr_31150_31223 = state_31117__$1;
(statearr_31150_31223[(2)] = inst_31011);

(statearr_31150_31223[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (22))){
var inst_31029 = (state_31117[(8)]);
var inst_31032 = cljs.core.async.close_BANG_.call(null,inst_31029);
var state_31117__$1 = state_31117;
var statearr_31151_31224 = state_31117__$1;
(statearr_31151_31224[(2)] = inst_31032);

(statearr_31151_31224[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (36))){
var inst_31076 = (state_31117[(25)]);
var inst_31080 = cljs.core.chunk_first.call(null,inst_31076);
var inst_31081 = cljs.core.chunk_rest.call(null,inst_31076);
var inst_31082 = cljs.core.count.call(null,inst_31080);
var inst_31057 = inst_31081;
var inst_31058 = inst_31080;
var inst_31059 = inst_31082;
var inst_31060 = (0);
var state_31117__$1 = (function (){var statearr_31152 = state_31117;
(statearr_31152[(9)] = inst_31058);

(statearr_31152[(11)] = inst_31060);

(statearr_31152[(20)] = inst_31059);

(statearr_31152[(21)] = inst_31057);

return statearr_31152;
})();
var statearr_31153_31225 = state_31117__$1;
(statearr_31153_31225[(2)] = null);

(statearr_31153_31225[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (41))){
var inst_31076 = (state_31117[(25)]);
var inst_31092 = (state_31117[(2)]);
var inst_31093 = cljs.core.next.call(null,inst_31076);
var inst_31057 = inst_31093;
var inst_31058 = null;
var inst_31059 = (0);
var inst_31060 = (0);
var state_31117__$1 = (function (){var statearr_31154 = state_31117;
(statearr_31154[(9)] = inst_31058);

(statearr_31154[(27)] = inst_31092);

(statearr_31154[(11)] = inst_31060);

(statearr_31154[(20)] = inst_31059);

(statearr_31154[(21)] = inst_31057);

return statearr_31154;
})();
var statearr_31155_31226 = state_31117__$1;
(statearr_31155_31226[(2)] = null);

(statearr_31155_31226[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (43))){
var state_31117__$1 = state_31117;
var statearr_31156_31227 = state_31117__$1;
(statearr_31156_31227[(2)] = null);

(statearr_31156_31227[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (29))){
var inst_31101 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31157_31228 = state_31117__$1;
(statearr_31157_31228[(2)] = inst_31101);

(statearr_31157_31228[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (44))){
var inst_31110 = (state_31117[(2)]);
var state_31117__$1 = (function (){var statearr_31158 = state_31117;
(statearr_31158[(28)] = inst_31110);

return statearr_31158;
})();
var statearr_31159_31229 = state_31117__$1;
(statearr_31159_31229[(2)] = null);

(statearr_31159_31229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (6))){
var inst_31049 = (state_31117[(29)]);
var inst_31048 = cljs.core.deref.call(null,cs);
var inst_31049__$1 = cljs.core.keys.call(null,inst_31048);
var inst_31050 = cljs.core.count.call(null,inst_31049__$1);
var inst_31051 = cljs.core.reset_BANG_.call(null,dctr,inst_31050);
var inst_31056 = cljs.core.seq.call(null,inst_31049__$1);
var inst_31057 = inst_31056;
var inst_31058 = null;
var inst_31059 = (0);
var inst_31060 = (0);
var state_31117__$1 = (function (){var statearr_31160 = state_31117;
(statearr_31160[(9)] = inst_31058);

(statearr_31160[(11)] = inst_31060);

(statearr_31160[(30)] = inst_31051);

(statearr_31160[(20)] = inst_31059);

(statearr_31160[(21)] = inst_31057);

(statearr_31160[(29)] = inst_31049__$1);

return statearr_31160;
})();
var statearr_31161_31230 = state_31117__$1;
(statearr_31161_31230[(2)] = null);

(statearr_31161_31230[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (28))){
var inst_31076 = (state_31117[(25)]);
var inst_31057 = (state_31117[(21)]);
var inst_31076__$1 = cljs.core.seq.call(null,inst_31057);
var state_31117__$1 = (function (){var statearr_31162 = state_31117;
(statearr_31162[(25)] = inst_31076__$1);

return statearr_31162;
})();
if(inst_31076__$1){
var statearr_31163_31231 = state_31117__$1;
(statearr_31163_31231[(1)] = (33));

} else {
var statearr_31164_31232 = state_31117__$1;
(statearr_31164_31232[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (25))){
var inst_31060 = (state_31117[(11)]);
var inst_31059 = (state_31117[(20)]);
var inst_31062 = (inst_31060 < inst_31059);
var inst_31063 = inst_31062;
var state_31117__$1 = state_31117;
if(cljs.core.truth_(inst_31063)){
var statearr_31165_31233 = state_31117__$1;
(statearr_31165_31233[(1)] = (27));

} else {
var statearr_31166_31234 = state_31117__$1;
(statearr_31166_31234[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (34))){
var state_31117__$1 = state_31117;
var statearr_31167_31235 = state_31117__$1;
(statearr_31167_31235[(2)] = null);

(statearr_31167_31235[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (17))){
var state_31117__$1 = state_31117;
var statearr_31168_31236 = state_31117__$1;
(statearr_31168_31236[(2)] = null);

(statearr_31168_31236[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (3))){
var inst_31115 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31117__$1,inst_31115);
} else {
if((state_val_31118 === (12))){
var inst_31044 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31169_31237 = state_31117__$1;
(statearr_31169_31237[(2)] = inst_31044);

(statearr_31169_31237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (2))){
var state_31117__$1 = state_31117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31117__$1,(4),ch);
} else {
if((state_val_31118 === (23))){
var state_31117__$1 = state_31117;
var statearr_31170_31238 = state_31117__$1;
(statearr_31170_31238[(2)] = null);

(statearr_31170_31238[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (35))){
var inst_31099 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31171_31239 = state_31117__$1;
(statearr_31171_31239[(2)] = inst_31099);

(statearr_31171_31239[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (19))){
var inst_31018 = (state_31117[(7)]);
var inst_31022 = cljs.core.chunk_first.call(null,inst_31018);
var inst_31023 = cljs.core.chunk_rest.call(null,inst_31018);
var inst_31024 = cljs.core.count.call(null,inst_31022);
var inst_30998 = inst_31023;
var inst_30999 = inst_31022;
var inst_31000 = inst_31024;
var inst_31001 = (0);
var state_31117__$1 = (function (){var statearr_31172 = state_31117;
(statearr_31172[(13)] = inst_31000);

(statearr_31172[(15)] = inst_30998);

(statearr_31172[(16)] = inst_31001);

(statearr_31172[(17)] = inst_30999);

return statearr_31172;
})();
var statearr_31173_31240 = state_31117__$1;
(statearr_31173_31240[(2)] = null);

(statearr_31173_31240[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (11))){
var inst_31018 = (state_31117[(7)]);
var inst_30998 = (state_31117[(15)]);
var inst_31018__$1 = cljs.core.seq.call(null,inst_30998);
var state_31117__$1 = (function (){var statearr_31174 = state_31117;
(statearr_31174[(7)] = inst_31018__$1);

return statearr_31174;
})();
if(inst_31018__$1){
var statearr_31175_31241 = state_31117__$1;
(statearr_31175_31241[(1)] = (16));

} else {
var statearr_31176_31242 = state_31117__$1;
(statearr_31176_31242[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (9))){
var inst_31046 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31177_31243 = state_31117__$1;
(statearr_31177_31243[(2)] = inst_31046);

(statearr_31177_31243[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (5))){
var inst_30996 = cljs.core.deref.call(null,cs);
var inst_30997 = cljs.core.seq.call(null,inst_30996);
var inst_30998 = inst_30997;
var inst_30999 = null;
var inst_31000 = (0);
var inst_31001 = (0);
var state_31117__$1 = (function (){var statearr_31178 = state_31117;
(statearr_31178[(13)] = inst_31000);

(statearr_31178[(15)] = inst_30998);

(statearr_31178[(16)] = inst_31001);

(statearr_31178[(17)] = inst_30999);

return statearr_31178;
})();
var statearr_31179_31244 = state_31117__$1;
(statearr_31179_31244[(2)] = null);

(statearr_31179_31244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (14))){
var state_31117__$1 = state_31117;
var statearr_31180_31245 = state_31117__$1;
(statearr_31180_31245[(2)] = null);

(statearr_31180_31245[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (45))){
var inst_31107 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31181_31246 = state_31117__$1;
(statearr_31181_31246[(2)] = inst_31107);

(statearr_31181_31246[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (26))){
var inst_31049 = (state_31117[(29)]);
var inst_31103 = (state_31117[(2)]);
var inst_31104 = cljs.core.seq.call(null,inst_31049);
var state_31117__$1 = (function (){var statearr_31182 = state_31117;
(statearr_31182[(31)] = inst_31103);

return statearr_31182;
})();
if(inst_31104){
var statearr_31183_31247 = state_31117__$1;
(statearr_31183_31247[(1)] = (42));

} else {
var statearr_31184_31248 = state_31117__$1;
(statearr_31184_31248[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (16))){
var inst_31018 = (state_31117[(7)]);
var inst_31020 = cljs.core.chunked_seq_QMARK_.call(null,inst_31018);
var state_31117__$1 = state_31117;
if(inst_31020){
var statearr_31185_31249 = state_31117__$1;
(statearr_31185_31249[(1)] = (19));

} else {
var statearr_31186_31250 = state_31117__$1;
(statearr_31186_31250[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (38))){
var inst_31096 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31187_31251 = state_31117__$1;
(statearr_31187_31251[(2)] = inst_31096);

(statearr_31187_31251[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (30))){
var state_31117__$1 = state_31117;
var statearr_31188_31252 = state_31117__$1;
(statearr_31188_31252[(2)] = null);

(statearr_31188_31252[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (10))){
var inst_31001 = (state_31117[(16)]);
var inst_30999 = (state_31117[(17)]);
var inst_31007 = cljs.core._nth.call(null,inst_30999,inst_31001);
var inst_31008 = cljs.core.nth.call(null,inst_31007,(0),null);
var inst_31009 = cljs.core.nth.call(null,inst_31007,(1),null);
var state_31117__$1 = (function (){var statearr_31189 = state_31117;
(statearr_31189[(26)] = inst_31008);

return statearr_31189;
})();
if(cljs.core.truth_(inst_31009)){
var statearr_31190_31253 = state_31117__$1;
(statearr_31190_31253[(1)] = (13));

} else {
var statearr_31191_31254 = state_31117__$1;
(statearr_31191_31254[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (18))){
var inst_31042 = (state_31117[(2)]);
var state_31117__$1 = state_31117;
var statearr_31192_31255 = state_31117__$1;
(statearr_31192_31255[(2)] = inst_31042);

(statearr_31192_31255[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (42))){
var state_31117__$1 = state_31117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31117__$1,(45),dchan);
} else {
if((state_val_31118 === (37))){
var inst_30989 = (state_31117[(10)]);
var inst_31076 = (state_31117[(25)]);
var inst_31085 = (state_31117[(23)]);
var inst_31085__$1 = cljs.core.first.call(null,inst_31076);
var inst_31086 = cljs.core.async.put_BANG_.call(null,inst_31085__$1,inst_30989,done);
var state_31117__$1 = (function (){var statearr_31193 = state_31117;
(statearr_31193[(23)] = inst_31085__$1);

return statearr_31193;
})();
if(cljs.core.truth_(inst_31086)){
var statearr_31194_31256 = state_31117__$1;
(statearr_31194_31256[(1)] = (39));

} else {
var statearr_31195_31257 = state_31117__$1;
(statearr_31195_31257[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31118 === (8))){
var inst_31000 = (state_31117[(13)]);
var inst_31001 = (state_31117[(16)]);
var inst_31003 = (inst_31001 < inst_31000);
var inst_31004 = inst_31003;
var state_31117__$1 = state_31117;
if(cljs.core.truth_(inst_31004)){
var statearr_31196_31258 = state_31117__$1;
(statearr_31196_31258[(1)] = (10));

} else {
var statearr_31197_31259 = state_31117__$1;
(statearr_31197_31259[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___31205,cs,m,dchan,dctr,done))
;
return ((function (switch__29786__auto__,c__29898__auto___31205,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__29787__auto__ = null;
var cljs$core$async$mult_$_state_machine__29787__auto____0 = (function (){
var statearr_31201 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31201[(0)] = cljs$core$async$mult_$_state_machine__29787__auto__);

(statearr_31201[(1)] = (1));

return statearr_31201;
});
var cljs$core$async$mult_$_state_machine__29787__auto____1 = (function (state_31117){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_31117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e31202){if((e31202 instanceof Object)){
var ex__29790__auto__ = e31202;
var statearr_31203_31260 = state_31117;
(statearr_31203_31260[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31117);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31202;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31261 = state_31117;
state_31117 = G__31261;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__29787__auto__ = function(state_31117){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__29787__auto____1.call(this,state_31117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__29787__auto____0;
cljs$core$async$mult_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__29787__auto____1;
return cljs$core$async$mult_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___31205,cs,m,dchan,dctr,done))
})();
var state__29900__auto__ = (function (){var statearr_31204 = f__29899__auto__.call(null);
(statearr_31204[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___31205);

return statearr_31204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___31205,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args31262 = [];
var len__28599__auto___31265 = arguments.length;
var i__28600__auto___31266 = (0);
while(true){
if((i__28600__auto___31266 < len__28599__auto___31265)){
args31262.push((arguments[i__28600__auto___31266]));

var G__31267 = (i__28600__auto___31266 + (1));
i__28600__auto___31266 = G__31267;
continue;
} else {
}
break;
}

var G__31264 = args31262.length;
switch (G__31264) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31262.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m,ch);
} else {
var m__28197__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m,ch);
} else {
var m__28197__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m);
} else {
var m__28197__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m,state_map);
} else {
var m__28197__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__28196__auto__ = (((m == null))?null:m);
var m__28197__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,m,mode);
} else {
var m__28197__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28606__auto__ = [];
var len__28599__auto___31279 = arguments.length;
var i__28600__auto___31280 = (0);
while(true){
if((i__28600__auto___31280 < len__28599__auto___31279)){
args__28606__auto__.push((arguments[i__28600__auto___31280]));

var G__31281 = (i__28600__auto___31280 + (1));
i__28600__auto___31280 = G__31281;
continue;
} else {
}
break;
}

var argseq__28607__auto__ = ((((3) < args__28606__auto__.length))?(new cljs.core.IndexedSeq(args__28606__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28607__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31273){
var map__31274 = p__31273;
var map__31274__$1 = ((((!((map__31274 == null)))?((((map__31274.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31274.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31274):map__31274);
var opts = map__31274__$1;
var statearr_31276_31282 = state;
(statearr_31276_31282[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4425__auto__ = cljs.core.async.do_alts.call(null,((function (map__31274,map__31274__$1,opts){
return (function (val){
var statearr_31277_31283 = state;
(statearr_31277_31283[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__31274,map__31274__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4425__auto__)){
var cb = temp__4425__auto__;
var statearr_31278_31284 = state;
(statearr_31278_31284[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31269){
var G__31270 = cljs.core.first.call(null,seq31269);
var seq31269__$1 = cljs.core.next.call(null,seq31269);
var G__31271 = cljs.core.first.call(null,seq31269__$1);
var seq31269__$2 = cljs.core.next.call(null,seq31269__$1);
var G__31272 = cljs.core.first.call(null,seq31269__$2);
var seq31269__$3 = cljs.core.next.call(null,seq31269__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31270,G__31271,G__31272,seq31269__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async31448 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31448 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31449){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31449 = meta31449;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31450,meta31449__$1){
var self__ = this;
var _31450__$1 = this;
return (new cljs.core.async.t_cljs$core$async31448(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31449__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_31450){
var self__ = this;
var _31450__$1 = this;
return self__.meta31449;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"mode","mode",-2000032078,null))))].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31449","meta31449",-1722878432,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async31448.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31448.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31448";

cljs.core.async.t_cljs$core$async31448.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async31448");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async31448 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async31448(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31449){
return (new cljs.core.async.t_cljs$core$async31448(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta31449));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async31448(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29898__auto___31611 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___31611,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___31611,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_31548){
var state_val_31549 = (state_31548[(1)]);
if((state_val_31549 === (7))){
var inst_31466 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
var statearr_31550_31612 = state_31548__$1;
(statearr_31550_31612[(2)] = inst_31466);

(statearr_31550_31612[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (20))){
var inst_31478 = (state_31548[(7)]);
var state_31548__$1 = state_31548;
var statearr_31551_31613 = state_31548__$1;
(statearr_31551_31613[(2)] = inst_31478);

(statearr_31551_31613[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (27))){
var state_31548__$1 = state_31548;
var statearr_31552_31614 = state_31548__$1;
(statearr_31552_31614[(2)] = null);

(statearr_31552_31614[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (1))){
var inst_31454 = (state_31548[(8)]);
var inst_31454__$1 = calc_state.call(null);
var inst_31456 = (inst_31454__$1 == null);
var inst_31457 = cljs.core.not.call(null,inst_31456);
var state_31548__$1 = (function (){var statearr_31553 = state_31548;
(statearr_31553[(8)] = inst_31454__$1);

return statearr_31553;
})();
if(inst_31457){
var statearr_31554_31615 = state_31548__$1;
(statearr_31554_31615[(1)] = (2));

} else {
var statearr_31555_31616 = state_31548__$1;
(statearr_31555_31616[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (24))){
var inst_31508 = (state_31548[(9)]);
var inst_31501 = (state_31548[(10)]);
var inst_31522 = (state_31548[(11)]);
var inst_31522__$1 = inst_31501.call(null,inst_31508);
var state_31548__$1 = (function (){var statearr_31556 = state_31548;
(statearr_31556[(11)] = inst_31522__$1);

return statearr_31556;
})();
if(cljs.core.truth_(inst_31522__$1)){
var statearr_31557_31617 = state_31548__$1;
(statearr_31557_31617[(1)] = (29));

} else {
var statearr_31558_31618 = state_31548__$1;
(statearr_31558_31618[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (4))){
var inst_31469 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31469)){
var statearr_31559_31619 = state_31548__$1;
(statearr_31559_31619[(1)] = (8));

} else {
var statearr_31560_31620 = state_31548__$1;
(statearr_31560_31620[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (15))){
var inst_31495 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31495)){
var statearr_31561_31621 = state_31548__$1;
(statearr_31561_31621[(1)] = (19));

} else {
var statearr_31562_31622 = state_31548__$1;
(statearr_31562_31622[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (21))){
var inst_31500 = (state_31548[(12)]);
var inst_31500__$1 = (state_31548[(2)]);
var inst_31501 = cljs.core.get.call(null,inst_31500__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31502 = cljs.core.get.call(null,inst_31500__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31503 = cljs.core.get.call(null,inst_31500__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31548__$1 = (function (){var statearr_31563 = state_31548;
(statearr_31563[(12)] = inst_31500__$1);

(statearr_31563[(13)] = inst_31502);

(statearr_31563[(10)] = inst_31501);

return statearr_31563;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_31548__$1,(22),inst_31503);
} else {
if((state_val_31549 === (31))){
var inst_31530 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31530)){
var statearr_31564_31623 = state_31548__$1;
(statearr_31564_31623[(1)] = (32));

} else {
var statearr_31565_31624 = state_31548__$1;
(statearr_31565_31624[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (32))){
var inst_31507 = (state_31548[(14)]);
var state_31548__$1 = state_31548;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31548__$1,(35),out,inst_31507);
} else {
if((state_val_31549 === (33))){
var inst_31500 = (state_31548[(12)]);
var inst_31478 = inst_31500;
var state_31548__$1 = (function (){var statearr_31566 = state_31548;
(statearr_31566[(7)] = inst_31478);

return statearr_31566;
})();
var statearr_31567_31625 = state_31548__$1;
(statearr_31567_31625[(2)] = null);

(statearr_31567_31625[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (13))){
var inst_31478 = (state_31548[(7)]);
var inst_31485 = inst_31478.cljs$lang$protocol_mask$partition0$;
var inst_31486 = (inst_31485 & (64));
var inst_31487 = inst_31478.cljs$core$ISeq$;
var inst_31488 = (inst_31486) || (inst_31487);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31488)){
var statearr_31568_31626 = state_31548__$1;
(statearr_31568_31626[(1)] = (16));

} else {
var statearr_31569_31627 = state_31548__$1;
(statearr_31569_31627[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (22))){
var inst_31508 = (state_31548[(9)]);
var inst_31507 = (state_31548[(14)]);
var inst_31506 = (state_31548[(2)]);
var inst_31507__$1 = cljs.core.nth.call(null,inst_31506,(0),null);
var inst_31508__$1 = cljs.core.nth.call(null,inst_31506,(1),null);
var inst_31509 = (inst_31507__$1 == null);
var inst_31510 = cljs.core._EQ_.call(null,inst_31508__$1,change);
var inst_31511 = (inst_31509) || (inst_31510);
var state_31548__$1 = (function (){var statearr_31570 = state_31548;
(statearr_31570[(9)] = inst_31508__$1);

(statearr_31570[(14)] = inst_31507__$1);

return statearr_31570;
})();
if(cljs.core.truth_(inst_31511)){
var statearr_31571_31628 = state_31548__$1;
(statearr_31571_31628[(1)] = (23));

} else {
var statearr_31572_31629 = state_31548__$1;
(statearr_31572_31629[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (36))){
var inst_31500 = (state_31548[(12)]);
var inst_31478 = inst_31500;
var state_31548__$1 = (function (){var statearr_31573 = state_31548;
(statearr_31573[(7)] = inst_31478);

return statearr_31573;
})();
var statearr_31574_31630 = state_31548__$1;
(statearr_31574_31630[(2)] = null);

(statearr_31574_31630[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (29))){
var inst_31522 = (state_31548[(11)]);
var state_31548__$1 = state_31548;
var statearr_31575_31631 = state_31548__$1;
(statearr_31575_31631[(2)] = inst_31522);

(statearr_31575_31631[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (6))){
var state_31548__$1 = state_31548;
var statearr_31576_31632 = state_31548__$1;
(statearr_31576_31632[(2)] = false);

(statearr_31576_31632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (28))){
var inst_31518 = (state_31548[(2)]);
var inst_31519 = calc_state.call(null);
var inst_31478 = inst_31519;
var state_31548__$1 = (function (){var statearr_31577 = state_31548;
(statearr_31577[(7)] = inst_31478);

(statearr_31577[(15)] = inst_31518);

return statearr_31577;
})();
var statearr_31578_31633 = state_31548__$1;
(statearr_31578_31633[(2)] = null);

(statearr_31578_31633[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (25))){
var inst_31544 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
var statearr_31579_31634 = state_31548__$1;
(statearr_31579_31634[(2)] = inst_31544);

(statearr_31579_31634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (34))){
var inst_31542 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
var statearr_31580_31635 = state_31548__$1;
(statearr_31580_31635[(2)] = inst_31542);

(statearr_31580_31635[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (17))){
var state_31548__$1 = state_31548;
var statearr_31581_31636 = state_31548__$1;
(statearr_31581_31636[(2)] = false);

(statearr_31581_31636[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (3))){
var state_31548__$1 = state_31548;
var statearr_31582_31637 = state_31548__$1;
(statearr_31582_31637[(2)] = false);

(statearr_31582_31637[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (12))){
var inst_31546 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31548__$1,inst_31546);
} else {
if((state_val_31549 === (2))){
var inst_31454 = (state_31548[(8)]);
var inst_31459 = inst_31454.cljs$lang$protocol_mask$partition0$;
var inst_31460 = (inst_31459 & (64));
var inst_31461 = inst_31454.cljs$core$ISeq$;
var inst_31462 = (inst_31460) || (inst_31461);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31462)){
var statearr_31583_31638 = state_31548__$1;
(statearr_31583_31638[(1)] = (5));

} else {
var statearr_31584_31639 = state_31548__$1;
(statearr_31584_31639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (23))){
var inst_31507 = (state_31548[(14)]);
var inst_31513 = (inst_31507 == null);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31513)){
var statearr_31585_31640 = state_31548__$1;
(statearr_31585_31640[(1)] = (26));

} else {
var statearr_31586_31641 = state_31548__$1;
(statearr_31586_31641[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (35))){
var inst_31533 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
if(cljs.core.truth_(inst_31533)){
var statearr_31587_31642 = state_31548__$1;
(statearr_31587_31642[(1)] = (36));

} else {
var statearr_31588_31643 = state_31548__$1;
(statearr_31588_31643[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (19))){
var inst_31478 = (state_31548[(7)]);
var inst_31497 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31478);
var state_31548__$1 = state_31548;
var statearr_31589_31644 = state_31548__$1;
(statearr_31589_31644[(2)] = inst_31497);

(statearr_31589_31644[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (11))){
var inst_31478 = (state_31548[(7)]);
var inst_31482 = (inst_31478 == null);
var inst_31483 = cljs.core.not.call(null,inst_31482);
var state_31548__$1 = state_31548;
if(inst_31483){
var statearr_31590_31645 = state_31548__$1;
(statearr_31590_31645[(1)] = (13));

} else {
var statearr_31591_31646 = state_31548__$1;
(statearr_31591_31646[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (9))){
var inst_31454 = (state_31548[(8)]);
var state_31548__$1 = state_31548;
var statearr_31592_31647 = state_31548__$1;
(statearr_31592_31647[(2)] = inst_31454);

(statearr_31592_31647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (5))){
var state_31548__$1 = state_31548;
var statearr_31593_31648 = state_31548__$1;
(statearr_31593_31648[(2)] = true);

(statearr_31593_31648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (14))){
var state_31548__$1 = state_31548;
var statearr_31594_31649 = state_31548__$1;
(statearr_31594_31649[(2)] = false);

(statearr_31594_31649[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (26))){
var inst_31508 = (state_31548[(9)]);
var inst_31515 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_31508);
var state_31548__$1 = state_31548;
var statearr_31595_31650 = state_31548__$1;
(statearr_31595_31650[(2)] = inst_31515);

(statearr_31595_31650[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (16))){
var state_31548__$1 = state_31548;
var statearr_31596_31651 = state_31548__$1;
(statearr_31596_31651[(2)] = true);

(statearr_31596_31651[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (38))){
var inst_31538 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
var statearr_31597_31652 = state_31548__$1;
(statearr_31597_31652[(2)] = inst_31538);

(statearr_31597_31652[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (30))){
var inst_31508 = (state_31548[(9)]);
var inst_31502 = (state_31548[(13)]);
var inst_31501 = (state_31548[(10)]);
var inst_31525 = cljs.core.empty_QMARK_.call(null,inst_31501);
var inst_31526 = inst_31502.call(null,inst_31508);
var inst_31527 = cljs.core.not.call(null,inst_31526);
var inst_31528 = (inst_31525) && (inst_31527);
var state_31548__$1 = state_31548;
var statearr_31598_31653 = state_31548__$1;
(statearr_31598_31653[(2)] = inst_31528);

(statearr_31598_31653[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (10))){
var inst_31454 = (state_31548[(8)]);
var inst_31474 = (state_31548[(2)]);
var inst_31475 = cljs.core.get.call(null,inst_31474,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31476 = cljs.core.get.call(null,inst_31474,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31477 = cljs.core.get.call(null,inst_31474,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31478 = inst_31454;
var state_31548__$1 = (function (){var statearr_31599 = state_31548;
(statearr_31599[(16)] = inst_31476);

(statearr_31599[(17)] = inst_31475);

(statearr_31599[(7)] = inst_31478);

(statearr_31599[(18)] = inst_31477);

return statearr_31599;
})();
var statearr_31600_31654 = state_31548__$1;
(statearr_31600_31654[(2)] = null);

(statearr_31600_31654[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (18))){
var inst_31492 = (state_31548[(2)]);
var state_31548__$1 = state_31548;
var statearr_31601_31655 = state_31548__$1;
(statearr_31601_31655[(2)] = inst_31492);

(statearr_31601_31655[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (37))){
var state_31548__$1 = state_31548;
var statearr_31602_31656 = state_31548__$1;
(statearr_31602_31656[(2)] = null);

(statearr_31602_31656[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31549 === (8))){
var inst_31454 = (state_31548[(8)]);
var inst_31471 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31454);
var state_31548__$1 = state_31548;
var statearr_31603_31657 = state_31548__$1;
(statearr_31603_31657[(2)] = inst_31471);

(statearr_31603_31657[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___31611,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__29786__auto__,c__29898__auto___31611,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__29787__auto__ = null;
var cljs$core$async$mix_$_state_machine__29787__auto____0 = (function (){
var statearr_31607 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31607[(0)] = cljs$core$async$mix_$_state_machine__29787__auto__);

(statearr_31607[(1)] = (1));

return statearr_31607;
});
var cljs$core$async$mix_$_state_machine__29787__auto____1 = (function (state_31548){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_31548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e31608){if((e31608 instanceof Object)){
var ex__29790__auto__ = e31608;
var statearr_31609_31658 = state_31548;
(statearr_31609_31658[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31608;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31659 = state_31548;
state_31548 = G__31659;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__29787__auto__ = function(state_31548){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__29787__auto____1.call(this,state_31548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__29787__auto____0;
cljs$core$async$mix_$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__29787__auto____1;
return cljs$core$async$mix_$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___31611,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__29900__auto__ = (function (){var statearr_31610 = f__29899__auto__.call(null);
(statearr_31610[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___31611);

return statearr_31610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___31611,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__28196__auto__ = (((p == null))?null:p);
var m__28197__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__28197__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__28196__auto__ = (((p == null))?null:p);
var m__28197__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,p,v,ch);
} else {
var m__28197__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args31660 = [];
var len__28599__auto___31663 = arguments.length;
var i__28600__auto___31664 = (0);
while(true){
if((i__28600__auto___31664 < len__28599__auto___31663)){
args31660.push((arguments[i__28600__auto___31664]));

var G__31665 = (i__28600__auto___31664 + (1));
i__28600__auto___31664 = G__31665;
continue;
} else {
}
break;
}

var G__31662 = args31660.length;
switch (G__31662) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31660.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__28196__auto__ = (((p == null))?null:p);
var m__28197__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,p);
} else {
var m__28197__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__28196__auto__ = (((p == null))?null:p);
var m__28197__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__28196__auto__)]);
if(!((m__28197__auto__ == null))){
return m__28197__auto__.call(null,p,v);
} else {
var m__28197__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__28197__auto____$1 == null))){
return m__28197__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args31668 = [];
var len__28599__auto___31793 = arguments.length;
var i__28600__auto___31794 = (0);
while(true){
if((i__28600__auto___31794 < len__28599__auto___31793)){
args31668.push((arguments[i__28600__auto___31794]));

var G__31795 = (i__28600__auto___31794 + (1));
i__28600__auto___31794 = G__31795;
continue;
} else {
}
break;
}

var G__31670 = args31668.length;
switch (G__31670) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31668.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27541__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27541__auto__)){
return or__27541__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27541__auto__,mults){
return (function (p1__31667_SHARP_){
if(cljs.core.truth_(p1__31667_SHARP_.call(null,topic))){
return p1__31667_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__31667_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27541__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async31671 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31671 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31672){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31672 = meta31672;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_31673,meta31672__$1){
var self__ = this;
var _31673__$1 = this;
return (new cljs.core.async.t_cljs$core$async31671(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31672__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_31673){
var self__ = this;
var _31673__$1 = this;
return self__.meta31672;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4425__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4425__auto__)){
var m = temp__4425__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31672","meta31672",1201507208,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async31671.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31671.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31671";

cljs.core.async.t_cljs$core$async31671.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async31671");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async31671 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async31671(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31672){
return (new cljs.core.async.t_cljs$core$async31671(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta31672));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async31671(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__29898__auto___31797 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___31797,mults,ensure_mult,p){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___31797,mults,ensure_mult,p){
return (function (state_31745){
var state_val_31746 = (state_31745[(1)]);
if((state_val_31746 === (7))){
var inst_31741 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
var statearr_31747_31798 = state_31745__$1;
(statearr_31747_31798[(2)] = inst_31741);

(statearr_31747_31798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (20))){
var state_31745__$1 = state_31745;
var statearr_31748_31799 = state_31745__$1;
(statearr_31748_31799[(2)] = null);

(statearr_31748_31799[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (1))){
var state_31745__$1 = state_31745;
var statearr_31749_31800 = state_31745__$1;
(statearr_31749_31800[(2)] = null);

(statearr_31749_31800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (24))){
var inst_31724 = (state_31745[(7)]);
var inst_31733 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_31724);
var state_31745__$1 = state_31745;
var statearr_31750_31801 = state_31745__$1;
(statearr_31750_31801[(2)] = inst_31733);

(statearr_31750_31801[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (4))){
var inst_31676 = (state_31745[(8)]);
var inst_31676__$1 = (state_31745[(2)]);
var inst_31677 = (inst_31676__$1 == null);
var state_31745__$1 = (function (){var statearr_31751 = state_31745;
(statearr_31751[(8)] = inst_31676__$1);

return statearr_31751;
})();
if(cljs.core.truth_(inst_31677)){
var statearr_31752_31802 = state_31745__$1;
(statearr_31752_31802[(1)] = (5));

} else {
var statearr_31753_31803 = state_31745__$1;
(statearr_31753_31803[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (15))){
var inst_31718 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
var statearr_31754_31804 = state_31745__$1;
(statearr_31754_31804[(2)] = inst_31718);

(statearr_31754_31804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (21))){
var inst_31738 = (state_31745[(2)]);
var state_31745__$1 = (function (){var statearr_31755 = state_31745;
(statearr_31755[(9)] = inst_31738);

return statearr_31755;
})();
var statearr_31756_31805 = state_31745__$1;
(statearr_31756_31805[(2)] = null);

(statearr_31756_31805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (13))){
var inst_31700 = (state_31745[(10)]);
var inst_31702 = cljs.core.chunked_seq_QMARK_.call(null,inst_31700);
var state_31745__$1 = state_31745;
if(inst_31702){
var statearr_31757_31806 = state_31745__$1;
(statearr_31757_31806[(1)] = (16));

} else {
var statearr_31758_31807 = state_31745__$1;
(statearr_31758_31807[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (22))){
var inst_31730 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
if(cljs.core.truth_(inst_31730)){
var statearr_31759_31808 = state_31745__$1;
(statearr_31759_31808[(1)] = (23));

} else {
var statearr_31760_31809 = state_31745__$1;
(statearr_31760_31809[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (6))){
var inst_31676 = (state_31745[(8)]);
var inst_31724 = (state_31745[(7)]);
var inst_31726 = (state_31745[(11)]);
var inst_31724__$1 = topic_fn.call(null,inst_31676);
var inst_31725 = cljs.core.deref.call(null,mults);
var inst_31726__$1 = cljs.core.get.call(null,inst_31725,inst_31724__$1);
var state_31745__$1 = (function (){var statearr_31761 = state_31745;
(statearr_31761[(7)] = inst_31724__$1);

(statearr_31761[(11)] = inst_31726__$1);

return statearr_31761;
})();
if(cljs.core.truth_(inst_31726__$1)){
var statearr_31762_31810 = state_31745__$1;
(statearr_31762_31810[(1)] = (19));

} else {
var statearr_31763_31811 = state_31745__$1;
(statearr_31763_31811[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (25))){
var inst_31735 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
var statearr_31764_31812 = state_31745__$1;
(statearr_31764_31812[(2)] = inst_31735);

(statearr_31764_31812[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (17))){
var inst_31700 = (state_31745[(10)]);
var inst_31709 = cljs.core.first.call(null,inst_31700);
var inst_31710 = cljs.core.async.muxch_STAR_.call(null,inst_31709);
var inst_31711 = cljs.core.async.close_BANG_.call(null,inst_31710);
var inst_31712 = cljs.core.next.call(null,inst_31700);
var inst_31686 = inst_31712;
var inst_31687 = null;
var inst_31688 = (0);
var inst_31689 = (0);
var state_31745__$1 = (function (){var statearr_31765 = state_31745;
(statearr_31765[(12)] = inst_31687);

(statearr_31765[(13)] = inst_31689);

(statearr_31765[(14)] = inst_31688);

(statearr_31765[(15)] = inst_31711);

(statearr_31765[(16)] = inst_31686);

return statearr_31765;
})();
var statearr_31766_31813 = state_31745__$1;
(statearr_31766_31813[(2)] = null);

(statearr_31766_31813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (3))){
var inst_31743 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31745__$1,inst_31743);
} else {
if((state_val_31746 === (12))){
var inst_31720 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
var statearr_31767_31814 = state_31745__$1;
(statearr_31767_31814[(2)] = inst_31720);

(statearr_31767_31814[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (2))){
var state_31745__$1 = state_31745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31745__$1,(4),ch);
} else {
if((state_val_31746 === (23))){
var state_31745__$1 = state_31745;
var statearr_31768_31815 = state_31745__$1;
(statearr_31768_31815[(2)] = null);

(statearr_31768_31815[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (19))){
var inst_31676 = (state_31745[(8)]);
var inst_31726 = (state_31745[(11)]);
var inst_31728 = cljs.core.async.muxch_STAR_.call(null,inst_31726);
var state_31745__$1 = state_31745;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31745__$1,(22),inst_31728,inst_31676);
} else {
if((state_val_31746 === (11))){
var inst_31700 = (state_31745[(10)]);
var inst_31686 = (state_31745[(16)]);
var inst_31700__$1 = cljs.core.seq.call(null,inst_31686);
var state_31745__$1 = (function (){var statearr_31769 = state_31745;
(statearr_31769[(10)] = inst_31700__$1);

return statearr_31769;
})();
if(inst_31700__$1){
var statearr_31770_31816 = state_31745__$1;
(statearr_31770_31816[(1)] = (13));

} else {
var statearr_31771_31817 = state_31745__$1;
(statearr_31771_31817[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (9))){
var inst_31722 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
var statearr_31772_31818 = state_31745__$1;
(statearr_31772_31818[(2)] = inst_31722);

(statearr_31772_31818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (5))){
var inst_31683 = cljs.core.deref.call(null,mults);
var inst_31684 = cljs.core.vals.call(null,inst_31683);
var inst_31685 = cljs.core.seq.call(null,inst_31684);
var inst_31686 = inst_31685;
var inst_31687 = null;
var inst_31688 = (0);
var inst_31689 = (0);
var state_31745__$1 = (function (){var statearr_31773 = state_31745;
(statearr_31773[(12)] = inst_31687);

(statearr_31773[(13)] = inst_31689);

(statearr_31773[(14)] = inst_31688);

(statearr_31773[(16)] = inst_31686);

return statearr_31773;
})();
var statearr_31774_31819 = state_31745__$1;
(statearr_31774_31819[(2)] = null);

(statearr_31774_31819[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (14))){
var state_31745__$1 = state_31745;
var statearr_31778_31820 = state_31745__$1;
(statearr_31778_31820[(2)] = null);

(statearr_31778_31820[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (16))){
var inst_31700 = (state_31745[(10)]);
var inst_31704 = cljs.core.chunk_first.call(null,inst_31700);
var inst_31705 = cljs.core.chunk_rest.call(null,inst_31700);
var inst_31706 = cljs.core.count.call(null,inst_31704);
var inst_31686 = inst_31705;
var inst_31687 = inst_31704;
var inst_31688 = inst_31706;
var inst_31689 = (0);
var state_31745__$1 = (function (){var statearr_31779 = state_31745;
(statearr_31779[(12)] = inst_31687);

(statearr_31779[(13)] = inst_31689);

(statearr_31779[(14)] = inst_31688);

(statearr_31779[(16)] = inst_31686);

return statearr_31779;
})();
var statearr_31780_31821 = state_31745__$1;
(statearr_31780_31821[(2)] = null);

(statearr_31780_31821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (10))){
var inst_31687 = (state_31745[(12)]);
var inst_31689 = (state_31745[(13)]);
var inst_31688 = (state_31745[(14)]);
var inst_31686 = (state_31745[(16)]);
var inst_31694 = cljs.core._nth.call(null,inst_31687,inst_31689);
var inst_31695 = cljs.core.async.muxch_STAR_.call(null,inst_31694);
var inst_31696 = cljs.core.async.close_BANG_.call(null,inst_31695);
var inst_31697 = (inst_31689 + (1));
var tmp31775 = inst_31687;
var tmp31776 = inst_31688;
var tmp31777 = inst_31686;
var inst_31686__$1 = tmp31777;
var inst_31687__$1 = tmp31775;
var inst_31688__$1 = tmp31776;
var inst_31689__$1 = inst_31697;
var state_31745__$1 = (function (){var statearr_31781 = state_31745;
(statearr_31781[(17)] = inst_31696);

(statearr_31781[(12)] = inst_31687__$1);

(statearr_31781[(13)] = inst_31689__$1);

(statearr_31781[(14)] = inst_31688__$1);

(statearr_31781[(16)] = inst_31686__$1);

return statearr_31781;
})();
var statearr_31782_31822 = state_31745__$1;
(statearr_31782_31822[(2)] = null);

(statearr_31782_31822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (18))){
var inst_31715 = (state_31745[(2)]);
var state_31745__$1 = state_31745;
var statearr_31783_31823 = state_31745__$1;
(statearr_31783_31823[(2)] = inst_31715);

(statearr_31783_31823[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31746 === (8))){
var inst_31689 = (state_31745[(13)]);
var inst_31688 = (state_31745[(14)]);
var inst_31691 = (inst_31689 < inst_31688);
var inst_31692 = inst_31691;
var state_31745__$1 = state_31745;
if(cljs.core.truth_(inst_31692)){
var statearr_31784_31824 = state_31745__$1;
(statearr_31784_31824[(1)] = (10));

} else {
var statearr_31785_31825 = state_31745__$1;
(statearr_31785_31825[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___31797,mults,ensure_mult,p))
;
return ((function (switch__29786__auto__,c__29898__auto___31797,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_31789 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31789[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_31789[(1)] = (1));

return statearr_31789;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_31745){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_31745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e31790){if((e31790 instanceof Object)){
var ex__29790__auto__ = e31790;
var statearr_31791_31826 = state_31745;
(statearr_31791_31826[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31790;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31827 = state_31745;
state_31745 = G__31827;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_31745){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_31745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___31797,mults,ensure_mult,p))
})();
var state__29900__auto__ = (function (){var statearr_31792 = f__29899__auto__.call(null);
(statearr_31792[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___31797);

return statearr_31792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___31797,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args31828 = [];
var len__28599__auto___31831 = arguments.length;
var i__28600__auto___31832 = (0);
while(true){
if((i__28600__auto___31832 < len__28599__auto___31831)){
args31828.push((arguments[i__28600__auto___31832]));

var G__31833 = (i__28600__auto___31832 + (1));
i__28600__auto___31832 = G__31833;
continue;
} else {
}
break;
}

var G__31830 = args31828.length;
switch (G__31830) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31828.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args31835 = [];
var len__28599__auto___31838 = arguments.length;
var i__28600__auto___31839 = (0);
while(true){
if((i__28600__auto___31839 < len__28599__auto___31838)){
args31835.push((arguments[i__28600__auto___31839]));

var G__31840 = (i__28600__auto___31839 + (1));
i__28600__auto___31839 = G__31840;
continue;
} else {
}
break;
}

var G__31837 = args31835.length;
switch (G__31837) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31835.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args31842 = [];
var len__28599__auto___31913 = arguments.length;
var i__28600__auto___31914 = (0);
while(true){
if((i__28600__auto___31914 < len__28599__auto___31913)){
args31842.push((arguments[i__28600__auto___31914]));

var G__31915 = (i__28600__auto___31914 + (1));
i__28600__auto___31914 = G__31915;
continue;
} else {
}
break;
}

var G__31844 = args31842.length;
switch (G__31844) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31842.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__29898__auto___31917 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___31917,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___31917,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_31883){
var state_val_31884 = (state_31883[(1)]);
if((state_val_31884 === (7))){
var state_31883__$1 = state_31883;
var statearr_31885_31918 = state_31883__$1;
(statearr_31885_31918[(2)] = null);

(statearr_31885_31918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (1))){
var state_31883__$1 = state_31883;
var statearr_31886_31919 = state_31883__$1;
(statearr_31886_31919[(2)] = null);

(statearr_31886_31919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (4))){
var inst_31847 = (state_31883[(7)]);
var inst_31849 = (inst_31847 < cnt);
var state_31883__$1 = state_31883;
if(cljs.core.truth_(inst_31849)){
var statearr_31887_31920 = state_31883__$1;
(statearr_31887_31920[(1)] = (6));

} else {
var statearr_31888_31921 = state_31883__$1;
(statearr_31888_31921[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (15))){
var inst_31879 = (state_31883[(2)]);
var state_31883__$1 = state_31883;
var statearr_31889_31922 = state_31883__$1;
(statearr_31889_31922[(2)] = inst_31879);

(statearr_31889_31922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (13))){
var inst_31872 = cljs.core.async.close_BANG_.call(null,out);
var state_31883__$1 = state_31883;
var statearr_31890_31923 = state_31883__$1;
(statearr_31890_31923[(2)] = inst_31872);

(statearr_31890_31923[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (6))){
var state_31883__$1 = state_31883;
var statearr_31891_31924 = state_31883__$1;
(statearr_31891_31924[(2)] = null);

(statearr_31891_31924[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (3))){
var inst_31881 = (state_31883[(2)]);
var state_31883__$1 = state_31883;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31883__$1,inst_31881);
} else {
if((state_val_31884 === (12))){
var inst_31869 = (state_31883[(8)]);
var inst_31869__$1 = (state_31883[(2)]);
var inst_31870 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_31869__$1);
var state_31883__$1 = (function (){var statearr_31892 = state_31883;
(statearr_31892[(8)] = inst_31869__$1);

return statearr_31892;
})();
if(cljs.core.truth_(inst_31870)){
var statearr_31893_31925 = state_31883__$1;
(statearr_31893_31925[(1)] = (13));

} else {
var statearr_31894_31926 = state_31883__$1;
(statearr_31894_31926[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (2))){
var inst_31846 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_31847 = (0);
var state_31883__$1 = (function (){var statearr_31895 = state_31883;
(statearr_31895[(9)] = inst_31846);

(statearr_31895[(7)] = inst_31847);

return statearr_31895;
})();
var statearr_31896_31927 = state_31883__$1;
(statearr_31896_31927[(2)] = null);

(statearr_31896_31927[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (11))){
var inst_31847 = (state_31883[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_31883,(10),Object,null,(9));
var inst_31856 = chs__$1.call(null,inst_31847);
var inst_31857 = done.call(null,inst_31847);
var inst_31858 = cljs.core.async.take_BANG_.call(null,inst_31856,inst_31857);
var state_31883__$1 = state_31883;
var statearr_31897_31928 = state_31883__$1;
(statearr_31897_31928[(2)] = inst_31858);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31883__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (9))){
var inst_31847 = (state_31883[(7)]);
var inst_31860 = (state_31883[(2)]);
var inst_31861 = (inst_31847 + (1));
var inst_31847__$1 = inst_31861;
var state_31883__$1 = (function (){var statearr_31898 = state_31883;
(statearr_31898[(10)] = inst_31860);

(statearr_31898[(7)] = inst_31847__$1);

return statearr_31898;
})();
var statearr_31899_31929 = state_31883__$1;
(statearr_31899_31929[(2)] = null);

(statearr_31899_31929[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (5))){
var inst_31867 = (state_31883[(2)]);
var state_31883__$1 = (function (){var statearr_31900 = state_31883;
(statearr_31900[(11)] = inst_31867);

return statearr_31900;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31883__$1,(12),dchan);
} else {
if((state_val_31884 === (14))){
var inst_31869 = (state_31883[(8)]);
var inst_31874 = cljs.core.apply.call(null,f,inst_31869);
var state_31883__$1 = state_31883;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31883__$1,(16),out,inst_31874);
} else {
if((state_val_31884 === (16))){
var inst_31876 = (state_31883[(2)]);
var state_31883__$1 = (function (){var statearr_31901 = state_31883;
(statearr_31901[(12)] = inst_31876);

return statearr_31901;
})();
var statearr_31902_31930 = state_31883__$1;
(statearr_31902_31930[(2)] = null);

(statearr_31902_31930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (10))){
var inst_31851 = (state_31883[(2)]);
var inst_31852 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_31883__$1 = (function (){var statearr_31903 = state_31883;
(statearr_31903[(13)] = inst_31851);

return statearr_31903;
})();
var statearr_31904_31931 = state_31883__$1;
(statearr_31904_31931[(2)] = inst_31852);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31883__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31884 === (8))){
var inst_31865 = (state_31883[(2)]);
var state_31883__$1 = state_31883;
var statearr_31905_31932 = state_31883__$1;
(statearr_31905_31932[(2)] = inst_31865);

(statearr_31905_31932[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___31917,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__29786__auto__,c__29898__auto___31917,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_31909 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31909[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_31909[(1)] = (1));

return statearr_31909;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_31883){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_31883);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e31910){if((e31910 instanceof Object)){
var ex__29790__auto__ = e31910;
var statearr_31911_31933 = state_31883;
(statearr_31911_31933[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31883);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31910;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31934 = state_31883;
state_31883 = G__31934;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_31883){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_31883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___31917,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__29900__auto__ = (function (){var statearr_31912 = f__29899__auto__.call(null);
(statearr_31912[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___31917);

return statearr_31912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___31917,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args31936 = [];
var len__28599__auto___31992 = arguments.length;
var i__28600__auto___31993 = (0);
while(true){
if((i__28600__auto___31993 < len__28599__auto___31992)){
args31936.push((arguments[i__28600__auto___31993]));

var G__31994 = (i__28600__auto___31993 + (1));
i__28600__auto___31993 = G__31994;
continue;
} else {
}
break;
}

var G__31938 = args31936.length;
switch (G__31938) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31936.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29898__auto___31996 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___31996,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___31996,out){
return (function (state_31968){
var state_val_31969 = (state_31968[(1)]);
if((state_val_31969 === (7))){
var inst_31948 = (state_31968[(7)]);
var inst_31947 = (state_31968[(8)]);
var inst_31947__$1 = (state_31968[(2)]);
var inst_31948__$1 = cljs.core.nth.call(null,inst_31947__$1,(0),null);
var inst_31949 = cljs.core.nth.call(null,inst_31947__$1,(1),null);
var inst_31950 = (inst_31948__$1 == null);
var state_31968__$1 = (function (){var statearr_31970 = state_31968;
(statearr_31970[(9)] = inst_31949);

(statearr_31970[(7)] = inst_31948__$1);

(statearr_31970[(8)] = inst_31947__$1);

return statearr_31970;
})();
if(cljs.core.truth_(inst_31950)){
var statearr_31971_31997 = state_31968__$1;
(statearr_31971_31997[(1)] = (8));

} else {
var statearr_31972_31998 = state_31968__$1;
(statearr_31972_31998[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (1))){
var inst_31939 = cljs.core.vec.call(null,chs);
var inst_31940 = inst_31939;
var state_31968__$1 = (function (){var statearr_31973 = state_31968;
(statearr_31973[(10)] = inst_31940);

return statearr_31973;
})();
var statearr_31974_31999 = state_31968__$1;
(statearr_31974_31999[(2)] = null);

(statearr_31974_31999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (4))){
var inst_31940 = (state_31968[(10)]);
var state_31968__$1 = state_31968;
return cljs.core.async.ioc_alts_BANG_.call(null,state_31968__$1,(7),inst_31940);
} else {
if((state_val_31969 === (6))){
var inst_31964 = (state_31968[(2)]);
var state_31968__$1 = state_31968;
var statearr_31975_32000 = state_31968__$1;
(statearr_31975_32000[(2)] = inst_31964);

(statearr_31975_32000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (3))){
var inst_31966 = (state_31968[(2)]);
var state_31968__$1 = state_31968;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31968__$1,inst_31966);
} else {
if((state_val_31969 === (2))){
var inst_31940 = (state_31968[(10)]);
var inst_31942 = cljs.core.count.call(null,inst_31940);
var inst_31943 = (inst_31942 > (0));
var state_31968__$1 = state_31968;
if(cljs.core.truth_(inst_31943)){
var statearr_31977_32001 = state_31968__$1;
(statearr_31977_32001[(1)] = (4));

} else {
var statearr_31978_32002 = state_31968__$1;
(statearr_31978_32002[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (11))){
var inst_31940 = (state_31968[(10)]);
var inst_31957 = (state_31968[(2)]);
var tmp31976 = inst_31940;
var inst_31940__$1 = tmp31976;
var state_31968__$1 = (function (){var statearr_31979 = state_31968;
(statearr_31979[(10)] = inst_31940__$1);

(statearr_31979[(11)] = inst_31957);

return statearr_31979;
})();
var statearr_31980_32003 = state_31968__$1;
(statearr_31980_32003[(2)] = null);

(statearr_31980_32003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (9))){
var inst_31948 = (state_31968[(7)]);
var state_31968__$1 = state_31968;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31968__$1,(11),out,inst_31948);
} else {
if((state_val_31969 === (5))){
var inst_31962 = cljs.core.async.close_BANG_.call(null,out);
var state_31968__$1 = state_31968;
var statearr_31981_32004 = state_31968__$1;
(statearr_31981_32004[(2)] = inst_31962);

(statearr_31981_32004[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (10))){
var inst_31960 = (state_31968[(2)]);
var state_31968__$1 = state_31968;
var statearr_31982_32005 = state_31968__$1;
(statearr_31982_32005[(2)] = inst_31960);

(statearr_31982_32005[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31969 === (8))){
var inst_31940 = (state_31968[(10)]);
var inst_31949 = (state_31968[(9)]);
var inst_31948 = (state_31968[(7)]);
var inst_31947 = (state_31968[(8)]);
var inst_31952 = (function (){var cs = inst_31940;
var vec__31945 = inst_31947;
var v = inst_31948;
var c = inst_31949;
return ((function (cs,vec__31945,v,c,inst_31940,inst_31949,inst_31948,inst_31947,state_val_31969,c__29898__auto___31996,out){
return (function (p1__31935_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__31935_SHARP_);
});
;})(cs,vec__31945,v,c,inst_31940,inst_31949,inst_31948,inst_31947,state_val_31969,c__29898__auto___31996,out))
})();
var inst_31953 = cljs.core.filterv.call(null,inst_31952,inst_31940);
var inst_31940__$1 = inst_31953;
var state_31968__$1 = (function (){var statearr_31983 = state_31968;
(statearr_31983[(10)] = inst_31940__$1);

return statearr_31983;
})();
var statearr_31984_32006 = state_31968__$1;
(statearr_31984_32006[(2)] = null);

(statearr_31984_32006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___31996,out))
;
return ((function (switch__29786__auto__,c__29898__auto___31996,out){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_31988 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31988[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_31988[(1)] = (1));

return statearr_31988;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_31968){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_31968);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e31989){if((e31989 instanceof Object)){
var ex__29790__auto__ = e31989;
var statearr_31990_32007 = state_31968;
(statearr_31990_32007[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31968);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31989;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32008 = state_31968;
state_31968 = G__32008;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_31968){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_31968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___31996,out))
})();
var state__29900__auto__ = (function (){var statearr_31991 = f__29899__auto__.call(null);
(statearr_31991[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___31996);

return statearr_31991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___31996,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args32009 = [];
var len__28599__auto___32058 = arguments.length;
var i__28600__auto___32059 = (0);
while(true){
if((i__28600__auto___32059 < len__28599__auto___32058)){
args32009.push((arguments[i__28600__auto___32059]));

var G__32060 = (i__28600__auto___32059 + (1));
i__28600__auto___32059 = G__32060;
continue;
} else {
}
break;
}

var G__32011 = args32009.length;
switch (G__32011) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32009.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29898__auto___32062 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___32062,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___32062,out){
return (function (state_32035){
var state_val_32036 = (state_32035[(1)]);
if((state_val_32036 === (7))){
var inst_32017 = (state_32035[(7)]);
var inst_32017__$1 = (state_32035[(2)]);
var inst_32018 = (inst_32017__$1 == null);
var inst_32019 = cljs.core.not.call(null,inst_32018);
var state_32035__$1 = (function (){var statearr_32037 = state_32035;
(statearr_32037[(7)] = inst_32017__$1);

return statearr_32037;
})();
if(inst_32019){
var statearr_32038_32063 = state_32035__$1;
(statearr_32038_32063[(1)] = (8));

} else {
var statearr_32039_32064 = state_32035__$1;
(statearr_32039_32064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (1))){
var inst_32012 = (0);
var state_32035__$1 = (function (){var statearr_32040 = state_32035;
(statearr_32040[(8)] = inst_32012);

return statearr_32040;
})();
var statearr_32041_32065 = state_32035__$1;
(statearr_32041_32065[(2)] = null);

(statearr_32041_32065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (4))){
var state_32035__$1 = state_32035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32035__$1,(7),ch);
} else {
if((state_val_32036 === (6))){
var inst_32030 = (state_32035[(2)]);
var state_32035__$1 = state_32035;
var statearr_32042_32066 = state_32035__$1;
(statearr_32042_32066[(2)] = inst_32030);

(statearr_32042_32066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (3))){
var inst_32032 = (state_32035[(2)]);
var inst_32033 = cljs.core.async.close_BANG_.call(null,out);
var state_32035__$1 = (function (){var statearr_32043 = state_32035;
(statearr_32043[(9)] = inst_32032);

return statearr_32043;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32035__$1,inst_32033);
} else {
if((state_val_32036 === (2))){
var inst_32012 = (state_32035[(8)]);
var inst_32014 = (inst_32012 < n);
var state_32035__$1 = state_32035;
if(cljs.core.truth_(inst_32014)){
var statearr_32044_32067 = state_32035__$1;
(statearr_32044_32067[(1)] = (4));

} else {
var statearr_32045_32068 = state_32035__$1;
(statearr_32045_32068[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (11))){
var inst_32012 = (state_32035[(8)]);
var inst_32022 = (state_32035[(2)]);
var inst_32023 = (inst_32012 + (1));
var inst_32012__$1 = inst_32023;
var state_32035__$1 = (function (){var statearr_32046 = state_32035;
(statearr_32046[(8)] = inst_32012__$1);

(statearr_32046[(10)] = inst_32022);

return statearr_32046;
})();
var statearr_32047_32069 = state_32035__$1;
(statearr_32047_32069[(2)] = null);

(statearr_32047_32069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (9))){
var state_32035__$1 = state_32035;
var statearr_32048_32070 = state_32035__$1;
(statearr_32048_32070[(2)] = null);

(statearr_32048_32070[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (5))){
var state_32035__$1 = state_32035;
var statearr_32049_32071 = state_32035__$1;
(statearr_32049_32071[(2)] = null);

(statearr_32049_32071[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (10))){
var inst_32027 = (state_32035[(2)]);
var state_32035__$1 = state_32035;
var statearr_32050_32072 = state_32035__$1;
(statearr_32050_32072[(2)] = inst_32027);

(statearr_32050_32072[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32036 === (8))){
var inst_32017 = (state_32035[(7)]);
var state_32035__$1 = state_32035;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32035__$1,(11),out,inst_32017);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___32062,out))
;
return ((function (switch__29786__auto__,c__29898__auto___32062,out){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_32054 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32054[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_32054[(1)] = (1));

return statearr_32054;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_32035){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_32035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e32055){if((e32055 instanceof Object)){
var ex__29790__auto__ = e32055;
var statearr_32056_32073 = state_32035;
(statearr_32056_32073[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32055;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32074 = state_32035;
state_32035 = G__32074;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_32035){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_32035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___32062,out))
})();
var state__29900__auto__ = (function (){var statearr_32057 = f__29899__auto__.call(null);
(statearr_32057[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___32062);

return statearr_32057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___32062,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32082 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32082 = (function (map_LT_,f,ch,meta32083){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32083 = meta32083;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32084,meta32083__$1){
var self__ = this;
var _32084__$1 = this;
return (new cljs.core.async.t_cljs$core$async32082(self__.map_LT_,self__.f,self__.ch,meta32083__$1));
});

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32084){
var self__ = this;
var _32084__$1 = this;
return self__.meta32083;
});

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async32085 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32085 = (function (map_LT_,f,ch,meta32083,_,fn1,meta32086){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta32083 = meta32083;
this._ = _;
this.fn1 = fn1;
this.meta32086 = meta32086;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_32087,meta32086__$1){
var self__ = this;
var _32087__$1 = this;
return (new cljs.core.async.t_cljs$core$async32085(self__.map_LT_,self__.f,self__.ch,self__.meta32083,self__._,self__.fn1,meta32086__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_32087){
var self__ = this;
var _32087__$1 = this;
return self__.meta32086;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async32085.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__32075_SHARP_){
return f1.call(null,(((p1__32075_SHARP_ == null))?null:self__.f.call(null,p1__32075_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async32085.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32083","meta32083",-1684081562,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32082","cljs.core.async/t_cljs$core$async32082",-1240557711,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32086","meta32086",1307443528,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async32085.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32085.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32085";

cljs.core.async.t_cljs$core$async32085.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async32085");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async32085 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32085(map_LT___$1,f__$1,ch__$1,meta32083__$1,___$2,fn1__$1,meta32086){
return (new cljs.core.async.t_cljs$core$async32085(map_LT___$1,f__$1,ch__$1,meta32083__$1,___$2,fn1__$1,meta32086));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async32085(self__.map_LT_,self__.f,self__.ch,self__.meta32083,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27529__auto__ = ret;
if(cljs.core.truth_(and__27529__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27529__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32082.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async32082.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32083","meta32083",-1684081562,null)], null);
});

cljs.core.async.t_cljs$core$async32082.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32082.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32082";

cljs.core.async.t_cljs$core$async32082.cljs$lang$ctorPrWriter = (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async32082");
});

cljs.core.async.__GT_t_cljs$core$async32082 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async32082(map_LT___$1,f__$1,ch__$1,meta32083){
return (new cljs.core.async.t_cljs$core$async32082(map_LT___$1,f__$1,ch__$1,meta32083));
});

}

return (new cljs.core.async.t_cljs$core$async32082(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async32091 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32091 = (function (map_GT_,f,ch,meta32092){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta32092 = meta32092;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32093,meta32092__$1){
var self__ = this;
var _32093__$1 = this;
return (new cljs.core.async.t_cljs$core$async32091(self__.map_GT_,self__.f,self__.ch,meta32092__$1));
});

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32093){
var self__ = this;
var _32093__$1 = this;
return self__.meta32092;
});

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32091.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async32091.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32092","meta32092",362115543,null)], null);
});

cljs.core.async.t_cljs$core$async32091.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32091.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32091";

cljs.core.async.t_cljs$core$async32091.cljs$lang$ctorPrWriter = (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async32091");
});

cljs.core.async.__GT_t_cljs$core$async32091 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async32091(map_GT___$1,f__$1,ch__$1,meta32092){
return (new cljs.core.async.t_cljs$core$async32091(map_GT___$1,f__$1,ch__$1,meta32092));
});

}

return (new cljs.core.async.t_cljs$core$async32091(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async32097 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32097 = (function (filter_GT_,p,ch,meta32098){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta32098 = meta32098;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32099,meta32098__$1){
var self__ = this;
var _32099__$1 = this;
return (new cljs.core.async.t_cljs$core$async32097(self__.filter_GT_,self__.p,self__.ch,meta32098__$1));
});

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32099){
var self__ = this;
var _32099__$1 = this;
return self__.meta32098;
});

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async32097.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async32097.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32098","meta32098",-2023072736,null)], null);
});

cljs.core.async.t_cljs$core$async32097.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32097.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32097";

cljs.core.async.t_cljs$core$async32097.cljs$lang$ctorPrWriter = (function (this__28139__auto__,writer__28140__auto__,opt__28141__auto__){
return cljs.core._write.call(null,writer__28140__auto__,"cljs.core.async/t_cljs$core$async32097");
});

cljs.core.async.__GT_t_cljs$core$async32097 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async32097(filter_GT___$1,p__$1,ch__$1,meta32098){
return (new cljs.core.async.t_cljs$core$async32097(filter_GT___$1,p__$1,ch__$1,meta32098));
});

}

return (new cljs.core.async.t_cljs$core$async32097(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args32100 = [];
var len__28599__auto___32144 = arguments.length;
var i__28600__auto___32145 = (0);
while(true){
if((i__28600__auto___32145 < len__28599__auto___32144)){
args32100.push((arguments[i__28600__auto___32145]));

var G__32146 = (i__28600__auto___32145 + (1));
i__28600__auto___32145 = G__32146;
continue;
} else {
}
break;
}

var G__32102 = args32100.length;
switch (G__32102) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32100.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29898__auto___32148 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___32148,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___32148,out){
return (function (state_32123){
var state_val_32124 = (state_32123[(1)]);
if((state_val_32124 === (7))){
var inst_32119 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32125_32149 = state_32123__$1;
(statearr_32125_32149[(2)] = inst_32119);

(statearr_32125_32149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (1))){
var state_32123__$1 = state_32123;
var statearr_32126_32150 = state_32123__$1;
(statearr_32126_32150[(2)] = null);

(statearr_32126_32150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (4))){
var inst_32105 = (state_32123[(7)]);
var inst_32105__$1 = (state_32123[(2)]);
var inst_32106 = (inst_32105__$1 == null);
var state_32123__$1 = (function (){var statearr_32127 = state_32123;
(statearr_32127[(7)] = inst_32105__$1);

return statearr_32127;
})();
if(cljs.core.truth_(inst_32106)){
var statearr_32128_32151 = state_32123__$1;
(statearr_32128_32151[(1)] = (5));

} else {
var statearr_32129_32152 = state_32123__$1;
(statearr_32129_32152[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (6))){
var inst_32105 = (state_32123[(7)]);
var inst_32110 = p.call(null,inst_32105);
var state_32123__$1 = state_32123;
if(cljs.core.truth_(inst_32110)){
var statearr_32130_32153 = state_32123__$1;
(statearr_32130_32153[(1)] = (8));

} else {
var statearr_32131_32154 = state_32123__$1;
(statearr_32131_32154[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (3))){
var inst_32121 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32123__$1,inst_32121);
} else {
if((state_val_32124 === (2))){
var state_32123__$1 = state_32123;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32123__$1,(4),ch);
} else {
if((state_val_32124 === (11))){
var inst_32113 = (state_32123[(2)]);
var state_32123__$1 = state_32123;
var statearr_32132_32155 = state_32123__$1;
(statearr_32132_32155[(2)] = inst_32113);

(statearr_32132_32155[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (9))){
var state_32123__$1 = state_32123;
var statearr_32133_32156 = state_32123__$1;
(statearr_32133_32156[(2)] = null);

(statearr_32133_32156[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (5))){
var inst_32108 = cljs.core.async.close_BANG_.call(null,out);
var state_32123__$1 = state_32123;
var statearr_32134_32157 = state_32123__$1;
(statearr_32134_32157[(2)] = inst_32108);

(statearr_32134_32157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (10))){
var inst_32116 = (state_32123[(2)]);
var state_32123__$1 = (function (){var statearr_32135 = state_32123;
(statearr_32135[(8)] = inst_32116);

return statearr_32135;
})();
var statearr_32136_32158 = state_32123__$1;
(statearr_32136_32158[(2)] = null);

(statearr_32136_32158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32124 === (8))){
var inst_32105 = (state_32123[(7)]);
var state_32123__$1 = state_32123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32123__$1,(11),out,inst_32105);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___32148,out))
;
return ((function (switch__29786__auto__,c__29898__auto___32148,out){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_32140 = [null,null,null,null,null,null,null,null,null];
(statearr_32140[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_32140[(1)] = (1));

return statearr_32140;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_32123){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_32123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e32141){if((e32141 instanceof Object)){
var ex__29790__auto__ = e32141;
var statearr_32142_32159 = state_32123;
(statearr_32142_32159[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32123);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32160 = state_32123;
state_32123 = G__32160;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_32123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_32123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___32148,out))
})();
var state__29900__auto__ = (function (){var statearr_32143 = f__29899__auto__.call(null);
(statearr_32143[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___32148);

return statearr_32143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___32148,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args32161 = [];
var len__28599__auto___32164 = arguments.length;
var i__28600__auto___32165 = (0);
while(true){
if((i__28600__auto___32165 < len__28599__auto___32164)){
args32161.push((arguments[i__28600__auto___32165]));

var G__32166 = (i__28600__auto___32165 + (1));
i__28600__auto___32165 = G__32166;
continue;
} else {
}
break;
}

var G__32163 = args32161.length;
switch (G__32163) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32161.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__29898__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto__){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto__){
return (function (state_32333){
var state_val_32334 = (state_32333[(1)]);
if((state_val_32334 === (7))){
var inst_32329 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
var statearr_32335_32376 = state_32333__$1;
(statearr_32335_32376[(2)] = inst_32329);

(statearr_32335_32376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (20))){
var inst_32299 = (state_32333[(7)]);
var inst_32310 = (state_32333[(2)]);
var inst_32311 = cljs.core.next.call(null,inst_32299);
var inst_32285 = inst_32311;
var inst_32286 = null;
var inst_32287 = (0);
var inst_32288 = (0);
var state_32333__$1 = (function (){var statearr_32336 = state_32333;
(statearr_32336[(8)] = inst_32286);

(statearr_32336[(9)] = inst_32310);

(statearr_32336[(10)] = inst_32285);

(statearr_32336[(11)] = inst_32287);

(statearr_32336[(12)] = inst_32288);

return statearr_32336;
})();
var statearr_32337_32377 = state_32333__$1;
(statearr_32337_32377[(2)] = null);

(statearr_32337_32377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (1))){
var state_32333__$1 = state_32333;
var statearr_32338_32378 = state_32333__$1;
(statearr_32338_32378[(2)] = null);

(statearr_32338_32378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (4))){
var inst_32274 = (state_32333[(13)]);
var inst_32274__$1 = (state_32333[(2)]);
var inst_32275 = (inst_32274__$1 == null);
var state_32333__$1 = (function (){var statearr_32339 = state_32333;
(statearr_32339[(13)] = inst_32274__$1);

return statearr_32339;
})();
if(cljs.core.truth_(inst_32275)){
var statearr_32340_32379 = state_32333__$1;
(statearr_32340_32379[(1)] = (5));

} else {
var statearr_32341_32380 = state_32333__$1;
(statearr_32341_32380[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (15))){
var state_32333__$1 = state_32333;
var statearr_32345_32381 = state_32333__$1;
(statearr_32345_32381[(2)] = null);

(statearr_32345_32381[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (21))){
var state_32333__$1 = state_32333;
var statearr_32346_32382 = state_32333__$1;
(statearr_32346_32382[(2)] = null);

(statearr_32346_32382[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (13))){
var inst_32286 = (state_32333[(8)]);
var inst_32285 = (state_32333[(10)]);
var inst_32287 = (state_32333[(11)]);
var inst_32288 = (state_32333[(12)]);
var inst_32295 = (state_32333[(2)]);
var inst_32296 = (inst_32288 + (1));
var tmp32342 = inst_32286;
var tmp32343 = inst_32285;
var tmp32344 = inst_32287;
var inst_32285__$1 = tmp32343;
var inst_32286__$1 = tmp32342;
var inst_32287__$1 = tmp32344;
var inst_32288__$1 = inst_32296;
var state_32333__$1 = (function (){var statearr_32347 = state_32333;
(statearr_32347[(14)] = inst_32295);

(statearr_32347[(8)] = inst_32286__$1);

(statearr_32347[(10)] = inst_32285__$1);

(statearr_32347[(11)] = inst_32287__$1);

(statearr_32347[(12)] = inst_32288__$1);

return statearr_32347;
})();
var statearr_32348_32383 = state_32333__$1;
(statearr_32348_32383[(2)] = null);

(statearr_32348_32383[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (22))){
var state_32333__$1 = state_32333;
var statearr_32349_32384 = state_32333__$1;
(statearr_32349_32384[(2)] = null);

(statearr_32349_32384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (6))){
var inst_32274 = (state_32333[(13)]);
var inst_32283 = f.call(null,inst_32274);
var inst_32284 = cljs.core.seq.call(null,inst_32283);
var inst_32285 = inst_32284;
var inst_32286 = null;
var inst_32287 = (0);
var inst_32288 = (0);
var state_32333__$1 = (function (){var statearr_32350 = state_32333;
(statearr_32350[(8)] = inst_32286);

(statearr_32350[(10)] = inst_32285);

(statearr_32350[(11)] = inst_32287);

(statearr_32350[(12)] = inst_32288);

return statearr_32350;
})();
var statearr_32351_32385 = state_32333__$1;
(statearr_32351_32385[(2)] = null);

(statearr_32351_32385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (17))){
var inst_32299 = (state_32333[(7)]);
var inst_32303 = cljs.core.chunk_first.call(null,inst_32299);
var inst_32304 = cljs.core.chunk_rest.call(null,inst_32299);
var inst_32305 = cljs.core.count.call(null,inst_32303);
var inst_32285 = inst_32304;
var inst_32286 = inst_32303;
var inst_32287 = inst_32305;
var inst_32288 = (0);
var state_32333__$1 = (function (){var statearr_32352 = state_32333;
(statearr_32352[(8)] = inst_32286);

(statearr_32352[(10)] = inst_32285);

(statearr_32352[(11)] = inst_32287);

(statearr_32352[(12)] = inst_32288);

return statearr_32352;
})();
var statearr_32353_32386 = state_32333__$1;
(statearr_32353_32386[(2)] = null);

(statearr_32353_32386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (3))){
var inst_32331 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32333__$1,inst_32331);
} else {
if((state_val_32334 === (12))){
var inst_32319 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
var statearr_32354_32387 = state_32333__$1;
(statearr_32354_32387[(2)] = inst_32319);

(statearr_32354_32387[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (2))){
var state_32333__$1 = state_32333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32333__$1,(4),in$);
} else {
if((state_val_32334 === (23))){
var inst_32327 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
var statearr_32355_32388 = state_32333__$1;
(statearr_32355_32388[(2)] = inst_32327);

(statearr_32355_32388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (19))){
var inst_32314 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
var statearr_32356_32389 = state_32333__$1;
(statearr_32356_32389[(2)] = inst_32314);

(statearr_32356_32389[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (11))){
var inst_32299 = (state_32333[(7)]);
var inst_32285 = (state_32333[(10)]);
var inst_32299__$1 = cljs.core.seq.call(null,inst_32285);
var state_32333__$1 = (function (){var statearr_32357 = state_32333;
(statearr_32357[(7)] = inst_32299__$1);

return statearr_32357;
})();
if(inst_32299__$1){
var statearr_32358_32390 = state_32333__$1;
(statearr_32358_32390[(1)] = (14));

} else {
var statearr_32359_32391 = state_32333__$1;
(statearr_32359_32391[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (9))){
var inst_32321 = (state_32333[(2)]);
var inst_32322 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_32333__$1 = (function (){var statearr_32360 = state_32333;
(statearr_32360[(15)] = inst_32321);

return statearr_32360;
})();
if(cljs.core.truth_(inst_32322)){
var statearr_32361_32392 = state_32333__$1;
(statearr_32361_32392[(1)] = (21));

} else {
var statearr_32362_32393 = state_32333__$1;
(statearr_32362_32393[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (5))){
var inst_32277 = cljs.core.async.close_BANG_.call(null,out);
var state_32333__$1 = state_32333;
var statearr_32363_32394 = state_32333__$1;
(statearr_32363_32394[(2)] = inst_32277);

(statearr_32363_32394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (14))){
var inst_32299 = (state_32333[(7)]);
var inst_32301 = cljs.core.chunked_seq_QMARK_.call(null,inst_32299);
var state_32333__$1 = state_32333;
if(inst_32301){
var statearr_32364_32395 = state_32333__$1;
(statearr_32364_32395[(1)] = (17));

} else {
var statearr_32365_32396 = state_32333__$1;
(statearr_32365_32396[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (16))){
var inst_32317 = (state_32333[(2)]);
var state_32333__$1 = state_32333;
var statearr_32366_32397 = state_32333__$1;
(statearr_32366_32397[(2)] = inst_32317);

(statearr_32366_32397[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32334 === (10))){
var inst_32286 = (state_32333[(8)]);
var inst_32288 = (state_32333[(12)]);
var inst_32293 = cljs.core._nth.call(null,inst_32286,inst_32288);
var state_32333__$1 = state_32333;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32333__$1,(13),out,inst_32293);
} else {
if((state_val_32334 === (18))){
var inst_32299 = (state_32333[(7)]);
var inst_32308 = cljs.core.first.call(null,inst_32299);
var state_32333__$1 = state_32333;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32333__$1,(20),out,inst_32308);
} else {
if((state_val_32334 === (8))){
var inst_32287 = (state_32333[(11)]);
var inst_32288 = (state_32333[(12)]);
var inst_32290 = (inst_32288 < inst_32287);
var inst_32291 = inst_32290;
var state_32333__$1 = state_32333;
if(cljs.core.truth_(inst_32291)){
var statearr_32367_32398 = state_32333__$1;
(statearr_32367_32398[(1)] = (10));

} else {
var statearr_32368_32399 = state_32333__$1;
(statearr_32368_32399[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto__))
;
return ((function (switch__29786__auto__,c__29898__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__29787__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__29787__auto____0 = (function (){
var statearr_32372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32372[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__29787__auto__);

(statearr_32372[(1)] = (1));

return statearr_32372;
});
var cljs$core$async$mapcat_STAR__$_state_machine__29787__auto____1 = (function (state_32333){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_32333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e32373){if((e32373 instanceof Object)){
var ex__29790__auto__ = e32373;
var statearr_32374_32400 = state_32333;
(statearr_32374_32400[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32373;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32401 = state_32333;
state_32333 = G__32401;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__29787__auto__ = function(state_32333){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__29787__auto____1.call(this,state_32333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__29787__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__29787__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto__))
})();
var state__29900__auto__ = (function (){var statearr_32375 = f__29899__auto__.call(null);
(statearr_32375[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto__);

return statearr_32375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto__))
);

return c__29898__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args32402 = [];
var len__28599__auto___32405 = arguments.length;
var i__28600__auto___32406 = (0);
while(true){
if((i__28600__auto___32406 < len__28599__auto___32405)){
args32402.push((arguments[i__28600__auto___32406]));

var G__32407 = (i__28600__auto___32406 + (1));
i__28600__auto___32406 = G__32407;
continue;
} else {
}
break;
}

var G__32404 = args32402.length;
switch (G__32404) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32402.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args32409 = [];
var len__28599__auto___32412 = arguments.length;
var i__28600__auto___32413 = (0);
while(true){
if((i__28600__auto___32413 < len__28599__auto___32412)){
args32409.push((arguments[i__28600__auto___32413]));

var G__32414 = (i__28600__auto___32413 + (1));
i__28600__auto___32413 = G__32414;
continue;
} else {
}
break;
}

var G__32411 = args32409.length;
switch (G__32411) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32409.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args32416 = [];
var len__28599__auto___32467 = arguments.length;
var i__28600__auto___32468 = (0);
while(true){
if((i__28600__auto___32468 < len__28599__auto___32467)){
args32416.push((arguments[i__28600__auto___32468]));

var G__32469 = (i__28600__auto___32468 + (1));
i__28600__auto___32468 = G__32469;
continue;
} else {
}
break;
}

var G__32418 = args32416.length;
switch (G__32418) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32416.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29898__auto___32471 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___32471,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___32471,out){
return (function (state_32442){
var state_val_32443 = (state_32442[(1)]);
if((state_val_32443 === (7))){
var inst_32437 = (state_32442[(2)]);
var state_32442__$1 = state_32442;
var statearr_32444_32472 = state_32442__$1;
(statearr_32444_32472[(2)] = inst_32437);

(statearr_32444_32472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (1))){
var inst_32419 = null;
var state_32442__$1 = (function (){var statearr_32445 = state_32442;
(statearr_32445[(7)] = inst_32419);

return statearr_32445;
})();
var statearr_32446_32473 = state_32442__$1;
(statearr_32446_32473[(2)] = null);

(statearr_32446_32473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (4))){
var inst_32422 = (state_32442[(8)]);
var inst_32422__$1 = (state_32442[(2)]);
var inst_32423 = (inst_32422__$1 == null);
var inst_32424 = cljs.core.not.call(null,inst_32423);
var state_32442__$1 = (function (){var statearr_32447 = state_32442;
(statearr_32447[(8)] = inst_32422__$1);

return statearr_32447;
})();
if(inst_32424){
var statearr_32448_32474 = state_32442__$1;
(statearr_32448_32474[(1)] = (5));

} else {
var statearr_32449_32475 = state_32442__$1;
(statearr_32449_32475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (6))){
var state_32442__$1 = state_32442;
var statearr_32450_32476 = state_32442__$1;
(statearr_32450_32476[(2)] = null);

(statearr_32450_32476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (3))){
var inst_32439 = (state_32442[(2)]);
var inst_32440 = cljs.core.async.close_BANG_.call(null,out);
var state_32442__$1 = (function (){var statearr_32451 = state_32442;
(statearr_32451[(9)] = inst_32439);

return statearr_32451;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32442__$1,inst_32440);
} else {
if((state_val_32443 === (2))){
var state_32442__$1 = state_32442;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32442__$1,(4),ch);
} else {
if((state_val_32443 === (11))){
var inst_32422 = (state_32442[(8)]);
var inst_32431 = (state_32442[(2)]);
var inst_32419 = inst_32422;
var state_32442__$1 = (function (){var statearr_32452 = state_32442;
(statearr_32452[(10)] = inst_32431);

(statearr_32452[(7)] = inst_32419);

return statearr_32452;
})();
var statearr_32453_32477 = state_32442__$1;
(statearr_32453_32477[(2)] = null);

(statearr_32453_32477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (9))){
var inst_32422 = (state_32442[(8)]);
var state_32442__$1 = state_32442;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32442__$1,(11),out,inst_32422);
} else {
if((state_val_32443 === (5))){
var inst_32422 = (state_32442[(8)]);
var inst_32419 = (state_32442[(7)]);
var inst_32426 = cljs.core._EQ_.call(null,inst_32422,inst_32419);
var state_32442__$1 = state_32442;
if(inst_32426){
var statearr_32455_32478 = state_32442__$1;
(statearr_32455_32478[(1)] = (8));

} else {
var statearr_32456_32479 = state_32442__$1;
(statearr_32456_32479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (10))){
var inst_32434 = (state_32442[(2)]);
var state_32442__$1 = state_32442;
var statearr_32457_32480 = state_32442__$1;
(statearr_32457_32480[(2)] = inst_32434);

(statearr_32457_32480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32443 === (8))){
var inst_32419 = (state_32442[(7)]);
var tmp32454 = inst_32419;
var inst_32419__$1 = tmp32454;
var state_32442__$1 = (function (){var statearr_32458 = state_32442;
(statearr_32458[(7)] = inst_32419__$1);

return statearr_32458;
})();
var statearr_32459_32481 = state_32442__$1;
(statearr_32459_32481[(2)] = null);

(statearr_32459_32481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___32471,out))
;
return ((function (switch__29786__auto__,c__29898__auto___32471,out){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_32463 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32463[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_32463[(1)] = (1));

return statearr_32463;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_32442){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_32442);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e32464){if((e32464 instanceof Object)){
var ex__29790__auto__ = e32464;
var statearr_32465_32482 = state_32442;
(statearr_32465_32482[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32442);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32464;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32483 = state_32442;
state_32442 = G__32483;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_32442){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_32442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___32471,out))
})();
var state__29900__auto__ = (function (){var statearr_32466 = f__29899__auto__.call(null);
(statearr_32466[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___32471);

return statearr_32466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___32471,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args32484 = [];
var len__28599__auto___32554 = arguments.length;
var i__28600__auto___32555 = (0);
while(true){
if((i__28600__auto___32555 < len__28599__auto___32554)){
args32484.push((arguments[i__28600__auto___32555]));

var G__32556 = (i__28600__auto___32555 + (1));
i__28600__auto___32555 = G__32556;
continue;
} else {
}
break;
}

var G__32486 = args32484.length;
switch (G__32486) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32484.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29898__auto___32558 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___32558,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___32558,out){
return (function (state_32524){
var state_val_32525 = (state_32524[(1)]);
if((state_val_32525 === (7))){
var inst_32520 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
var statearr_32526_32559 = state_32524__$1;
(statearr_32526_32559[(2)] = inst_32520);

(statearr_32526_32559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (1))){
var inst_32487 = (new Array(n));
var inst_32488 = inst_32487;
var inst_32489 = (0);
var state_32524__$1 = (function (){var statearr_32527 = state_32524;
(statearr_32527[(7)] = inst_32488);

(statearr_32527[(8)] = inst_32489);

return statearr_32527;
})();
var statearr_32528_32560 = state_32524__$1;
(statearr_32528_32560[(2)] = null);

(statearr_32528_32560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (4))){
var inst_32492 = (state_32524[(9)]);
var inst_32492__$1 = (state_32524[(2)]);
var inst_32493 = (inst_32492__$1 == null);
var inst_32494 = cljs.core.not.call(null,inst_32493);
var state_32524__$1 = (function (){var statearr_32529 = state_32524;
(statearr_32529[(9)] = inst_32492__$1);

return statearr_32529;
})();
if(inst_32494){
var statearr_32530_32561 = state_32524__$1;
(statearr_32530_32561[(1)] = (5));

} else {
var statearr_32531_32562 = state_32524__$1;
(statearr_32531_32562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (15))){
var inst_32514 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
var statearr_32532_32563 = state_32524__$1;
(statearr_32532_32563[(2)] = inst_32514);

(statearr_32532_32563[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (13))){
var state_32524__$1 = state_32524;
var statearr_32533_32564 = state_32524__$1;
(statearr_32533_32564[(2)] = null);

(statearr_32533_32564[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (6))){
var inst_32489 = (state_32524[(8)]);
var inst_32510 = (inst_32489 > (0));
var state_32524__$1 = state_32524;
if(cljs.core.truth_(inst_32510)){
var statearr_32534_32565 = state_32524__$1;
(statearr_32534_32565[(1)] = (12));

} else {
var statearr_32535_32566 = state_32524__$1;
(statearr_32535_32566[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (3))){
var inst_32522 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32524__$1,inst_32522);
} else {
if((state_val_32525 === (12))){
var inst_32488 = (state_32524[(7)]);
var inst_32512 = cljs.core.vec.call(null,inst_32488);
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32524__$1,(15),out,inst_32512);
} else {
if((state_val_32525 === (2))){
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32524__$1,(4),ch);
} else {
if((state_val_32525 === (11))){
var inst_32504 = (state_32524[(2)]);
var inst_32505 = (new Array(n));
var inst_32488 = inst_32505;
var inst_32489 = (0);
var state_32524__$1 = (function (){var statearr_32536 = state_32524;
(statearr_32536[(7)] = inst_32488);

(statearr_32536[(10)] = inst_32504);

(statearr_32536[(8)] = inst_32489);

return statearr_32536;
})();
var statearr_32537_32567 = state_32524__$1;
(statearr_32537_32567[(2)] = null);

(statearr_32537_32567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (9))){
var inst_32488 = (state_32524[(7)]);
var inst_32502 = cljs.core.vec.call(null,inst_32488);
var state_32524__$1 = state_32524;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32524__$1,(11),out,inst_32502);
} else {
if((state_val_32525 === (5))){
var inst_32488 = (state_32524[(7)]);
var inst_32492 = (state_32524[(9)]);
var inst_32489 = (state_32524[(8)]);
var inst_32497 = (state_32524[(11)]);
var inst_32496 = (inst_32488[inst_32489] = inst_32492);
var inst_32497__$1 = (inst_32489 + (1));
var inst_32498 = (inst_32497__$1 < n);
var state_32524__$1 = (function (){var statearr_32538 = state_32524;
(statearr_32538[(12)] = inst_32496);

(statearr_32538[(11)] = inst_32497__$1);

return statearr_32538;
})();
if(cljs.core.truth_(inst_32498)){
var statearr_32539_32568 = state_32524__$1;
(statearr_32539_32568[(1)] = (8));

} else {
var statearr_32540_32569 = state_32524__$1;
(statearr_32540_32569[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (14))){
var inst_32517 = (state_32524[(2)]);
var inst_32518 = cljs.core.async.close_BANG_.call(null,out);
var state_32524__$1 = (function (){var statearr_32542 = state_32524;
(statearr_32542[(13)] = inst_32517);

return statearr_32542;
})();
var statearr_32543_32570 = state_32524__$1;
(statearr_32543_32570[(2)] = inst_32518);

(statearr_32543_32570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (10))){
var inst_32508 = (state_32524[(2)]);
var state_32524__$1 = state_32524;
var statearr_32544_32571 = state_32524__$1;
(statearr_32544_32571[(2)] = inst_32508);

(statearr_32544_32571[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32525 === (8))){
var inst_32488 = (state_32524[(7)]);
var inst_32497 = (state_32524[(11)]);
var tmp32541 = inst_32488;
var inst_32488__$1 = tmp32541;
var inst_32489 = inst_32497;
var state_32524__$1 = (function (){var statearr_32545 = state_32524;
(statearr_32545[(7)] = inst_32488__$1);

(statearr_32545[(8)] = inst_32489);

return statearr_32545;
})();
var statearr_32546_32572 = state_32524__$1;
(statearr_32546_32572[(2)] = null);

(statearr_32546_32572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___32558,out))
;
return ((function (switch__29786__auto__,c__29898__auto___32558,out){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_32550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32550[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_32550[(1)] = (1));

return statearr_32550;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_32524){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_32524);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e32551){if((e32551 instanceof Object)){
var ex__29790__auto__ = e32551;
var statearr_32552_32573 = state_32524;
(statearr_32552_32573[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32524);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32551;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32574 = state_32524;
state_32524 = G__32574;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_32524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_32524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___32558,out))
})();
var state__29900__auto__ = (function (){var statearr_32553 = f__29899__auto__.call(null);
(statearr_32553[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___32558);

return statearr_32553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___32558,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args32575 = [];
var len__28599__auto___32649 = arguments.length;
var i__28600__auto___32650 = (0);
while(true){
if((i__28600__auto___32650 < len__28599__auto___32649)){
args32575.push((arguments[i__28600__auto___32650]));

var G__32651 = (i__28600__auto___32650 + (1));
i__28600__auto___32650 = G__32651;
continue;
} else {
}
break;
}

var G__32577 = args32575.length;
switch (G__32577) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32575.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__29898__auto___32653 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__29898__auto___32653,out){
return (function (){
var f__29899__auto__ = (function (){var switch__29786__auto__ = ((function (c__29898__auto___32653,out){
return (function (state_32619){
var state_val_32620 = (state_32619[(1)]);
if((state_val_32620 === (7))){
var inst_32615 = (state_32619[(2)]);
var state_32619__$1 = state_32619;
var statearr_32621_32654 = state_32619__$1;
(statearr_32621_32654[(2)] = inst_32615);

(statearr_32621_32654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (1))){
var inst_32578 = [];
var inst_32579 = inst_32578;
var inst_32580 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32619__$1 = (function (){var statearr_32622 = state_32619;
(statearr_32622[(7)] = inst_32579);

(statearr_32622[(8)] = inst_32580);

return statearr_32622;
})();
var statearr_32623_32655 = state_32619__$1;
(statearr_32623_32655[(2)] = null);

(statearr_32623_32655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (4))){
var inst_32583 = (state_32619[(9)]);
var inst_32583__$1 = (state_32619[(2)]);
var inst_32584 = (inst_32583__$1 == null);
var inst_32585 = cljs.core.not.call(null,inst_32584);
var state_32619__$1 = (function (){var statearr_32624 = state_32619;
(statearr_32624[(9)] = inst_32583__$1);

return statearr_32624;
})();
if(inst_32585){
var statearr_32625_32656 = state_32619__$1;
(statearr_32625_32656[(1)] = (5));

} else {
var statearr_32626_32657 = state_32619__$1;
(statearr_32626_32657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (15))){
var inst_32609 = (state_32619[(2)]);
var state_32619__$1 = state_32619;
var statearr_32627_32658 = state_32619__$1;
(statearr_32627_32658[(2)] = inst_32609);

(statearr_32627_32658[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (13))){
var state_32619__$1 = state_32619;
var statearr_32628_32659 = state_32619__$1;
(statearr_32628_32659[(2)] = null);

(statearr_32628_32659[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (6))){
var inst_32579 = (state_32619[(7)]);
var inst_32604 = inst_32579.length;
var inst_32605 = (inst_32604 > (0));
var state_32619__$1 = state_32619;
if(cljs.core.truth_(inst_32605)){
var statearr_32629_32660 = state_32619__$1;
(statearr_32629_32660[(1)] = (12));

} else {
var statearr_32630_32661 = state_32619__$1;
(statearr_32630_32661[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (3))){
var inst_32617 = (state_32619[(2)]);
var state_32619__$1 = state_32619;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32619__$1,inst_32617);
} else {
if((state_val_32620 === (12))){
var inst_32579 = (state_32619[(7)]);
var inst_32607 = cljs.core.vec.call(null,inst_32579);
var state_32619__$1 = state_32619;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32619__$1,(15),out,inst_32607);
} else {
if((state_val_32620 === (2))){
var state_32619__$1 = state_32619;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32619__$1,(4),ch);
} else {
if((state_val_32620 === (11))){
var inst_32583 = (state_32619[(9)]);
var inst_32587 = (state_32619[(10)]);
var inst_32597 = (state_32619[(2)]);
var inst_32598 = [];
var inst_32599 = inst_32598.push(inst_32583);
var inst_32579 = inst_32598;
var inst_32580 = inst_32587;
var state_32619__$1 = (function (){var statearr_32631 = state_32619;
(statearr_32631[(11)] = inst_32597);

(statearr_32631[(7)] = inst_32579);

(statearr_32631[(12)] = inst_32599);

(statearr_32631[(8)] = inst_32580);

return statearr_32631;
})();
var statearr_32632_32662 = state_32619__$1;
(statearr_32632_32662[(2)] = null);

(statearr_32632_32662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (9))){
var inst_32579 = (state_32619[(7)]);
var inst_32595 = cljs.core.vec.call(null,inst_32579);
var state_32619__$1 = state_32619;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32619__$1,(11),out,inst_32595);
} else {
if((state_val_32620 === (5))){
var inst_32583 = (state_32619[(9)]);
var inst_32580 = (state_32619[(8)]);
var inst_32587 = (state_32619[(10)]);
var inst_32587__$1 = f.call(null,inst_32583);
var inst_32588 = cljs.core._EQ_.call(null,inst_32587__$1,inst_32580);
var inst_32589 = cljs.core.keyword_identical_QMARK_.call(null,inst_32580,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_32590 = (inst_32588) || (inst_32589);
var state_32619__$1 = (function (){var statearr_32633 = state_32619;
(statearr_32633[(10)] = inst_32587__$1);

return statearr_32633;
})();
if(cljs.core.truth_(inst_32590)){
var statearr_32634_32663 = state_32619__$1;
(statearr_32634_32663[(1)] = (8));

} else {
var statearr_32635_32664 = state_32619__$1;
(statearr_32635_32664[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (14))){
var inst_32612 = (state_32619[(2)]);
var inst_32613 = cljs.core.async.close_BANG_.call(null,out);
var state_32619__$1 = (function (){var statearr_32637 = state_32619;
(statearr_32637[(13)] = inst_32612);

return statearr_32637;
})();
var statearr_32638_32665 = state_32619__$1;
(statearr_32638_32665[(2)] = inst_32613);

(statearr_32638_32665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (10))){
var inst_32602 = (state_32619[(2)]);
var state_32619__$1 = state_32619;
var statearr_32639_32666 = state_32619__$1;
(statearr_32639_32666[(2)] = inst_32602);

(statearr_32639_32666[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32620 === (8))){
var inst_32579 = (state_32619[(7)]);
var inst_32583 = (state_32619[(9)]);
var inst_32587 = (state_32619[(10)]);
var inst_32592 = inst_32579.push(inst_32583);
var tmp32636 = inst_32579;
var inst_32579__$1 = tmp32636;
var inst_32580 = inst_32587;
var state_32619__$1 = (function (){var statearr_32640 = state_32619;
(statearr_32640[(7)] = inst_32579__$1);

(statearr_32640[(8)] = inst_32580);

(statearr_32640[(14)] = inst_32592);

return statearr_32640;
})();
var statearr_32641_32667 = state_32619__$1;
(statearr_32641_32667[(2)] = null);

(statearr_32641_32667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__29898__auto___32653,out))
;
return ((function (switch__29786__auto__,c__29898__auto___32653,out){
return (function() {
var cljs$core$async$state_machine__29787__auto__ = null;
var cljs$core$async$state_machine__29787__auto____0 = (function (){
var statearr_32645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32645[(0)] = cljs$core$async$state_machine__29787__auto__);

(statearr_32645[(1)] = (1));

return statearr_32645;
});
var cljs$core$async$state_machine__29787__auto____1 = (function (state_32619){
while(true){
var ret_value__29788__auto__ = (function (){try{while(true){
var result__29789__auto__ = switch__29786__auto__.call(null,state_32619);
if(cljs.core.keyword_identical_QMARK_.call(null,result__29789__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__29789__auto__;
}
break;
}
}catch (e32646){if((e32646 instanceof Object)){
var ex__29790__auto__ = e32646;
var statearr_32647_32668 = state_32619;
(statearr_32647_32668[(5)] = ex__29790__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32619);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32646;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__29788__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32669 = state_32619;
state_32619 = G__32669;
continue;
} else {
return ret_value__29788__auto__;
}
break;
}
});
cljs$core$async$state_machine__29787__auto__ = function(state_32619){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__29787__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__29787__auto____1.call(this,state_32619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__29787__auto____0;
cljs$core$async$state_machine__29787__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__29787__auto____1;
return cljs$core$async$state_machine__29787__auto__;
})()
;})(switch__29786__auto__,c__29898__auto___32653,out))
})();
var state__29900__auto__ = (function (){var statearr_32648 = f__29899__auto__.call(null);
(statearr_32648[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__29898__auto___32653);

return statearr_32648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__29900__auto__);
});})(c__29898__auto___32653,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map