/*
 * Decompiled with CFR 0.152.
 */
package exoscale.specs.validator;

import exoscale.specs.validator.RegexValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class InetAddressValidator
implements Serializable {
    private static final int MAX_BYTE = 128;
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int BASE_16 = 16;
    private static final long serialVersionUID = -919201640201914789L;
    private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final InetAddressValidator VALIDATOR = new InetAddressValidator();
    private final RegexValidator ipv4Validator = new RegexValidator("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");

    public static InetAddressValidator getInstance() {
        return VALIDATOR;
    }

    public boolean isValid(String string) {
        return this.isValidInet4Address(string) || this.isValidInet6Address(string);
    }

    public boolean isValidInet4Address(String string) {
        String[] stringArray = this.ipv4Validator.match(string);
        if (stringArray == null) {
            return false;
        }
        for (String string2 : stringArray) {
            if (string2 == null || string2.isEmpty()) {
                return false;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n > 255) {
                return false;
            }
            if (string2.length() <= 1 || !string2.startsWith("0")) continue;
            return false;
        }
        return true;
    }

    public boolean isValidInet6Address(String string) {
        int n;
        String[] stringArray = string.split("/", -1);
        if (stringArray.length > 2) {
            return false;
        }
        if (stringArray.length == 2) {
            if (stringArray[1].matches("\\d{1,3}")) {
                n = Integer.parseInt(stringArray[1]);
                if (n < 0 || n > 128) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((stringArray = stringArray[0].split("%", -1)).length > 2) {
            return false;
        }
        if (stringArray.length == 2 && !stringArray[1].matches("[^\\s/%]+")) {
            return false;
        }
        string = stringArray[0];
        n = string.contains("::") ? 1 : 0;
        if (n != 0 && string.indexOf("::") != string.lastIndexOf("::")) {
            return false;
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            return false;
        }
        String[] stringArray2 = string.split(":");
        if (n != 0) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
            if (string.endsWith("::")) {
                arrayList.add("");
            } else if (string.startsWith("::") && !arrayList.isEmpty()) {
                arrayList.remove(0);
            }
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        if (stringArray2.length > 8) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            if (string2.isEmpty()) {
                if (++n3 > 1) {
                    return false;
                }
            } else {
                n3 = 0;
                if (i == stringArray2.length - 1 && string2.contains(".")) {
                    if (!this.isValidInet4Address(string2)) {
                        return false;
                    }
                    n2 += 2;
                    continue;
                }
                if (string2.length() > 4) {
                    return false;
                }
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (n4 < 0 || n4 > 65535) {
                    return false;
                }
            }
            ++n2;
        }
        return n2 <= 8 && (n2 >= 8 || n != 0);
    }
}

