(ns exoscale.specs.net
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str])
  #?:clj ((:import (exoscale.specs.validator InetAddressValidator))))

#?(:clj (def ^:private ^InetAddressValidator validator
          (InetAddressValidator/getInstance)))

(s/def ::ipv4 (s/and string?
                     #?(:clj #(.isValidInet4Address validator %)
                        ;; https://owasp.org/www-community/OWASP_Validation_Regex_Repository
                        :cljs #(re-matches #"^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"
                                           %))))
(s/def ::ipv6 (s/and string?
                     #?(:clj #(.isValidInet6Address validator %)
                        ;; https://stackoverflow.com/questions/32368008/regular-expression-that-matches-all-valid-format-ipv6-addresses
                        :cljs #(re-find #"(?:^|(?<=\s))(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))(?=\s|$)"
                                        %))))

(s/def ::ip (s/or :ipv4 ::ipv4
                  :ipv6 ::ipv6))

(s/def ::mac-address
  (s/and string?
         #(re-matches #"([0-9a-fA-F]{2}:??){5}([0-9a-fA-F]{2})" %)))

(s/def ::port (s/int-in 0 65353))

(s/def ::url
  (s/and string?
         #(try
            (->> %
                 (java.net.URI.)
                 (.getScheme)
                 str/lower-case
                 (contains? #{"https" "http"}))
            (catch Exception _))))
