(ns exoscale.specs.string
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str]))

(defn string-of*
  [{:keys [min-length max-length length
           trim? blank? re]}]
  (fn [s]
    (and (string? s)
         (let [s (cond-> s trim? str/trim)
               len (.length ^String s)]
           (and
            (or (not (boolean? blank?))
                (= (str/blank? s) blank?))
            (or (not max-length)
                (<= len max-length))
            (or (not min-length)
                (>= len min-length))
            (or (not length)
                (= length len))
            (or (not re)
                (re-matches re s)))))))

(defmacro string-of
  "Returns a spec that will check conditions against string with
  AND. The options are loosely based on coll-of.

  * :trim? - trim value before checking

  Combined with AND:
  * :max-length - max size
  * :min-length - min size
  * :length - exact size
  * :re - regex matching string
  * :blank? -check for blank"
  [opts]
  ;; FIXME we could create custom generators, but for now we don't
  ;; care, doing s/and ensure coax and simple gen would work
  `(s/and string? (string-of* ~opts)))
