(ns exoscale.specs.string
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str]))

(defn string-of*
  [{:keys [min-count max-count count
           trim? blank? re]}]
  (fn [s]
    (and (string? s)
         (let [s (cond-> s trim? str/trim)
               len (.length ^String s)]
           (and
            (or (not (boolean? blank?))
                (= (str/blank? s) blank?))
            (or (not max-count)
                (<= len max-count))
            (or (not min-count)
                (>= len min-count))
            (or (not count)
                (= count len))
            (or (not re)
                (re-matches re s)))))))

(defmacro string-of
  "Returns a spec that will check conditions against string with
  AND. The options are loosely based on coll-of.

  * :trim? - trim value before checking

  Combined with AND:
  * :max-count - max size
  * :min-count - min size
  * :count - exact size
  * :re - regex matching string
  * :blank? -check for blank"
  [opts]
  ;; FIXME we could create custom generators, but for now we don't
  ;; care, doing s/and ensure coax and simple gen would work
  `(s/and string? (string-of* ~opts)))
