(ns exoscale.checkmate.sync
  (:require [exoscale.checkmate.impl :as impl]))

;; can throw or return ctx with :exoscale.checkmate/error
(defn- attempt!
  "because loop will not allow recur from catch"
  [handler f ctx]
  ;; remove previous error, if any
  (let [ctx (dissoc ctx :exoscale.checkmate/error)]
    (try
      (handler ctx (f ctx))
      (catch Exception e
        (impl/error-ctx ctx e))
      (catch AssertionError e
        (impl/error-ctx ctx e)))))

(defn- effects!
  [k {:as ctx :exoscale.checkmate/keys [conditions]}]
  (run! (fn [cd]
          (when-let [f (get cd k)]
            (f ctx)))
        conditions))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts
          :exoscale.checkmate.hook/keys [success error failure]
          :exoscale.checkmate/keys [handler return]}
         (merge impl/default-options opts)
         ctx (-> (impl/init-ctx opts conditions)
                 (impl/setup-conditions :sync))]
     (effects! :exoscale.checkmate/setup-effect! ctx)
     (loop [ctx ctx]
       (let [ctx (attempt! handler f ctx)]
         (if (impl/error? ctx)
           ;; got an error
           ;; check continue on all conditions, abort on first false
           (let [ctx (impl/abort-ctx ctx)]
             (if (impl/fail? ctx)
               (do
                 (failure ctx)
                 (effects! :exoscale.checkmate/failure-effect! ctx)
                 (-> (impl/teardown-conditions ctx)
                     :exoscale.checkmate/error
                     throw))
               (do
                 (error ctx)
                 (effects! :exoscale.checkmate/error-effect! ctx)
                 (recur (impl/update-conditions ctx)))))
           (do
             (success ctx)
             (effects! :exoscale.checkmate/success-effect! ctx)
             (return (impl/teardown-conditions ctx)))))))))
