(ns exoscale.checkmate.manifold
  (:require [exoscale.checkmate.impl :as impl]
            [manifold.deferred :as d]))

(defn- effects!
  [k {:as ctx :exoscale.checkmate/keys [conditions]}]
  (apply d/zip
         (keep #(when-let [f (get % k)]
                  (fn [] (f ctx)))
               conditions)))

(defn- attempt!
  [handler f ctx]
  (let [ctx (dissoc ctx :exoscale.checkmate/error)]
    (->
     (d/chain ctx
              f
              (fn [ctx']
                (handler ctx ctx')))
     (d/catch Exception
         (fn [e] (impl/error-ctx ctx e))))))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts
          :exoscale.checkmate.hook/keys [success error failure]
          :exoscale.checkmate/keys [handler return]}
         (merge impl/default-options opts)
         ctx (-> (impl/init-ctx opts conditions)
                 (impl/setup-conditions :auspex))]
     (effects! :exoscale.checkmate/setup-effect! ctx)
     (d/loop [ctx ctx]
       (d/chain (attempt! handler f ctx)
                (fn [ctx]
                  (if (impl/error? ctx)
                    (let [ctx (impl/abort-ctx ctx)]
                      (if (impl/fail? ctx)
                        (do
                          (failure ctx)
                          (d/chain (effects! :exoscale.checkmate/failure-effect! ctx)
                                   (fn [_]
                                     (d/error-deferred (:exoscale.checkmate/error ctx)))))
                        (do
                          (error ctx)
                          (d/chain (effects! :exoscale.checkmate/error-effect! ctx)
                                   (fn [_] (d/recur (impl/update-conditions ctx)))))))
                    (do
                      (success ctx)
                      (d/chain (effects! :exoscale.checkmate/success-effect! ctx)
                               (fn [_]
                                 (-> ctx
                                     impl/teardown-conditions
                                     return)))))))))))
