(ns exoscale.checkmate.core-async
  (:require [clojure.core.async :as async]
            [exoscale.checkmate.impl :as impl]))

(defn- effects!
  [k conditions ctx]
  (async/go
    (doseq [cd conditions]
      (when-let [f (get cd k)]
        (async/<! (f ctx)))
      conditions)))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts
          :exoscale.checkmate.hook/keys [success error failure]
          :exoscale.checkmate.core.async/keys [ch]}
         (merge impl/default-options opts)
         ch (or ch (async/promise-chan))
         ctx (impl/setup-conditions conditions opts :core-async)]
     (effects! :exoscale.checkmate/setup-effect! conditions ctx)
     (async/go-loop [ctx ctx]
       (when-let [ret (async/<! (f))]
         (if (instance? Exception ret)
           (let [ctx (impl/error-ctx ctx ret)]
             (if-let [ctx (impl/abort-ctx conditions ctx)]
               (do
                 (failure ctx)
                 (async/<! (effects! :exoscale.checkmate/failure-effect! conditions ctx))
                 (async/>! ch ret))
               (do
                 (error ctx)
                 (async/<! (effects! :exoscale.checkmate/error-effect! conditions ctx))
                 (recur (impl/update-conditions conditions ctx)))))
           (let [ctx (impl/success-ctx ctx ret)]
             (success ctx)
             (async/<! (effects! :exoscale.checkmate/success-effect! conditions ctx))
             (async/>! ch ret)))))
     ch)))
