(ns exoscale.checkmate.auspex
  (:require [exoscale.checkmate.impl :as impl]
            [qbits.auspex :as a]))

(defn- effects!
  [k conditions ctx]
  (apply a/zip
         (keep #(when-let [f (get % k)]
                  (fn [] (f ctx)))
               conditions)))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (impl/assert-conditions-valid! conditions)
   (let [{:as opts :exoscale.checkmate.hook/keys [success error failure]}
         (merge impl/default-options opts)
         ctx (impl/setup-conditions conditions opts :auspex)]
     (effects! :exoscale.checkmate/setup-effect! conditions ctx)
     (a/loop [ctx ctx]
       (-> (f)
           (a/chain
            (fn [ret]
              (let [ctx (impl/success-ctx ctx ret)]
                (success ctx)
                (a/chain (effects! :exoscale.checkmate/success-effect! conditions ctx)
                         (fn [_] ret)))))
           (a/catch Exception
               (fn [ret]
                 (let [ctx (impl/error-ctx ctx ret)]
                   (if-let [ctx (impl/abort-ctx conditions ctx)]
                     (do
                       (failure ctx)
                       (a/chain (effects! :exoscale.checkmate/failure-effect! conditions ctx)
                                (fn [_] (throw ret))))
                     (do
                       (error ctx)
                       (a/chain (effects! :exoscale.checkmate/error-effect! conditions ctx)
                                (fn [_] (a/recur (impl/update-conditions conditions ctx))))))))))))))
