(ns exoscale.checkmate.sync
  (:require [exoscale.checkmate.impl :as impl]
            [exoscale.checkmate.protocols :as p]))

(defn ^:no-doc attempt!
  "because loop will not allow recur from catch"
  [f]
  (try
    [:exoscale.checkmate/success (f)]
    (catch Exception e
      [:exoscale.checkmate/error e])
    (catch AssertionError e
      [:exoscale.checkmate/error e])))

(defn ^:no-doc effects!
  [proto f conditions ctx]
  (run! (fn [cd]
          (when (satisfies? proto cd)
            (f cd ctx)))
        conditions))

(def ^:no-doc setup-effects! (partial effects! p/SetupEffect #'p/setup-effect!))
(def ^:no-doc error-effects! (partial effects! p/ErrorEffect #'p/error-effect!))
(def ^:no-doc failure-effects! (partial effects! p/FailureEffect #'p/failure-effect!))
(def ^:no-doc success-effects! (partial effects! p/SuccessEffect #'p/success-effect!))

(defn run
  ([f conditions] (run f conditions))
  ([f conditions opts]
   (let [{:as opts :exoscale.checkmate.hook/keys [success error failure]}
         (merge impl/default-options opts)
         ctx (impl/setup-conditions! conditions opts :sync)]
     (setup-effects! conditions ctx)
     (loop [ctx ctx]
       (let [[status ret] (attempt! f)
             ctx (assoc ctx :exoscale.checkmate/result ret)]
         (case status
           :exoscale.checkmate/success
           (do
             (success ret)
             (success-effects! conditions ctx)
             ret)
           :exoscale.checkmate/error
           ;; check continue on all conditions, abort on first false
           (if (impl/retry? conditions ctx)
             (do
               (error ret)
               (error-effects! conditions ctx)
               (recur (impl/update-conditions! conditions ctx)))
             (do
               (failure ret)
               (failure-effects! conditions ctx)
               (throw ret)))))))))
