(ns exoscale.checkmate.impl
  (:require [clojure.tools.logging :as log]
            [exoscale.checkmate.protocols :as p]))

(def default-options
  {:exoscale.checkmate.hook/failure #(log/error :exoscale.checkmate.hook/failure %)
   :exoscale.checkmate.hook/error #(log/warn :exoscale.checkmate.hook/error %)
   :exoscale.checkmate.hook/success identity})

(defn setup-conditions!
  [conditions ctx runner]
  (reduce (fn [ctx cd] (p/setup! cd ctx))
          (assoc ctx :exoscale.checkmate/runner runner)
          conditions))

(defn update-conditions!
  [conditions ctx]
  (reduce (fn [ctx cd] (p/update! cd ctx))
          ctx
          conditions))

(defn retry?
  [conditions ctx]
  (every? (fn [cd] (p/retry? cd ctx)) conditions))
