(ns exoscale.checkmate.core-async
  (:require [clojure.core.async :as async]
            [exoscale.checkmate.impl :as impl]
            [exoscale.checkmate.protocols :as p]))

(defn- ^:no-doc effects!
  [proto f conditions ctx]
  (async/go
    (doseq [cd conditions]
      (when (satisfies? proto cd)
        (async/<! (f cd ctx)))
      conditions)))

(def ^:no-doc setup-effects! (partial effects! p/SetupEffect #'p/setup-effect!))
(def ^:no-doc error-effects! (partial effects! p/ErrorEffect #'p/error-effect!))
(def ^:no-doc failure-effects! (partial effects! p/FailureEffect #'p/failure-effect!))
(def ^:no-doc success-effects! (partial effects! p/SuccessEffect #'p/success-effect!))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (let [{:as opts
          :exoscale.checkmate.hook/keys [success error failure]
          :exoscale.checkmate.core.async/keys [ch]}
         (merge impl/default-options opts)
         ch (or ch (async/promise-chan))
         ctx (impl/setup-conditions! conditions opts :core-async)]
     (setup-effects! conditions ctx)
     (async/go-loop [ctx ctx]
       (when-let [ret (async/<! (f))]
         (let [ctx (assoc ctx ::result ret)]
           (if (instance? Exception ret)
             (if (impl/retry? conditions ctx)
               (do
                 (error ret)
                 (async/<! (error-effects! conditions ctx))
                 (recur (impl/update-conditions! conditions ctx)))
               (do
                 (failure ret)
                 (async/<! (failure-effects! conditions ctx))
                 (async/>! ch ret)))
             (do
               (success ret)
               (async/<! (success-effects! conditions ctx))
               (async/>! ch ret))))))
     ch)))
