(ns exoscale.checkmate.auspex
  (:require [exoscale.checkmate.impl :as impl]
            [exoscale.checkmate.protocols :as p]
            [qbits.auspex :as a]))

(defn ^:no-doc effects!
  [proto f conditions ctx]
  (apply a/zip
         (keep #(when (satisfies? proto %)
                  (fn [] (f % ctx)))
               conditions)))

(def ^:no-doc setup-effects! (partial effects! p/SetupEffect #'p/setup-effect!))
(def ^:no-doc error-effects! (partial effects! p/ErrorEffect #'p/error-effect!))
(def ^:no-doc failure-effects! (partial effects! p/FailureEffect #'p/failure-effect!))
(def ^:no-doc success-effects! (partial effects! p/SuccessEffect #'p/success-effect!))

(defn run
  ([f conditions] (run f conditions {}))
  ([f conditions opts]
   (let [{:as opts :exoscale.checkmate.hook/keys [success error failure]}
         (merge impl/default-options opts)
         ctx (impl/setup-conditions! conditions opts :auspex)]
     (setup-effects! conditions ctx)
     (a/loop [ctx ctx]
       (-> (f)
           (a/chain
            (fn [ret]
              (let [ctx (assoc ctx ::result ret)]
                (success ret)
                (a/chain (success-effects! conditions ctx)
                         (fn [_] ret)))))
           (a/catch Exception
                    (fn [ret]
                      (if (impl/retry? conditions ctx)
                        (do
                          (error ret)
                          (a/chain (error-effects! conditions ctx)
                                   (fn [_] (a/recur (impl/update-conditions! conditions ctx)))))
                        (do
                          (failure ret)
                          (a/chain (failure-effects! conditions ctx)
                                   (fn [_] (throw ret))))))))))))
