(ns exoscale.checkmate.impl
  (:require [clojure.tools.logging :as log]
            [exoscale.checkmate.protocols :as p]))

(def default-options
  {:exoscale.checkmate.hook/failure #(log/error :exoscale.checkmate.hook/failure %)
   :exoscale.checkmate.hook/error #(log/warn :exoscale.checkmate.hook/error %)
   :exoscale.checkmate.hook/success identity})

(defn setup-conditions!
  [conditions state runner]
  (reduce (fn [state cd] (p/setup! cd state))
          (assoc state :exoscale.checkmate/runner runner)
          conditions))

(defn update-conditions!
  [conditions state]
  (reduce (fn [state cd] (p/update! cd state))
          state
          conditions))

(defn retry?
  [conditions state]
  (every? (fn [cd] (p/retry? cd state)) conditions))
