(ns exoscale.checkmate.impl
  (:require [clojure.tools.logging :as log]
            [exoscale.checkmate.protocols :as p]))

(def default-options
  {:exoscale.checkmate.hooks/failure #(log/error :exoscale.checkmate.hooks/failure %)
   :exoscale.checkmate.hooks/error #(log/warn :exoscale.checkmate.hooks/error %)
   :exoscale.checkmate.hooks/success identity})

(defn setup-conditions!
  [conditions state runner]
  (reduce (fn [state cd] (p/setup! cd state))
          (assoc state :exoscale.checkmate/runner runner)
          conditions))

(defn update-conditions!
  [conditions state]
  (reduce (fn [state cd] (p/update! cd state))
          state
          conditions))

(defn retry?
  [conditions state]
  (every? (fn [cd] (p/retry? cd state)) conditions))
