(defproject exoscale/blueprint "0.2.5"

  :description "Data definitions for APIs"
  :plugins [[lein-modules "0.3.11"]
            [lein-codox   "0.10.7"]]

  :profiles
  {:provided {:dependencies [[org.clojure/clojure _]]}
   :dev      {:dependencies [[spootnik/unilog _
                              :exclusions
                              [com.fasterxml.jackson.core/jackson-databind]]]}
   :test     {:dependencies   [[less-awful-ssl]
                               [org.apache.commons/commons-io _]
                               [ring/ring-mock _
                                :exclusions
                                [com.fasterxml.jackson.core/jackson-core]]
                               [io.swagger.parser.v3/swagger-parser _
                                :exclusions [org.slf4j/slf4j-api
                                             org.slf4j/slf4j-api
                                             com.github.fge/jackson-coreutils
                                             com.google.code.findbugs/jsr305
                                             commons-io]]]
              :resource-paths ["test/resources"]
              :plugins        [[lein-cloverage "1.1.2"]]}}

  :cloverage {:ns-regex      [#"blueprint.(.*)$"]}

  :scm {:name "git" :url "https://github.com/exoscale/blueprint"}

  :modules {:versions {org.clojure/clojure           "1.10.1"
                       org.clojure/tools.logging     "1.0.0"
                       exoscale/interceptor          "0.1.8"
                       exoscale/ex                   "0.3.6"
                       exoscale/reporter             "0.1.48"
                       spootnik/unilog               "0.7.24"
                       spootnik/aleph-params         "0.1.3"
                       metosin/spec-tools            "0.10.0"
                       metosin/jsonista              "0.2.5"
                       metosin/muuntaja              "0.6.5"
                       metosin/reitit-core           "0.3.10"
                       camel-snake-kebab             "0.4.0"
                       expound                       "0.8.4"
                       aleph                         "0.4.7-alpha5"
                       manifold                      "0.1.9-alpha3"
                       cheshire                      "5.10.0"
                       ring/ring-core                "1.8.0"
                       ring/ring-codec               "1.1.2"
                       ring/ring-mock                "0.4.0"
                       commons-validator             "1.6"
                       commons-codec                 "1.11"
                       org.apache.commons/commons-io "1.3.2"
                       less-awful-ssl                "1.0.5"
                       com.stuartsierra/component    "1.0.0"

                       exoscale/blueprint-core     :version
                       exoscale/blueprint-openapi  :version
                       exoscale/blueprint-handler  :version
                       exoscale/blueprint-router   :version
                       exoscale/blueprint-client   :version
                       exoscale/blueprint-server   :version
                       exoscale/blueprint-reporter :version

                       ;; for deps conflicts
                       io.swagger.parser.v3/swagger-parser                    "2.0.17"
                       com.fasterxml.jackson.core/jackson-databind            "2.10.2"
                       com.fasterxml.jackson.core/jackson-core                "2.10.2"
                       com.fasterxml.jackson.datatype/jackson-datatype-jsr310 "2.10.2"}
            :subprocess nil
            :inherited  {:license                  {:name "MIT/ISC"}
                         :url                      "https://github.com/exoscale/blueprint"
                         :scm                      {:name "git" :url "https://github.com/exoscale/blueprint"}
                         :deploy-repositories      [["releases" :clojars] ["snapshots" :clojars]]
                         :pedantic?                :warn
                         :monkeypatch-clojure-test false}}

  :dependencies [[exoscale/blueprint-core     :version]
                 [exoscale/blueprint-openapi  :version]
                 [exoscale/blueprint-router   :version]
                 [exoscale/blueprint-handler  :version]
                 [exoscale/blueprint-client   :version]
                 [exoscale/blueprint-server   :version]
                 [exoscale/blueprint-reporter :version]]

  ;; apparently option ':src-ns-path' isn't working for cloverage so we spill it out
  :aliases {"coverage" ["with-profile" "+test" "cloverage"
                        "-p" "modules/client/src"
                        "-p" "modules/core/src"
                        "-p" "modules/handler/src/"
                        "-p" "modules/openapi/src"
                        "-p" "modules/router/src"
                        "-p" "modules/server/src"]}

  :release-tasks [["modules" "install"]
                  ["test"]
                  ["vcs" "assert-committed"]
                  ["modules" "change" "version" "leiningen.release/bump-version" "release"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["modules" "install"]
                  ["modules" "deploy"]
                  ["deploy"]
                  ["modules" "change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]

  :codex {:source-uri   "https://github.com/exoscale/blueprint/blob/{version}/{filepath}#L{line}"
          :doc-files    ["README.md"]
          :metadata     {:doc/format :markdown}
          :source-paths ["modules/core/src"
                         "modules/openapi/src"
                         "modules/router/src"
                         "modules/handler/src"
                         "modules/client/src"
                         "modules/server/src"
                         "modules/reporter/src"]})
