(defproject exoscale/blueprint "0.2.24"

  :license             {:name "MIT/ISC"}
  :url                 "https://github.com/exoscale/blueprint"
  :scm                 {:name "git" :url "https://github.com/exoscale/blueprint"}
  :deploy-repositories [["releases" :clojars] ["snapshots" :clojars]]
  :pedantic?           :warn
  :description         "Data definitions for APIs"

  :plugins [[lein-sub "0.3.0"]
            [exoscale/lein-replace "0.1.1"]
            [lein-difftest "2.0.0"]
            [lein-pprint "1.3.2"]]

  :profiles
  {:provided {:dependencies [[org.clojure/clojure]]}
   :dev      {:resource-paths ["test/resources"]
              :dependencies   [[tortue/spy "2.0.0"]
                               [spootnik/unilog
                                :exclusions
                                [com.fasterxml.jackson.core/jackson-databind]]
                               [less-awful-ssl]
                               [org.apache.commons/commons-io]
                               [ring/ring-mock
                                :exclusions
                                [com.fasterxml.jackson.core/jackson-core]]
                               [io.swagger.parser.v3/swagger-parser
                                :exclusions [org.slf4j/slf4j-api
                                             org.slf4j/slf4j-api
                                             com.fasterxml.jackson.core/jackson-annotations
                                             com.github.fge/jackson-coreutils
                                             com.google.code.findbugs/jsr305
                                             commons-io]]]}
   :test     {:jvm-opts ["-Dclojure.tools.logging.factory=clojure.tools.logging.impl/slf4j-factory"
                         "-Dlogback.configurationFile=bptest.logback.xml"]
              :plugins [[lein-cloverage "1.1.2"]]
              :dependencies [[lambdaisland/kaocha "1.0.632"]
                             [ch.qos.logback/logback-classic "1.1.3"]]}}

  :cloverage {:ns-regex [#"blueprint.(.*)$"]}

  :sub ["modules/core"
        "modules/openapi"
        "modules/router"
        "modules/handler"
        "modules/client"
        "modules/server"
        "modules/reporter"]

  :managed-dependencies [[org.clojure/clojure           "1.10.1"]
                         [org.clojure/tools.logging     "1.0.0"]
                         [exoscale/interceptor          "0.1.8"]
                         [exoscale/ex                   "0.3.13"]
                         [exoscale/cloak                "0.1.2"]
                         [exoscale/coax                 "1.0.0-alpha9"]
                         [exoscale/reporter             "0.1.50"]
                         [spootnik/unilog               "0.7.24"]
                         [spootnik/aleph-params         "0.1.3"]
                         [metosin/spec-tools            "0.10.0"]
                         [metosin/jsonista              "0.2.5"]
                         [metosin/muuntaja              "0.6.7"]
                         [metosin/reitit-core           "0.3.10"]
                         [expound                       "0.8.4"]
                         [aleph                         "0.4.7-alpha5"]
                         [manifold                      "0.1.9-alpha3"]
                         [cheshire                      "5.10.0"]
                         [ring/ring-core                "1.8.0"]
                         [ring/ring-codec               "1.1.2"]
                         [ring/ring-mock                "0.4.0"]
                         [commons-validator             "1.6"]
                         [commons-codec                 "1.11"]
                         [org.apache.commons/commons-io "1.3.2"]
                         [less-awful-ssl                "1.0.5"]
                         [com.stuartsierra/component    "1.0.0"]

                         [exoscale/blueprint-core     :version]
                         [exoscale/blueprint-openapi  :version]
                         [exoscale/blueprint-handler  :version]
                         [exoscale/blueprint-router   :version]
                         [exoscale/blueprint-client   :version]
                         [exoscale/blueprint-server   :version]
                         [exoscale/blueprint-reporter :version]

                         ;; for deps conflicts
                         [io.swagger.parser.v3/swagger-parser                    "2.0.17"]
                         [com.fasterxml.jackson.core/jackson-databind            "2.10.2"]
                         [com.fasterxml.jackson.core/jackson-core                "2.10.2"]
                         [com.fasterxml.jackson.datatype/jackson-datatype-jsr310 "2.10.2"]]

  :dependencies [[exoscale/blueprint-core     :version]
                 [exoscale/blueprint-openapi  :version]
                 [exoscale/blueprint-router   :version]
                 [exoscale/blueprint-handler  :version]
                 [exoscale/blueprint-client   :version]
                 [exoscale/blueprint-server   :version]
                 [exoscale/blueprint-reporter :version]]

  ;; apparently option ':src-ns-path' isn't working for cloverage so we spill it out
  :aliases {"coverage" ["with-profile" "+test" "cloverage"
                        "-p" "modules/client/src"
                        "-p" "modules/core/src"
                        "-p" "modules/handler/src/"
                        "-p" "modules/openapi/src"
                        "-p" "modules/router/src"
                        "-p" "modules/server/src"]}

  :release-tasks [["sub" "install"]
                  ["test"]
                  ["vcs" "assert-committed"]
                  ["sub" "change" "version" "leiningen.release/bump-version" "release"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["sub" "install"]
                  ["sub" "deploy"]
                  ["deploy"]
                  ["sub" "change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]])
