(ns blueprint.router
  (:require [reitit.core :as r]
            [exoscale.ex :as ex]))

(defn gen-path
  [elems]
  (reduce
   str
   (for [[_ v :as full] elems]
     (if (string? v) v (format "{%s}" (name (:name v)))))))

(defn prepare-route
  [routers opname {:keys [path]}]
  (let [{:keys [method elems]} path]
    (update routers method conj [(gen-path elems) opname])))

(defn build-router
  [routers]
  (fn [{:keys [request-method uri] :as request}]
    (let [{:keys [data path-params]} (r/match-by-path (get routers request-method) uri)]
      (cond-> request
        (some? data)
        (assoc :handler (:name data))

        (nil? data)
        (assoc :handler :blueprint.core/not-found)

        (some? path-params)
        (assoc :path-params path-params)))))

(defn generate-router
  [{:keys [commands router] :as api-def}]
  (assoc api-def
         :router
         (build-router
          (->> (reduce-kv prepare-route {} commands)
               (reduce-kv #(assoc %1 %2 (r/router %3 {:syntax #{:bracket}})) {})))

         :assets
         (:assets router)))

(defn build-url
  [elems params]
  (for [e elems]
    (if (string? e) e (str (get params (first e))))))

(defn uri-for
  [{:keys [commands]} nick params]
  (if-let [{[method & elems] :path} (get commands nick)]
    {:request-method method
     :url            (reduce str "" (build-url elems params))}
    (throw (ex-info "unknown command" {:type ::ex/not-found}))))
