(ns blueprint.handler.format
  "Content-type negotiation and parsing, thanks to muuntaja"
  (:require [exoscale.interceptor :as interceptor]
            [exoscale.ex          :as ex]
            [muuntaja.core        :as m]))

(def known-error-types
  "An exhaustive list of error types thrown by the muntaaja library"
  #{:muuntaja/decode
    :muuntaja/request-charset-negotiation
    :muuntaja/response-charset-negotiation
    :muuntaja/response-format-negotiation})

;; Install derivations for muuntaja, by declaring
;; that the above error types belong to the :exoscale.ex/incorrect
;; category, such errors will result in 400 being thrown
(doseq [error-type known-error-types]
  (ex/derive error-type ::ex/incorrect))

(defn- format-enter
  [{:keys [request] :as context}]
  (let [request (m/negotiate-and-format-request m/instance request)]
    (assoc context ::request request :request request)))

(defn- format-leave
  [{::keys [request] :keys [response] :as context}]
  (m/format-response m/instance request response))

(def enter
  {:name  :blueprint.handler/format-enter
   :enter format-enter})

(def leave
  {:name  :blueprint.handler/format-leave
   :leave (interceptor/out format-leave [:response])})
