(ns blueprint.core
  (:require [blueprint.registry :as reg]
            blueprint.spec
            [blueprint.spec-gen :as sg]))

(def parse
  (memoize
   (fn parse' [source]
     (-> source
         (reg/build)
         (sg/generate-specs!)
         (assoc :parsed? true)))))

(def resource-spec sg/resource-spec)

(defn command-output-spec
  [ns k]
  (sg/command-spec ns k "output"))

(defn command-input-spec
  [ns k]
  (sg/command-spec ns k "input"))

(defn command-params-spec
  [ns k]
  (sg/command-spec ns k "params"))

(defn command-path-spec
  [ns k]
  (sg/command-spec ns k "path"))

(defn command-handler-spec
  [ns k]
  (sg/command-spec ns k "handler"))
