(ns blueprint.client.url
  (:require
   [blueprint.core :as core]
   [exoscale.specs :as spec]))

(defmulti ^{:private true} -resolve-endpoint (fn [[t _] _] t))
(defmethod -resolve-endpoint :string [[_ path] _] path)
(defmethod -resolve-endpoint :arg [[_ {attr :name}] arg] (get arg attr))

(defn cmd->request
  [command command-def input]
  (let [[ns _] command-def
        path-k (core/command-path-spec ns command)
        cmd (spec/meta path-k)
        {:keys [path params]} cmd
        url (reduce str (map #(-resolve-endpoint % input) (:elems path)))
        parms (select-keys input (map keyword (keys (:params cmd))))]
    (cond-> {:url url
             :request-method (or (:method path) :get)}
      (:input cmd) (assoc :body input)
      params (assoc :query-params parms))))
