(ns blueprint.client.url
  (:require
   [blueprint.core :as core]
   [blueprint.spec :as spec]))

(defmulti ^{:private true} -resolve-endpoint (fn [[t _] arg] t))
(defmethod -resolve-endpoint :string [[_ path] arg] path)
(defmethod -resolve-endpoint :arg [[_ {attr :name :as elem}] arg] (get arg attr))

(defn cmd->request
  [command input]
  (let [[ns name] command
        path-k (core/command-path-spec ns name)
        cmd (spec/meta path-k)
        {:keys [path params]} cmd
        url (reduce str (map #(-resolve-endpoint % input) (:elems path)))
        parms (select-keys input (map keyword (keys (:params cmd))))]
    (cond-> {:url url
             :request-method (or (:method path) :get)}
      (:input cmd) (assoc :body input)
      params (assoc :query-params parms))))
