(defproject exoscale/blueprint-client "0.2.26"
  :description "Exoscale library to generate blueprint clients"
  :plugins [[lein-parent "0.3.8"]]

  :parent-project {:path "../../project.clj"
                   :inherit [:managed-dependencies
                             :license
                             :url
                             :scm
                             :deploy-repositories
                             :pedantic?
                             :description]}

  :dependencies [[aleph :exclusions [cheshire]]
                 [metosin/muuntaja]
                 [exoscale/ex]
                 [exoscale/coax]
                 [exoscale/interceptor]
                 [exoscale/blueprint-core]]
  :jvm-opts ["-Dio.netty.tryReflectionSetAccessible=false"]
  :profiles {:dev {:jvm-opts ["-Dlogback.configurationFile=stdout.logback.xml"]
                   :resource-paths ["test/resources"]}})
