(ns blueprint.client.spec-gen
  (:require [blueprint.registry :as reg]))

(defn apidef->commands-map
  "Generates a map of command definitions from a parsed api definition"
  [parsed-api]
  (let [{::reg/keys [commands ns]} parsed-api]
    (into {}
          (map (fn [[command _]]
                 [command [(name ns)
                           (name command)]]))
          commands)))
