(ns ^{:deprecated true} blueprint.client.backward-compat
  (:require [blueprint.client.interceptors :as i]
            [blueprint.client :as client]))

(def default-interceptor-chain
  [::execute-request
   ::lens-response
   ::decode-body
   ::parse-body
   ::get-response])

(defn- make-decoder
  "Utility function to create an interceptor out of a response (multi)spec."
  [response-multispec]
  ((:builder i/decode) i/decode {:response-spec response-multispec}))

(defn- interceptor-map
  "Builds the interceptor map"
  [response-multispec client]
  (->> {::execute-request i/execute-request
        ::lens-response   i/lens-response
        ::get-response    i/get-response
        ::decode-body     (make-decoder response-multispec)
        ::parse-body      i/parse}

    ;; overwrite name of referenced interceptors
       (reduce-kv (fn [m k v] (assoc m k (assoc v :name k)))
                  {})))

;; proxy calls
(def ^{:deprecated true} make-client client/make-client)

(defn ^{:deprecated true} invoke [blueprint-client command {:keys [user-interceptors interceptor-chain] :as opts}]
  (if-not (some? interceptor-chain)
    (client/invoke blueprint-client command opts)

    ;; we need to rework the old ix chain to the new format
    (let [default-names        (map :name client/default-interceptors)

          response-spec        (get-in blueprint-client [:command-defs command :response-spec])
          command-interceptors (merge (interceptor-map response-spec blueprint-client) user-interceptors)
          custom-chain         ((apply juxt interceptor-chain) command-interceptors)

          ;; put every ix :last, so order is effectively preserved
          custom-chain         (map (fn [ix] (assoc ix :blueprint.interceptor/position :last)) custom-chain)
          ix-config            {:blueprint.interceptor/additional custom-chain
                                :blueprint.interceptor/disabled   default-names}]
      (client/invoke blueprint-client command (assoc opts :interceptors ix-config)))))