(ns blueprint.client.validation
  (:require [clojure.spec.alpha :as s]
            [spec-tools.core :as st]
            [exoscale.ex :as ex]))

(defn -validate [spec arg msg]
  (if (not (s/valid? spec arg))
    (throw
      (ex/ex-info
        msg
        [::ex/invalid-spec [::ex/incorrect]]
        (st/explain-data spec arg)))))

(defn validate-command [spec arg]
  (-validate spec arg "Invalid command"))

(defn validate-input [spec arg]
  (-validate spec arg "Invalid input"))

(defn validate-params [spec arg]
  (-validate spec arg "Invalid input params"))

(defn validate-path [spec arg]
  (-validate spec arg "Invalid input path params"))

