package keyed_set;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.ISeq;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;

public class PersistentKeyedSet extends AFn implements IObj, IPersistentSet {
  final IPersistentMap _meta;
  public IPersistentMap meta() { return _meta; }
  public PersistentKeyedSet withMeta(IPersistentMap meta) { return new PersistentKeyedSet(meta, keyFn, map); }

  final IFn keyFn;
  public static PersistentKeyedSet withKeyFn(IFn keyFn) { return new PersistentKeyedSet(null, keyFn, PersistentHashMap.EMPTY); }

  final IPersistentMap map;
  public PersistentKeyedSet empty() { return new PersistentKeyedSet(meta(), keyFn, PersistentHashMap.EMPTY); }

  PersistentKeyedSet(IPersistentMap meta, IFn keyFn, IPersistentMap map) { this._meta = meta; this.keyFn = keyFn; this.map = map; }

  public PersistentKeyedSet cons(Object val) {
    Object key = keyFn.invoke(val);
    return new PersistentKeyedSet(meta(), keyFn, map.assoc(key, val));
  }

  public boolean equiv(Object obj) {
    if (!(obj instanceof PersistentKeyedSet)) return false;
    return ((PersistentKeyedSet) obj).equiv(map);
  }

  public int count() { return map.count(); }
  public ISeq seq() { return RT.vals(map); }

  public Object get(Object key) { return map.valAt(key); }
  public boolean contains(Object key) { return map.containsKey(key); }
  public PersistentKeyedSet disjoin(Object key) { return new PersistentKeyedSet(meta(), keyFn, map.without(key)); }
}
