(ns iomed-clj.mel
  (:require [clojure.data.json :as json]
            [clj-http.client :as client]))

(defn annotate
  "Given a text, the API URL and the API key, annotate the text and return it."
  ([text url apikey]
   (annotate text url apikey false))

  ([text url apikey as-json]
   (let [headers {:apikey apikey
                  :Access-Method "iomed-cli"
                  :X-Consumer-ID "iomed-cli"}
         body (json/write-str {:text text})
         full-url (str url "/annotation")
         response (client/post full-url
                               {:body body
                                :headers headers
                                :coerce :always
                                :throw-exceptions false})]
     (if as-json
       (:body response)
       (json/read-str (:body response))))))
