(ns erdos.neue)


(declare compile)

(def ^:dynamic *let-vars* #{})


(defn- compile-const
  [pat pats]
  `(when (= ~(:rs pat) ~(:p pat))
     ~(compile pats)))


(defn- compile-sym
  [pat pats]
  (cond (= '_ (:p pat))
        (recur (first pats) (next pats))
    ;;(contains? (-> pat :p meta) :tag)
    ;;   `(when (instance? (-> pat :p meta :tag) ~(:rs pat)) :OPKOK  )
        (not= \? (-> pat :p name first))
        `(when (= ~(:rs pat) '~(:p pat))
           ~(compile pats))
        (contains? *let-vars* (:p pat))
        `(when (= ~(:rs pat) ~(:p pat))
           ~(compile pats))
        :otherwise
        `(let [~(:p pat) ~(:rs pat)]
           ~(binding [*let-vars* (conj *let-vars* (:p pat))]
              (compile pats)))))


(defn- compile-vec
  [pat pats]
  (let [s (gensym "V")
        rs (:rs pat)
        p  (:p pat)
        ff (fn [i p]
             (if (not= p '_) {:p p, :rs s, :rslet `(nth ~rs ~i)}))
        vc (count p)]
    `(when (vector? ~(:rs pat))
       ~(if (= '& (last (butlast p))) ;; no (count) when vc=0
          `(when (>= ~(- vc 2) (count ~rs))
             ~(compile
               (concat
                (map-indexed ff (-> p butlast butlast))
                [{:p (last p) :rslet `(nthrest ~rs ~(- vc 2)) :rs s}]
                pats)))
          `(when (= ~vc (count ~rs))
             ~(compile (concat (map-indexed ff p) pats)))))))


(defn- compile-lis
  [pat pats]
  (let [s (gensym "L")
        rs (:rs pat)
        p  (:p pat)
        ff (fn [i p]
             (if (not= p '_) {:p p, :rs s, :rslet `(get ~rs ~i)}))
        vc (count p)]
    `(when (seq? ~(:rs pat))
       ~(if (= '& (last (butlast p))) ;; no (count) when vc=0
          `(when (>= ~(- vc 2) (count ~rs))
             ~(compile
               (concat
                (map-indexed ff (-> p butlast butlast))
                [{:p (last p) :rslet `(nthrest ~rs ~(- vc 2)) :rs s}]
                pats)))
          `(when (= ~vc (count ~rs))
             ~(compile (concat (map-indexed ff p) pats)))))))
;; Todo: use first, rest instead of nth.

(defn- compile-seq
  [pat pats] :NOI)


(defn- compile-map
  [pat pats]
  (let [l2 (gensym "m")
        p  (:p pat)
        rs (:rs pat)
        ck (fn [k] `(contains? ~rs ~k))
        cf (fn [[k v]] {:p v :let `(get ~rs ~k) :rs l2})]
    `(if (map? ~rs)
       (if (and ~@(map ck (keys p)))
         ~(compile (concat (map cf p) pats))))))


(defn- compile-let
  [pat pats]
  `(let [~(:rs pat) ~(:rslet pat)]
     ~(compile (cons (dissoc pat :rslet) pats))))


(defn compile
  "pat: sequence of patterns to match."
  [patterns]
  (let [[pat & pats] patterns
        p            (:p pat)]
    (cond
     (empty? pats)   pat
     (:rslet  pat)   (compile-let pat pats)
     (or (number? p) (string? p)
         (char? p)   (keyword? p))
     (compile-const pat pats)
     (vector? p)   (compile-vec   pat pats)
     (symbol? p)   (compile-sym   pat pats)
     (map? p)      (compile-map   pat pats)

     (and (seq? p) (= (first p) 'clojure.core/unquote)) ;; wrong.
     (compile-const (assoc pat :p (-> p second eval)) pats)

     (and (seq? p) (= (first p) 'clojure.core/deref)) ;; seems ok.
     `(if (= ~(:rsn pat) ~(second p)) ~(compile pats))

     (list? p)     (compile-lis   pat pats)
     :otherwise    (->> pat :p (str "Unexpected pattern: ")
                       RuntimeException. throw))))


(defn- compile* [pat sym return]
  (assert (symbol? sym))
  (compile [{:p pat :rs sym} return]))

(defn- merge-sexp
  "Join expressions by merging similiar outer if-else branches."
  [a b]
  (or
   (if (empty? a) b)
   (if (empty? b) a)

   (when (and (= 'clojure.core/when (first a) (first b))
              (= (second a) (second b)))
     `(when ~(second a) ~(merge-sexp (nth a 2) (nth b 2))))

   (when (= 'clojure.core/or (first a) (first b))
     `(or ~@(concat (rest a) (rest b))))

   (when (= 'clojure.core/or (first a))
     `(or ~@(rest a) ~b))

   (when (= 'clojure.core/or (first b))
     `(or ~a ~@(rest b)))

   `(or ~a ~b)))


(defn- match0-pattern
  "Returns the generated code for the clauses"
  [value & clauses]
  (assert (-> clauses count even?))
  (let [vsym (gensym "MC")
        cls (map (fn [[p c]] (compile* p vsym [c]))
                 (partition 2 clauses))]
    `(first (let [~vsym ~value]
              ~(reduce merge-sexp cls)))))


(defmacro match0
  [value & clauses]
  (apply match0-pattern value clauses))

(defn- simplify-sexp-item
  "Simplify a sexp, eg.: merge (if) forms, etc."
  [sexp]
  (match0 sexp
          (or & ?ops)
          `(or ~@(mapcat
                  #(match0 %,
                           (clojure.core/or & ?xs) ?xs,
                           (or & ?xs) ?xs, ?x [?x]) ?ops))

          (if (= ?a ?x1) ?a1 (if (= ?a ?x2) ?a2 ?a3))
          `(case ~?a, ~?x1 ~?a1, ~?x2 ~?a2, ~?a3)

          (if (= ?a ?x1) ?a1 (clojure.core/case ?a & ?as))
          `(case ~?a, ~?x1 ~?a1, ~@?as)

          (clojure.core/let [?k ?v]
            (clojure.core/let [& ?as] ?body))
          `(let [~?k ~?v ~@?as] ~?body)
          ?else ?else))


(defn simplify-sexp
  "Recursively simplify sexp."
  [sexp] (clojure.walk/postwalk simplify-sexp-item sexp))


(defmacro match0-debug
  [value & clauses]
  `'~(apply match0-pattern value clauses))

(defn match-pattern
  [val & clauses]
  (simplify-sexp (apply match0-pattern val clauses)))

(defmacro match
  [val & clauses] (apply match-pattern val clauses))


(comment
(clojure.pprint/pprint  (match-pattern 'jjj
                  '[:t ?a] :t
                  '[?b :t] :t
                  '[?a ?b]  :f
                  '?a      :unknown))

  (do (System/gc) (time
     (dotimes [t 1000]
       (match-pattern 'a
                       '[[[[[?a] ?b] & ?c] a b c] 1 2 3] :one
                       '[[] [] {} [[[[[]]]]]]            :two
                       '?a :three))))


  )

:OK
