(ns environ.leiningen.hooks
  (:use [robert.hook :only (add-hook)])
  (:require [clojure.java.io :as io]))

(defn env-file [project]
  (io/file (:root project) ".env.clj"))

(defn- write-env-to-file [task project & args]
  (spit (pr-str (:env project))
        (env-file project))
  (apply task project args))

(defn activate []
  (add-hook #'leiningen.deps/deps write-env-to-file))