(ns tutorial.scrape1
  (:require [net.cgrand.enlive-html :as html]))

(def *base-url* "http://clojars.org/repo/all-jars.clj")

(defn fetch-url [url]
  (html/html-resource (java.net.URL. url)))

(defn hn-headlines []
  (map html/text (html/select (fetch-url *base-url*) [:td.title :a])))

(defn hn-points []
  (map html/text (html/select (fetch-url *base-url*) [:td.subtext html/first-child])))

(defn print-headlines-and-points []
  (doseq [line (map #(str %1 " (" %2 ")") (hn-headlines) (hn-points))]
    (println line)))

(defn jar-list []
	(map html/text (html/select (fetch-url *base-url*) [:body])))

(defn get-clojars-jars []
	(doseq [jar (map #(str %) (jar-list))]
		(println jar)))