/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AsyncSubscriptionImpl;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class MsgDeliveryWorker
extends Thread {
    private final Lock mu = new ReentrantLock();
    private final List<Message> msgs = new LinkedList<Message>();
    private final Condition cond = this.mu.newCondition();
    private boolean inWait = false;
    private boolean shutdown = false;

    MsgDeliveryWorker() {
        this.setName("jnats-msg-delivery-worker-thread");
    }

    void postMsg(Message msg) {
        this.msgs.add(msg);
        if (this.inWait) {
            this.cond.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message msg = null;
        AsyncSubscriptionImpl sub = null;
        ConnectionImpl nc = null;
        MessageHandler mcb = null;
        long max = 0L;
        long delivered = 0L;
        this.mu.lock();
        while (true) {
            if (this.msgs.isEmpty() && !this.shutdown) {
                this.inWait = true;
                try {
                    this.cond.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.inWait = false;
                continue;
            }
            if (this.msgs.isEmpty() && this.shutdown) break;
            msg = this.msgs.remove(0);
            sub = (AsyncSubscriptionImpl)msg.getSubscription();
            if (sub.closed) continue;
            nc = sub.conn;
            mcb = sub.msgHandler;
            max = sub.max;
            --sub.pMsgs;
            sub.pBytes = sub.pBytes - (msg.getData() == null ? 0 : msg.getData().length);
            delivered = ++sub.delivered;
            this.mu.unlock();
            if (max == 0L || delivered <= max) {
                try {
                    mcb.onMessage(msg);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (max > 0L && delivered >= max) {
                nc.mu.lock();
                try {
                    nc.removeSub(sub);
                }
                finally {
                    nc.mu.unlock();
                }
            }
            this.mu.lock();
        }
        this.mu.unlock();
    }

    void shutdown() {
        this.mu.lock();
        if (this.shutdown) {
            this.mu.unlock();
            return;
        }
        this.shutdown = true;
        if (this.inWait) {
            this.cond.signal();
        }
        this.mu.unlock();
        if (Thread.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void lock() {
        this.mu.lock();
    }

    void unlock() {
        this.mu.unlock();
    }
}

