/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AsyncSubscriptionImpl;
import io.nats.client.MsgDeliveryWorker;
import java.util.ArrayList;
import java.util.List;

class MsgDeliveryPool {
    private List<MsgDeliveryWorker> workers = null;
    private int idx;
    private boolean shutdown;

    MsgDeliveryPool(int size) {
        this.workers = new ArrayList<MsgDeliveryWorker>(size);
        for (int i = 0; i < size; ++i) {
            MsgDeliveryWorker w = new MsgDeliveryWorker();
            w.start();
            this.workers.add(w);
        }
    }

    synchronized int getSize() {
        return this.workers.size();
    }

    synchronized void assignDeliveryWorker(AsyncSubscriptionImpl sub) {
        int idx = this.idx++;
        if (this.idx >= this.workers.size()) {
            this.idx = 0;
            idx = 0;
        }
        MsgDeliveryWorker worker = this.workers.get(idx);
        sub.setDeliveryWorker(worker);
    }

    synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (int i = 0; i < this.workers.size(); ++i) {
            MsgDeliveryWorker w = this.workers.get(i);
            w.shutdown();
        }
        this.workers.clear();
    }
}

