/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AsyncSubscription;
import io.nats.client.ConnectionImpl;
import io.nats.client.MessageHandler;
import io.nats.client.MsgDeliveryWorker;
import io.nats.client.SubscriptionImpl;

class AsyncSubscriptionImpl
extends SubscriptionImpl
implements AsyncSubscription {
    MessageHandler msgHandler;
    MsgDeliveryWorker dlvWorker;

    AsyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue, MessageHandler cb) {
        this(nc, subj, queue, cb, false);
    }

    AsyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue, MessageHandler cb, boolean useMsgDlvPool) {
        super(nc, subj, queue, 65536, 0x4000000, useMsgDlvPool);
        this.msgHandler = cb;
    }

    @Override
    @Deprecated
    public void start() {
    }

    @Override
    public void setMessageHandler(MessageHandler cb) {
        this.dlvWorkerLock();
        this.msgHandler = cb;
        this.dlvWorkerUnlock();
    }

    @Override
    public MessageHandler getMessageHandler() {
        this.dlvWorkerLock();
        MessageHandler mh = this.msgHandler;
        this.dlvWorkerUnlock();
        return mh;
    }

    @Override
    public long getDelivered() {
        this.dlvWorkerLock();
        try {
            long l = super.getDelivered();
            return l;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public int getPendingMsgs() {
        this.dlvWorkerLock();
        try {
            int n = super.getPendingMsgs();
            return n;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public int getPendingBytes() {
        this.dlvWorkerLock();
        try {
            int n = super.getPendingBytes();
            return n;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public int getPendingMsgsMax() {
        this.dlvWorkerLock();
        try {
            int n = super.getPendingMsgsMax();
            return n;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public long getPendingBytesMax() {
        this.dlvWorkerLock();
        try {
            long l = super.getPendingBytesMax();
            return l;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public void setPendingLimits(int msgs, int bytes) {
        this.dlvWorkerLock();
        try {
            super.setPendingLimits(msgs, bytes);
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public int getPendingMsgsLimit() {
        this.dlvWorkerLock();
        try {
            int n = super.getPendingMsgsLimit();
            return n;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public void clearMaxPending() {
        this.dlvWorkerLock();
        try {
            super.clearMaxPending();
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    public int getDropped() {
        this.dlvWorkerLock();
        try {
            int n = super.getDropped();
            return n;
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    void setMax(long max) {
        this.dlvWorkerLock();
        try {
            super.setMax(max);
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    @Override
    void close(boolean connClosed) {
        this.dlvWorkerLock();
        try {
            super.close(connClosed);
        }
        finally {
            this.dlvWorkerUnlock();
        }
    }

    private void dlvWorkerLock() {
        if (this.dlvWorker != null) {
            this.dlvWorker.lock();
        }
    }

    private void dlvWorkerUnlock() {
        if (this.dlvWorker != null) {
            this.dlvWorker.unlock();
        }
    }

    MsgDeliveryWorker getDeliveryWorker() {
        return this.dlvWorker;
    }

    void setDeliveryWorker(MsgDeliveryWorker worker) {
        this.dlvWorker = worker;
    }
}

