/*
 * Decompiled with CFR 0.152.
 */
package io.nats.benchmark;

import io.nats.benchmark.Sample;
import io.nats.benchmark.SampleGroup;
import io.nats.client.NUID;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Benchmark
extends Sample {
    private String name = null;
    private String runId = null;
    private final SampleGroup pubs = new SampleGroup(new SampleGroup[0]);
    private final SampleGroup subs = new SampleGroup(new SampleGroup[0]);
    private BlockingQueue<Sample> pubChannel;
    private BlockingQueue<Sample> subChannel;

    public Benchmark() {
    }

    public Benchmark(String name, int subCnt, int pubCnt) {
        this(name, NUID.nextGlobal(), subCnt, pubCnt);
    }

    public Benchmark(String name, String runId, int subCnt, int pubCnt) {
        this.name = name;
        this.runId = runId;
        this.subChannel = new LinkedBlockingQueue<Sample>();
        this.pubChannel = new LinkedBlockingQueue<Sample>();
    }

    public final void addPubSample(Sample sample) {
        this.pubChannel.add(sample);
    }

    public final void addSubSample(Sample sample) {
        this.subChannel.add(sample);
    }

    public final void close() {
        while (this.subChannel.size() > 0) {
            this.subs.addSample((Sample)this.subChannel.poll());
        }
        while (this.pubChannel.size() > 0) {
            this.pubs.addSample((Sample)this.pubChannel.poll());
        }
        if (this.subs.hasSamples()) {
            this.start = this.subs.getStart();
            this.end = this.subs.getEnd();
        } else {
            this.start = this.pubs.getStart();
            this.end = this.pubs.getEnd();
        }
        this.end = Math.min(this.end, this.subs.getEnd());
        this.end = Math.min(this.end, this.pubs.getEnd());
        this.msgBytes = this.pubs.msgBytes + this.subs.msgBytes;
        this.ioBytes = this.pubs.ioBytes + this.subs.ioBytes;
        this.msgCnt = this.pubs.msgCnt + this.subs.msgCnt;
        this.jobMsgCnt = this.pubs.jobMsgCnt + this.subs.jobMsgCnt;
    }

    public final String report() {
        String maybeTitle;
        StringBuilder sb = new StringBuilder();
        String indent = "";
        if (this.pubs.hasSamples() && this.subs.hasSamples()) {
            sb.append(String.format("%s Pub/Sub stats: %s\n", this.name, this));
            indent = indent + " ";
        }
        if (this.pubs.hasSamples()) {
            maybeTitle = "";
            if (!this.subs.hasSamples()) {
                maybeTitle = this.name + " ";
            }
            sb.append(String.format("%s%sPub stats: %s\n", indent, maybeTitle, this.pubs));
            if (this.pubs.getSamples().size() > 1) {
                for (Sample stat : this.pubs.getSamples()) {
                    sb.append(String.format("%s [%2d] %s (%d msgs)\n", indent, this.pubs.getSamples().indexOf(stat) + 1, stat, stat.jobMsgCnt));
                }
                sb.append(String.format("%s %s\n", indent, this.pubs.statistics()));
            }
        }
        if (this.subs.hasSamples()) {
            maybeTitle = "";
            sb.append(String.format("%s%sSub stats: %s\n", indent, maybeTitle, this.subs));
            if (this.subs.getSamples().size() > 1) {
                for (Sample stat : this.subs.getSamples()) {
                    sb.append(String.format("%s [%2d] %s (%d msgs)\n", indent, this.subs.getSamples().indexOf(stat) + 1, stat, stat.jobMsgCnt));
                }
                sb.append(String.format("%s %s\n", indent, this.subs.statistics()));
            }
        }
        return sb.toString();
    }

    public final List<String> csv() {
        ArrayList<String> lines = new ArrayList<String>();
        String header = "#RunID, ClientID, MsgCount, MsgBytes, MsgsPerSec, BytesPerSec, DurationSecs";
        lines.add(header);
        SampleGroup[] groups = new SampleGroup[]{this.subs, this.pubs};
        String pre = "S";
        int i = 0;
        for (SampleGroup grp : groups) {
            if (i++ == 1) {
                pre = "P";
            }
            int j = 0;
            for (Sample stat : grp.getSamples()) {
                String line = String.format("%s,%s%d,%d,%d,%d,%f,%f", this.runId, pre, j, stat.msgCnt, stat.msgBytes, stat.rate(), stat.throughput(), (double)stat.duration() / 1.0E9);
                lines.add(line);
            }
        }
        return lines;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getRunId() {
        return this.runId;
    }

    public final void setRunId(String runId) {
        this.runId = runId;
    }

    public final SampleGroup getPubs() {
        return this.pubs;
    }

    public final SampleGroup getSubs() {
        return this.subs;
    }
}

