(ns er-model.users.schema
  (:require
   [plumbing.core]
   [schema.core :as s #?@(:cljs [:include-macros true])]
   [schema.coerce :refer [coercer]]
   [er-model.schema :refer [x-json-coercion-matcher]]))

(def AuthUserSchema
  {:id s/Uuid
   :token s/Str
   :updated_at s/Inst})

(def auth-user-schema-coercer
  (coercer AuthUserSchema x-json-coercion-matcher))

(def UserSchema
  {:id s/Uuid

   :encrypted_password (s/maybe s/Str)
   :confirmation_token (s/maybe s/Str)
   :confirmed_at (s/maybe s/Inst)
   :reset_password_token (s/maybe s/Str)
   :login_token (s/maybe s/Str)

   :device_id #{s/Str}
   :email [s/Str]
   :phone_no [s/Str]
   :updated_at s/Inst})

(def ClientUserSchema
  (dissoc UserSchema
          :encrypted_password
          :confirmation_token
          :reset_password_token
          :login_token))

(def client-user-schema-coercer
  (coercer UserSchema x-json-coercion-matcher))
