(ns er-model.schema
  (:require
   [plumbing.core]
   [schema.core :as s #?@(:cljs [:include-macros true])]
   [schema.coerce :refer [coercer
                          keyword-enum-matcher
                          set-matcher
                          json-coercion-matcher]]))

#?(:cljs (defn string->inst
           [s]
           (new js/Date (js/Date.parse s))))

(def +x-json-coercions+
  (merge schema.coerce/+json-coercions+
         #?(:cljs {s/Inst string->inst})))

(defn x-json-coercion-matcher
  "A matcher that coerces keywords and keyword enums from strings, and longs and doubles
     from numbers on the JVM (without losing precision)"
  [schema]
  (or (+x-json-coercions+ schema)
      (keyword-enum-matcher schema)
      (set-matcher schema)))
