(ns er-model.orgs.schema
  (:require
   [plumbing.core]
   [schema.core :as s #?@(:cljs [:include-macros true])]
   [schema.coerce :refer [coercer]]
   [er-model.schema :refer [x-json-coercion-matcher]]))

(def OrgSchema
  {:id s/Uuid
   :name s/Str
   :updated_at s/Inst})

(def org-schema-coercer
  (coercer OrgSchema x-json-coercion-matcher))

(def OrgUserSchema
  {:org_id s/Uuid
   :user_id s/Uuid
   :name s/Str
   :username s/Str
   :updated_at s/Inst
   :auth_role #{s/Str}
   :profile_pic_url (s/maybe s/Str)
   :search_key #{s/Str}
   :sort_name (s/maybe s/Str)

   :profile_text (s/maybe s/Str)
   :location (s/maybe s/Str)
   :phone_no (s/maybe s/Str)
   :role (s/maybe s/Str)
   :skill [s/Str]})

(def org-user-schema-coercer
  (coercer OrgUserSchema x-json-coercion-matcher))
