(ns er-model.migrations-cassandra.20150926194828-create-user-groups-by-group-name
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150926194828."
  []
  (println "er-model.migrations-cassandra.20150926194828-create-user-groups-by-group-name up...")
  (execute
   "create table user_groups_by_group_sort_name
      (org_id timeuuid,
       user_id timeuuid,
       group_id timeuuid,
       group_sort_name text,
       primary key ((org_id, user_id), group_sort_name, group_id))"))

(defn down
  "Migrates the database down from version 20150926194828."
  []
  (println "er-model.migrations-cassandra.20150926194828-create-user-groups-by-group-name down...")
  (execute
   "drop table user_groups_by_group_sort_name"))
