(ns er-model.migrations-cassandra.20150828150546-create-user-recent-conversations
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150828150546."
  []
  (println "er-model.migrations-cassandra.20150828150546-create-user-recent-conversations up...")
  (execute
   "create table user_recent_conversations
      (org_id timeuuid,
       conversation_type text,
       conversation_id uuid,
       user_id timeuuid,
       last_message_id timeuuid,
       last_message_time timestamp,
       last_message_author_id timeuuid,
       last_message_body text,
       primary key ((org_id, user_id, conversation_type), last_message_time, conversation_id))
     with clustering order by (last_message_time desc)"))

(defn down
  "Migrates the database down from version 20150828150546."
  []
  (println "er-model.migrations-cassandra.20150828150546-create-user-recent-conversations down...")
  (execute
   "drop table user_recent_conversations"))
