(ns er-model.migrations-cassandra.20150804151456-create-users
  (:require [qbits.alia :as alia]
            [qbits.hayt :as h]
            [er-cassandra.drift.migration-helpers :refer :all]))

(defn up
  "Migrates the database up to version 20150804151456."
  []
  (println "er-model.migrations-cassandra.20150804151456-create-users up...")
  (execute
   "create table users (id timeuuid,
                        updated_at timestamp,
                        confirmed_at timestamp,
                        confirmation_token text,
                        login_token text,
                        reset_password_token text,
                        encrypted_password text,
                        email list<text>,
                        phone_no list<text>,
                        device_id set<text>,
                        primary key (id))"))

(defn down
  "Migrates the database down from version 20150804151456."
  []
  (println "er-model.migrations-cassandra.20150804151456-create-users down...")
  (execute
   "drop table users"))
