(ns er-model.messages
  (:require
   [plumbing.core]
   [schema.core :as s #?@(:cljs [:include-macros true])]))

(def MessageSchema
  {:org_id s/Uuid
   :conversation_id s/Uuid
   :id s/Uuid
   :author_id s/Uuid
   :message_time s/Inst
   :body s/Str
   :type (s/maybe s/Str)})

;; same as above, but with javascripty fields
;; should really use transit to get UUIDs and insts
(def StringMessageSchema
  {:org_id s/Str
   :conversation_id s/Str
   :id s/Str
   :author_id s/Str
   :message_time s/Str
   :body s/Str
   :type (s/maybe s/Str)})
