(ns {{ns-name}}.routes.services.graphql
  (:require
    [clj-time.coerce :as tc]
    [clojure.core.async :as a]
    [clojure.edn :as edn]
    [clojure.java.io :as io]
    [clojure.tools.logging :as l]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.utils :as u]
    [{{ns-name}}.utilsc :as uc]
    [de.elbenwald.app-common.utils :as acu]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [medley.core :as m]
    [mount.core :refer [defstate]]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f]))

(defn get-data
  "TODO doc"
  [context args value]
  (letk [[app] context]
    (p/GetData app)))

(defn set-data
  "TODO doc"
  [context args value]
  (letk [[app] context
         [data] args]
    (p/SetData app data)))

(defstate compiled-schema
  :start
  (acu/compile-schema {:resolvers (->m get-data
                                       set-data)
                       :scalar-transformers (->m)
                       :schema "graphql/schema.edn"
                       :streamers (->m)}))
