/*
 * Copyright (c) 2018, FusionAuth, All Rights Reserved
 */

"use strict";

var FusionAuth = FusionAuth || {};

var baseURL = window.location.href;
var index = baseURL.lastIndexOf(window.location.pathname);
baseURL = baseURL.substr(0, index);

var successHandler = function() {
  window.location = baseURL + '/login';
};

var loginCallback = function(encodedJWT) {
  new Prime.Ajax.Request(baseURL + '/ajax/login', 'POST')
      .withHeader('Authorization', 'JWT ' + encodedJWT)
      .withSuccessHandler(successHandler)
      .go();
};

var logoutCallback = function() {
  window.location = baseURL + '/login-test';
};

FusionAuth.LoginWidget = new FusionAuthLogin(baseURL, '3c219e58-ed0e-4b18-ad48-f4f92793ae32')
    .withLoginCallback(loginCallback)
    .withLogoutCallback(logoutCallback)
    .withLogoutSelector('nav ul li a[href="/logout"]')
    .withGravatarEnabled(true);