(defproject elbenwald-template/lein-template "0.25.0"
  :description "Elbenwald Lein Template"
  :url "http://www.elbenwald.de"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :repositories [["releases" {:url "s3p://ew-tools/releases"
                              :creds :gpg}]]

  :plugins [[s3-wagon-private "1.3.1" :exclusions [commons-logging]]]

  :dependencies [[org.clojure/clojure "1.10.1"]
                 [proto-repl "0.3.1"]
                 [org.clojure/core.cache "0.8.2"]
                 [org.springframework/spring-core "5.2.1.RELEASE"]
                 [stencil "0.5.0"]
                 [me.raynes/fs "1.4.6"]]

  :resource-paths ["resources"
                   "resources/leiningen/new/elbenwald_template/all/mustache_partials"
                   "resources/leiningen/new/elbenwald_template/test/mustache_partials"]

  :profiles
  {:release {:release-tasks [["vcs" "assert-committed"]
                             ["change" "version" "leiningen.release/bump-version" "release"]
                             ["vcs" "commit"]]}
   :deploy {:release-tasks [["vcs" "assert-committed"]
                            ["vcs" "tag"]
                            ["deploy"]]}
                            ;["vcs" "push"] ; FIXME store ssh password
   :snapshot {:release-tasks [["vcs" "assert-committed"]
                              ["change" "version" "leiningen.release/bump-version"]
                              ["vcs" "commit"]]}}

  :release-tasks []
  :deploy-branches ["master"]

  :eval-in-leiningen true)
