(ns user
  "Userspace functions you can run by default in your local REPL."
  (:require
    [clojure.spec.alpha :as s]
    [{{ns-name}}.config :refer [env]]
    [{{ns-name}}.core :refer [start-app]]
    [{{ns-name}}.figwheel :refer [start-fw stop-fw cljs]]
    [expound.alpha :as expound]
    [mount.core :as mount]))

(alter-var-root #'s/*explain-out* (constantly expound/printer))

(add-tap (bound-fn* clojure.pprint/pprint))

(defn start
  "Starts application.
  You'll usually want to run this on startup."
  []
  (mount/start-without #'{{ns-name}}.core/repl-server))

(defn stop
  "Stops application."
  []
  (mount/stop-except #'{{ns-name}}.core/repl-server))

(defn restart
  "Restarts application."
  []
  (stop)
  (start))
