(ns {{ns-name}}.env
  (:require
    [clojure.tools.logging :as l]
    [{{ns-name}}.app :as app]
    [{{ns-name}}.env-middleware :refer [wrap-env]]
    [de.elbenwald.app-common.graphql :as acq]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [de.elbenwald.fusion-auth.core :as fac]
    [de.elbenwald.fusion-auth.dummy :as fad]
    [de.elbenwald.security.core :as esc]
    [plumbing.core :refer :all]
    [selmer.parser :as parser]))

(defn configure-fusion-auth-factory
  "TODO doc"
  [component-factory env]
  (letk [[[:fusion-auth
           factory
           options]] env]
    (case factory
      :fusion-auth/dummy
      (fad/configure-fusion-auth-factory component-factory options)

      :fusion-auth/genuine
      (fac/configure-fusion-auth-factory component-factory options))))

(defnk make-component-factory
  "TODO doc"
  [:as env]
  (-> (eci/new-common-component-factory)
    (configure-fusion-auth-factory env)
    (esc/configure-access-logging-factory {})
    (esc/configure-authentication-factory {})
    (esc/configure-authorization-factory {})
    (esc/configure-web-security-factory {})
    (acq/configure-graphql-factory {})
    (app/configure-app-factory {})
    (as-> $ (eci/new-component-factory {} $))))

(def defaults
  {:init
   (fn []
     (parser/cache-off!)
     (l/info "\n-=[{{ns-name}} started successfully using the {{profile}} profile]=-"))

   :stop
   (fn []
     (l/info "\n-=[{{ns-name}} has shut down successfully]=-"))

   :middleware wrap-env
   :make-component-factory make-component-factory})
