(ns {{ns-name}}.core
  (:require
    [clojure.spec.alpha :as s]
    [clojure.tools.logging :as l]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.utils :refer :all]
    [medley.core :as m]
    [orchestra.core :refer [defn-spec]]
    [plumbing.core :refer :all]
    [taoensso.encore :as e]
    [uncomplicate.fluokitten.core :as f]))

(s/def ::context (s/map-of keyword? any?))

(defn-spec do-things number?
  [context ::context]
  (letk [[x
          y] context]
    (+ x y)))

(defnew p/Lib)

(defnk new-lib
  "TODO doc"
  [data]
  (letk [[a
          b] data]
    (new+lib {:x a
              :y b})))

;
; component factory
;

(defdecorator p/Lib)

(defn configure-lib-factory
  "Adds a lib factory to the given component factory."
  [component-factory options]
  (letk [f (fnk [error-mode
                 data]
             (letk [eh-decorator (eci/get-eh-decorator error-mode :none)]
               (cond-> (new-lib (->m data))
                 eh-decorator (decorate+lib eh-decorator))))]
    (eci/new-component-factory {:lib f} component-factory)))
