(ns {{ns-name}}.scheduling
  (:require
    [clj-time.core :as t]
    [clojure.core.async :as a]
    [clojure.tools.logging :as l]
    [{{ns-name}}.protocols :as p]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.scheduling :as ecs]
    [de.elbenwald.common.utils :refer :all]
    [medley.core :as m]
    [plumbing.core :refer :all]
    [plumbing.graph :as g]
    [taoensso.encore :as e]
    [uncomplicate.fluokitten.core :as f]))

(defnk make-scheduler-service
  "TODO doc"
  [app
   name
   scheduling-infos
   timeout-msec
   timer]
  (l/info "make-scheduler-service" (pr-str scheduling-infos))
  (let [context {}

        cronjobs-makers {}

        schedulers (ecs/make-schedulers (->m cronjobs-makers
                                             scheduling-infos
                                             timer))

        agent-actions {}

        the-agent (eci/make-logging-agent (->m app)
                                          [name
                                           timeout-msec])]

    (ecs/new-scheduler-service (->m agent-actions
                                    schedulers
                                    the-agent
                                    timeout-msec))))
